/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.registry;

import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.sis.referencing.CRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class MathTransformRegistry {
    private static final MultiKeyMap<CoordinateReferenceSystem, MathTransform> MATH_TRANSFORM_REGISTRY = MultiKeyMap.multiKeyMap(new HashedMap());

    public static final synchronized MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException, MismatchedDimensionException, TransformException {
        MathTransform transform;
        MultiKey<CoordinateReferenceSystem> key = new MultiKey<CoordinateReferenceSystem>(sourceCRS, targetCRS);
        if (MATH_TRANSFORM_REGISTRY.containsKey(key)) {
            transform = (MathTransform)MATH_TRANSFORM_REGISTRY.get(key);
        } else {
            transform = CRS.findOperation(sourceCRS, targetCRS, null).getMathTransform();
            MATH_TRANSFORM_REGISTRY.put(key, transform);
        }
        return transform;
    }

    public static final synchronized void clear() {
        MATH_TRANSFORM_REGISTRY.clear();
    }
}

