/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.geo.topological.GenericPropertyFunction;
import org.apache.jena.geosparql.implementation.index.CacheConfiguration;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class QueryRewriteIndex {
    private boolean indexActive;
    private Cache<Triple, Boolean> index;
    private static int MAP_SIZE_DEFAULT = -1;
    private static long MAP_EXPIRY_INTERVAL_DEFAULT = 5000L;
    public static final Symbol QUERY_REWRITE_INDEX_SYMBOL = Symbol.create("http://jena.apache.org/spatial#query-index");

    public QueryRewriteIndex() {
        this.indexActive = GeoSPARQLConfig.isQueryRewriteEnabled();
        this.index = CacheConfiguration.create(MAP_SIZE_DEFAULT, MAP_EXPIRY_INTERVAL_DEFAULT);
    }

    public QueryRewriteIndex(String queryRewriteLabel, int maxSize, long expiryInterval) {
        this.indexActive = true;
        this.index = CacheConfiguration.create(maxSize, expiryInterval);
    }

    public final Boolean test(Node subjectGeometryLiteral, Node predicate, Node objectGeometryLiteral, GenericPropertyFunction propertyFunction) {
        if (!subjectGeometryLiteral.isLiteral() || !objectGeometryLiteral.isLiteral()) {
            return false;
        }
        if (this.indexActive) {
            Triple key = Triple.create(subjectGeometryLiteral, predicate, objectGeometryLiteral);
            try {
                return this.index.get(key, k -> propertyFunction.testFilterFunction(subjectGeometryLiteral, objectGeometryLiteral));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return propertyFunction.testFilterFunction(subjectGeometryLiteral, objectGeometryLiteral);
    }

    public final void clear() {
        this.index.clear();
    }

    public boolean isIndexActive() {
        return this.indexActive;
    }

    public Model toModel() {
        Graph graph = GraphFactory.createDefaultGraph();
        Iterator<Triple> it = this.index.keys();
        while (it.hasNext()) {
            Triple key = it.next();
            Boolean value = this.index.getIfPresent(key);
            if (value == null || !value.booleanValue()) continue;
            graph.add(key);
        }
        return ModelFactory.createModelForGraph(graph);
    }

    public final void setActive(boolean indexActive) {
        this.indexActive = indexActive;
    }

    public final long getIndexSize() {
        return this.index.size();
    }

    public void reset(int maxSize, long expiryInterval) {
        this.index = CacheConfiguration.create(maxSize, expiryInterval);
    }

    public static final void setMaxSize(int mapSizeDefault) {
        MAP_SIZE_DEFAULT = mapSizeDefault;
    }

    public static final void setExpiry(long mapExpiryIntervalDefault) {
        MAP_EXPIRY_INTERVAL_DEFAULT = mapExpiryIntervalDefault;
    }

    public static final QueryRewriteIndex createDefault() {
        return new QueryRewriteIndex();
    }

    public static final void prepare(Dataset dataset) {
        Context context2 = dataset.getContext();
        context2.set(QUERY_REWRITE_INDEX_SYMBOL, QueryRewriteIndex.createDefault());
    }

    public static final void prepare(Dataset dataset, String queryRewriteLabel, int maxSize, long expiryInterval) {
        Context context2 = dataset.getContext();
        context2.set(QUERY_REWRITE_INDEX_SYMBOL, new QueryRewriteIndex(queryRewriteLabel, maxSize, expiryInterval));
    }

    public static final QueryRewriteIndex retrieve(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        return QueryRewriteIndex.retrieve(context2);
    }

    public static final QueryRewriteIndex retrieve(Dataset dataset) {
        Context context2 = dataset.getContext();
        return QueryRewriteIndex.retrieve(context2);
    }

    public static final QueryRewriteIndex retrieve(Context context2) {
        QueryRewriteIndex queryRewriteIndex = context2.get(QUERY_REWRITE_INDEX_SYMBOL, null);
        if (queryRewriteIndex == null) {
            queryRewriteIndex = QueryRewriteIndex.createDefault();
            context2.set(QUERY_REWRITE_INDEX_SYMBOL, queryRewriteIndex);
        }
        return queryRewriteIndex;
    }

    public static final Dataset wrapModel(Model model) {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.setDefaultModel(model);
        QueryRewriteIndex.prepare(dataset);
        return dataset;
    }
}

