/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.great_circle;

import org.apache.jena.geosparql.implementation.great_circle.LatLonPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public class Azimuth {
    private static final double RADIANS_ADJUST = Math.PI * 2;

    public static final double find(double lat1, double lon1, double lat2, double lon2) {
        double lat1Rad = Math.toRadians(lat1);
        double lat2Rad = Math.toRadians(lat2);
        double diffLonRad = Math.toRadians(lon2 - lon1);
        double x = Math.cos(lat1Rad) * Math.sin(lat2Rad) - Math.sin(lat1Rad) * Math.cos(lat2Rad) * Math.cos(diffLonRad);
        double y = Math.sin(diffLonRad) * Math.cos(lat2Rad);
        double azimuth = Math.atan2(y, x);
        if (azimuth < 0.0) {
            return azimuth + Math.PI * 2;
        }
        return azimuth;
    }

    public static final double find(LatLonPoint point1, LatLonPoint point2) {
        double lat1 = point1.getLat();
        double lon1 = point1.getLon();
        double lat2 = point2.getLat();
        double lon2 = point2.getLon();
        return Azimuth.find(lat1, lon1, lat2, lon2);
    }

    public static final double find(Point point1, Point point2) {
        double lat1 = point1.getY();
        double lon1 = point1.getX();
        double lat2 = point2.getY();
        double lon2 = point2.getX();
        return Azimuth.find(lat1, lon1, lat2, lon2);
    }

    public static final double find(Coordinate coord1, Coordinate coord2) {
        double lat1 = coord1.getY();
        double lon1 = coord1.getX();
        double lat2 = coord2.getY();
        double lon2 = coord2.getX();
        return Azimuth.find(lat1, lon1, lat2, lon2);
    }
}

