/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.admin;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.jena.fuseki.Fuseki;
import org.slf4j.Logger;

public class LocalhostOnly
implements Filter {
    private static String LOCALHOST_IpV6_a = "[0:0:0:0:0:0:0:1]";
    private static String LOCALHOST_IpV6_b = "0:0:0:0:0:0:0:1";
    private static String LOCALHOST_IpV6_c = "[::1]";
    private static String LOCALHOST_IpV4 = "127.0.0.1";
    private static final Collection<String> localhosts = new HashSet<String>(Arrays.asList(LOCALHOST_IpV4, LOCALHOST_IpV6_a, LOCALHOST_IpV6_b, LOCALHOST_IpV6_c));
    private static Logger log = Fuseki.serverLog;
    private List<String> secured = Arrays.asList("/$/backup", "/$/compact", "/$/datasets");

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            boolean accept = this.checkRequest(req, resp);
            if (!accept) {
                resp.sendError(403);
                return;
            }
        }
        catch (Throwable ex) {
            log.info("Filter: unexpected exception: " + ex.getMessage(), ex);
        }
        chain.doFilter(request, response);
    }

    public boolean checkRequest(HttpServletRequest req, HttpServletResponse resp) {
        String uri = req.getRequestURI();
        for (String s : this.secured) {
            if (!uri.startsWith(s) || LocalhostOnly.checkLocalhost(req)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkLocalhost(HttpServletRequest request) {
        return localhosts.contains(request.getRemoteAddr());
    }
}

