/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.ctl.ActionAsyncTask;
import org.apache.jena.fuseki.ctl.TaskBase;
import org.apache.jena.fuseki.mgt.Backup;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.slf4j.Logger;

public class ActionBackup
extends ActionAsyncTask {
    public ActionBackup() {
        super("Backup");
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected Runnable createRunnable(HttpAction action) {
        String name = ActionBackup.getItemName(action);
        if (name == null) {
            action.log.error("Null for dataset name in item request");
            ServletOps.errorOccurred("Null for dataset name in item request");
            return null;
        }
        action.log.info(String.format("[%d] Backup dataset %s", action.id, name));
        BackupTask task = new BackupTask(action);
        if (task.dataset == null) {
            ServletOps.errorBadRequest("Dataset not found");
            return null;
        }
        return task;
    }

    static class BackupTask
    extends TaskBase {
        private static Logger log = Fuseki.backupLog;

        public BackupTask(HttpAction action) {
            super(action);
        }

        @Override
        public void run() {
            try {
                String backupFilename = Backup.chooseFileName(this.datasetName);
                log.info(String.format("[%d] >>>> Start backup %s -> %s", this.actionId, this.datasetName, backupFilename));
                Backup.backup(this.transactional, this.dataset, backupFilename);
                log.info(String.format("[%d] <<<< Finish backup %s -> %s", this.actionId, this.datasetName, backupFilename));
            }
            catch (Throwable ex) {
                log.warn(String.format("[%d] **** Exception in backup", this.actionId), ex);
                throw ex;
            }
        }
    }
}

