/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.engine.Mappers;
import org.apache.jena.rdfs.engine.MatchRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class InfFindQuad
extends MatchRDFS<Node, Quad> {
    private final DatasetGraph dsg;
    private Node graph;

    private InfFindQuad(int dummy, ConfigRDFS<Node> setup, Node g, DatasetGraph dsg) {
        super(setup, Mappers.mapperQuad(g));
        if (g == null || !g.isConcrete()) {
            throw new IllegalArgumentException("Quad/MatchRDFS must have a concrete graph name");
        }
        this.graph = g;
        this.dsg = dsg;
    }

    @Override
    public Stream<Quad> sourceFind(Node s, Node p, Node o) {
        Iterator<Quad> iter = this.dsg.find(this.graph, s, p, o);
        Stream<Quad> stream = Iter.asStream(iter);
        return stream;
    }

    @Override
    protected boolean sourceContains(Node s, Node p, Node o) {
        return this.dsg.contains(this.graph, s, p, o);
    }

    @Override
    protected Quad dstCreate(Node s, Node p, Node o) {
        return Quad.create(this.graph, s, p, o);
    }
}

