/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jcs.JsonCanonicalizer;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.RdfQuadEmitter;
import com.apicatalog.jsonld.deseralization.RdfTripleConsumer;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfDatasetSupplier;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public final class JsonLdToRdf {
    private static final Logger LOGGER = Logger.getLogger(JsonLdToRdf.class.getName());
    private static final DecimalFormat xsdNumberFormat = new DecimalFormat("0.0##############E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final NodeMap nodeMap;
    private boolean produceGeneralizedRdf;
    private JsonLdOptions.RdfDirection rdfDirection;
    private UriValidationPolicy uriValidation;
    private RdfDataset dataset;

    private JsonLdToRdf(NodeMap nodeMap, RdfDataset dataset) {
        this.nodeMap = nodeMap;
        this.dataset = dataset;
        this.produceGeneralizedRdf = false;
        this.rdfDirection = null;
        this.uriValidation = JsonLdOptions.DEFAULT_URI_VALIDATION;
    }

    @Deprecated
    public static final JsonLdToRdf with(NodeMap nodeMap, RdfDataset dataset) {
        return new JsonLdToRdf(nodeMap, dataset);
    }

    public static final JsonLdToRdf with(NodeMap nodeMap) {
        return new JsonLdToRdf(nodeMap, null);
    }

    public JsonLdToRdf produceGeneralizedRdf(boolean enable) {
        this.produceGeneralizedRdf = enable;
        return this;
    }

    public JsonLdToRdf rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public void provide(RdfQuadConsumer consumer) throws JsonLdError {
        try {
            this.from(RdfQuadEmitter.newInstance(consumer));
        }
        catch (RdfConsumerException e2) {
            if (e2.getCause() instanceof JsonLdError) {
                throw (JsonLdError)e2.getCause();
            }
            throw new JsonLdError(JsonLdErrorCode.UNSPECIFIED, (Throwable)e2);
        }
    }

    protected void from(RdfTripleConsumer consumer) throws JsonLdError, RdfConsumerException {
        for (String graphName : Utils.index(this.nodeMap.graphs(), true)) {
            if ("@default".equals(graphName)) {
                consumer.defaultGraph();
            } else if (BlankNode.isWellFormed(graphName)) {
                consumer.namedGraph(graphName);
            } else {
                if (!UriUtils.isAbsoluteUri(graphName, this.uriValidation)) continue;
                consumer.namedGraph(graphName);
            }
            for (String subject : Utils.index(this.nodeMap.subjects(graphName), true)) {
                if (!BlankNode.isWellFormed(subject) && UriUtils.isNotAbsoluteUri(subject, this.uriValidation)) {
                    LOGGER.log(Level.WARNING, "Non well-formed subject [{0}] has been skipped.", subject);
                    continue;
                }
                for (String property : Utils.index(this.nodeMap.properties(graphName, subject), true)) {
                    if ("@type".equals(property)) {
                        for (JsonValue type : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                            String typeString;
                            if (JsonUtils.isNotString(type) || !BlankNode.isWellFormed(typeString = ((JsonString)type).getString()) && UriUtils.isNotAbsoluteUri(typeString, this.uriValidation)) continue;
                            consumer.triple(subject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeString);
                        }
                        continue;
                    }
                    if (Keywords.contains(property) || (!BlankNode.isWellFormed(property) || this.produceGeneralizedRdf) && UriUtils.isNotAbsoluteUri(property, this.uriValidation)) continue;
                    for (JsonValue item : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                        this.fromObject(consumer, item.asJsonObject(), subject, property);
                    }
                }
            }
        }
    }

    @Deprecated
    public RdfDataset build() throws JsonLdError {
        if (this.dataset == null) {
            this.dataset = Rdf.createDataset();
        }
        this.provide(new RdfDatasetSupplier(this.dataset));
        return this.dataset;
    }

    @Deprecated
    public JsonLdToRdf uriValidation(boolean enabled) {
        return this.uriValidation(enabled ? UriValidationPolicy.Full : UriValidationPolicy.SchemeOnly);
    }

    public JsonLdToRdf uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    private void fromObject(RdfTripleConsumer consumer, JsonObject item, String subject, String predicate) throws JsonLdError, RdfConsumerException {
        String datatype;
        if (NodeObject.isNodeObject(item)) {
            JsonValue id = (JsonValue)item.get("@id");
            if (JsonUtils.isNotString(id) || JsonUtils.isNull(id)) {
                return;
            }
            String idString = ((JsonString)id).getString();
            if (BlankNode.isWellFormed(idString) || UriUtils.isAbsoluteUri(idString, this.uriValidation)) {
                consumer.triple(subject, predicate, idString);
            }
            return;
        }
        if (ListObject.isListObject(item)) {
            this.fromList(consumer, ((JsonValue)item.get("@list")).asJsonArray(), subject, predicate);
        }
        if (!ValueObject.isValueObject(item)) {
            return;
        }
        JsonValue value = (JsonValue)item.get("@value");
        String string = datatype = item.containsKey("@type") && JsonUtils.isString((JsonValue)item.get("@type")) ? item.getString("@type") : null;
        if (datatype != null && !"@json".equals(datatype) && !UriUtils.isAbsoluteUri(datatype, this.uriValidation)) {
            LOGGER.log(Level.WARNING, "Datatype [{0}] is not an absolute IRI nor @json and value is skipped.", datatype);
            return;
        }
        if (item.containsKey("@language") && (JsonUtils.isNotString((JsonValue)item.get("@language")) || !LanguageTag.isWellFormed(item.getString("@language")))) {
            LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed string and value is skipped.", item.get("@language"));
            return;
        }
        String valueString = null;
        if ("@json".equals(datatype)) {
            valueString = JsonCanonicalizer.canonize(value);
            datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON";
        } else if (JsonUtils.isTrue(value)) {
            valueString = "true";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isFalse(value)) {
            valueString = "false";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (JsonUtils.isNumber(value)) {
            JsonNumber number = (JsonNumber)value;
            if (!number.isIntegral() && number.doubleValue() % -1.0 != 0.0 || "http://www.w3.org/2001/XMLSchema#double".equals(datatype) || "http://www.w3.org/2001/XMLSchema#float".equals(datatype) || number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0) {
                valueString = JsonLdToRdf.toXsdDouble(number.bigDecimalValue());
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#double";
                }
            } else {
                valueString = number.bigIntegerValue().toString();
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#integer";
                }
            }
        } else if (datatype == null) {
            String string2 = datatype = item.containsKey("@language") ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string";
        }
        if (valueString == null) {
            if (JsonUtils.isNotString(value)) {
                return;
            }
            valueString = ((JsonString)value).getString();
        }
        if (item.containsKey("@direction") && this.rdfDirection != null) {
            String language;
            String string3 = language = item.containsKey("@language") ? item.getString("@language").toLowerCase() : "";
            if (JsonLdOptions.RdfDirection.I18N_DATATYPE == this.rdfDirection) {
                consumer.triple(subject, predicate, valueString, language, item.getString("@direction"));
            } else if (JsonLdOptions.RdfDirection.COMPOUND_LITERAL == this.rdfDirection) {
                String blankNodeId = this.nodeMap.createIdentifier();
                consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#value", valueString, "http://www.w3.org/2001/XMLSchema#string");
                if (item.containsKey("@language") && JsonUtils.isString((JsonValue)item.get("@language"))) {
                    consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#language", item.getString("@language").toLowerCase(), "http://www.w3.org/2001/XMLSchema#string");
                }
                consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction", item.getString("@direction"), "http://www.w3.org/2001/XMLSchema#string");
                consumer.triple(subject, predicate, blankNodeId);
                return;
            }
        } else if (item.containsKey("@language") && JsonUtils.isString((JsonValue)item.get("@language"))) {
            consumer.triple(subject, predicate, valueString, item.getString("@language"), null);
        } else {
            consumer.triple(subject, predicate, valueString, datatype);
        }
    }

    private void fromList(RdfTripleConsumer consumer, JsonArray list, String subject, String predicate) throws JsonLdError, RdfConsumerException {
        if (JsonUtils.isEmptyArray(list)) {
            consumer.triple(subject, predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            return;
        }
        String[] bnodes = new String[list.size()];
        IntStream.range(0, bnodes.length).forEach(i -> {
            bnodes[i] = this.nodeMap.createIdentifier();
        });
        consumer.triple(subject, predicate, bnodes[0]);
        int index = 0;
        for (JsonValue item : list) {
            String blankNodeSubject = bnodes[index];
            this.fromObject(consumer, item.asJsonObject(), blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
            if (++index < bnodes.length) {
                consumer.triple(blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", bnodes[index]);
                continue;
            }
            consumer.triple(blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        }
    }

    private static final String toXsdDouble(BigDecimal bigDecimal) {
        return xsdNumberFormat.format(bigDecimal);
    }

    static {
        xsdNumberFormat.setMinimumFractionDigits(1);
    }
}

