/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.env;

import java.util.function.Function;
import org.apache.shiro.config.Ini;
import org.apache.shiro.env.DefaultEnvironment;
import org.apache.shiro.ini.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;

public class BasicIniEnvironment
extends DefaultEnvironment {
    public static final String INI_REALM_NAME = "iniRealm";

    public BasicIniEnvironment(Ini ini) {
        this(ini, (String name) -> null);
    }

    public BasicIniEnvironment(Ini ini, Function<String, ?> alternateObjectSupplier) {
        IniSecurityManagerFactory securityManagerFactory = new IniSecurityManagerFactory(ini);
        securityManagerFactory.getReflectionBuilder().setAlternateObjectSupplier(alternateObjectSupplier);
        this.setSecurityManager((SecurityManager)securityManagerFactory.getInstance());
    }

    public BasicIniEnvironment(String iniResourcePath) {
        this(Ini.fromResourcePath(iniResourcePath));
    }

    public BasicIniEnvironment(String iniResourcePath, Function<String, ?> alternateObjectSupplier) {
        this(Ini.fromResourcePath(iniResourcePath), alternateObjectSupplier);
    }
}

