/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.crypto.hash.SimpleHashRequest;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;

public interface HashRequest {
    public ByteSource getSource();

    public Optional<ByteSource> getSalt();

    public Optional<String> getAlgorithmName();

    public Map<String, Object> getParameters();

    public static class Builder {
        private ByteSource source;
        private ByteSource salt = SimpleByteSource.empty();
        private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();
        private String algorithmName;

        public Builder setSource(ByteSource source) {
            this.source = source;
            return this;
        }

        public Builder setSource(Object source) throws IllegalArgumentException {
            this.source = ByteSource.Util.bytes(source);
            return this;
        }

        public Builder setSalt(ByteSource salt) {
            this.salt = salt;
            return this;
        }

        public Builder setSalt(Object salt) throws IllegalArgumentException {
            this.salt = ByteSource.Util.bytes(salt);
            return this;
        }

        public Builder addParameter(String parameterName, Object parameterValue) {
            this.parameters.put(parameterName, Objects.requireNonNull(parameterValue));
            return this;
        }

        public Builder withParameters(Map<String, Object> parameters) {
            this.parameters.clear();
            this.parameters.putAll(Objects.requireNonNull(parameters));
            return this;
        }

        public Builder setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public HashRequest build() {
            return new SimpleHashRequest(this.algorithmName, this.source, this.salt, this.parameters);
        }
    }
}

