/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.VectorUtil;

public class ConstKnnFloatValueSource
extends ValueSource {
    private final float[] vector;

    public ConstKnnFloatValueSource(float[] constVector) {
        this.vector = VectorUtil.checkFinite(Objects.requireNonNull(constVector, "constVector"));
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context2, LeafReaderContext readerContext) throws IOException {
        return new FunctionValues(){

            @Override
            public float[] floatVectorVal(int doc) {
                return ConstKnnFloatValueSource.this.vector;
            }

            @Override
            public String strVal(int doc) {
                return Arrays.toString(ConstKnnFloatValueSource.this.vector);
            }

            @Override
            public String toString(int doc) throws IOException {
                return ConstKnnFloatValueSource.this.description() + "=" + this.strVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstKnnFloatValueSource other = (ConstKnnFloatValueSource)o;
        return Arrays.equals(this.vector, other.vector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().hashCode(), Arrays.hashCode(this.vector));
    }

    @Override
    public String description() {
        return "ConstKnnFloatValueSource(" + Arrays.toString(this.vector) + ")";
    }
}

