/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.base.Sys;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.sys.IO_DB;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.sse.SSE_ParseException;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.params.StoreParamsBuilder;
import org.apache.jena.tdb2.params.StoreParamsCodec;
import org.apache.jena.tdb2.params.StoreParamsFactory;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.CopyDSG;
import org.apache.jena.tdb2.sys.DatabaseOpsWindows;
import org.apache.jena.tdb2.sys.FilenameUtils;
import org.apache.jena.tdb2.sys.StoreConnection;
import org.apache.jena.tdb2.sys.SystemTDB;
import org.apache.jena.tdb2.sys.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseOps {
    private static Logger LOG = LoggerFactory.getLogger(DatabaseOps.class);
    public static final String dbNameBase = "Data";
    public static final String SEP = "-";
    public static final String dbSuffixPattern = "[\\d]+";
    public static final String startCount = "0001";
    private static final String dbTmpSuffix = "-tmp";
    private static final String dbTmpPattern = "[\\d]+-tmp";
    private static final String BACKUPS_DIR = "Backups";
    private static final String BACKUPS_FN = "backup";
    static final String incompleteWIP = "jena-tdb-temp-files";
    private static boolean warnAboutOptimizer = true;
    private static Object compactionLock = new Object();
    private static Pattern numberPattern = Pattern.compile("[\\d]+");

    static DatasetGraph create(Location location, StoreParams params, ReorderTransformation reorderTransform) {
        return DatabaseOps.createSwitchable(location, params, reorderTransform);
    }

    private static DatasetGraphSwitchable createSwitchable(Location containerLocation, StoreParams appParams, ReorderTransformation appReorderTransform) {
        if (containerLocation.isMem()) {
            Location storageLocation = containerLocation;
            StoreParams params = appParams != null ? appParams : StoreParams.getDftMemStoreParams();
            ReorderTransformation reorderTransform = appReorderTransform != null ? appReorderTransform : ReorderLib.fixed();
            DatasetGraph dsg = StoreConnection.connectCreate(storageLocation, params, reorderTransform).getDatasetGraph();
            return new DatasetGraphSwitchable(null, containerLocation, dsg);
        }
        if (!containerLocation.exists()) {
            throw new TDBException("No such location: " + String.valueOf(containerLocation));
        }
        Path path = IO_DB.asPath(containerLocation);
        DatabaseOps.cleanDatabaseDirectory(path);
        Path existingStorage = DatabaseOps.findStorageLocation(path);
        boolean isNewArea = existingStorage == null;
        Path db = existingStorage;
        if (db == null) {
            db = path.resolve("Data-0001");
            IOX.createDirectory(db);
        }
        Location storageLocation = IO_DB.asLocation(db);
        StoreParams switchableParams = StoreParamsCodec.read(containerLocation);
        StoreParams storageParams = StoreParamsCodec.read(storageLocation);
        StoreParams dftParams = containerLocation.isMem() ? StoreParams.getDftMemStoreParams() : StoreParams.getDftStoreParams();
        StoreParams params = StoreParamsFactory.decideStoreParams(null, isNewArea, appParams, switchableParams, storageParams, dftParams);
        if (isNewArea && switchableParams == null && storageParams == null && !params.equals(dftParams)) {
            StoreParamsCodec.write(containerLocation, params);
        }
        ReorderTransformation reorderTransform = appReorderTransform;
        reorderTransform = DatabaseOps.maybeTransform(reorderTransform, storageLocation);
        if ((reorderTransform = DatabaseOps.maybeTransform(reorderTransform, containerLocation)) == null) {
            reorderTransform = SystemTDB.getDefaultReorderTransform();
        }
        if (reorderTransform == null && warnAboutOptimizer) {
            ARQ.getExecLogger().warn("No BGP optimizer");
        }
        DatasetGraphTDB dsg = StoreConnection.connectCreate(storageLocation, params, reorderTransform).getDatasetGraphTDB();
        DatasetGraphSwitchable appDSG = new DatasetGraphSwitchable(path, containerLocation, dsg);
        return appDSG;
    }

    private static void cleanDatabaseDirectory(Path containerDirectory) {
        List<Path> tmpDirs = DatabaseOps.scanForDirByPattern(containerDirectory, dbNameBase, SEP, dbTmpPattern, ScanAccept.SKIP);
        for (Path dir : tmpDirs) {
            FmtLog.info(LOG, "Remove incomplete compaction temporary directory: " + String.valueOf(dir), new Object[0]);
            IO.deleteAll(dir);
        }
        try {
            Path workfileList = containerDirectory.resolve(incompleteWIP);
            if (Files.exists(workfileList, new LinkOption[0])) {
                List<String> filenames = Files.readAllLines(workfileList);
                for (String fn : filenames) {
                    FmtLog.info(LOG, "Remove incomplete work-in-progress: " + fn, new Object[0]);
                    Path path = Path.of(fn, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    try {
                        IO.deleteAll(path);
                    }
                    catch (Throwable ex) {
                        FmtLog.error(LOG, "Exception while deleting " + fn + " : manual clean-up required", new Object[0]);
                    }
                }
                Files.delete(workfileList);
            }
        }
        catch (IOException e2) {
            throw IOX.exception(e2);
        }
    }

    private static ReorderTransformation maybeTransform(ReorderTransformation reorderTransform, Location location) {
        if (reorderTransform != null) {
            return reorderTransform;
        }
        return DatabaseOps.chooseReorderTransformation(location);
    }

    private static StoreParams buildStoreParams(boolean isNewArea, Location paramsLocation, StoreParams switchableParams, StoreParams storageParams, StoreParams appParams, StoreParams dftParams) {
        StoreParams params = null;
        params = DatabaseOps.buildParamsHelper(params, storageParams);
        params = DatabaseOps.buildParamsHelper(params, switchableParams);
        params = DatabaseOps.buildParamsHelper(params, appParams);
        if (isNewArea && params != null && !params.equals(dftParams)) {
            StoreParamsCodec.write(paramsLocation, params);
        }
        if (storageParams != null) {
            params = storageParams;
        }
        if (switchableParams != null) {
            params = params != null ? StoreParamsBuilder.modify(params, switchableParams) : switchableParams;
        }
        if (appParams != null) {
            params = params != null ? StoreParamsBuilder.modify(params, appParams) : appParams;
        }
        return params;
    }

    private static StoreParams buildParamsHelper(StoreParams baseParams, StoreParams additionalParams) {
        if (baseParams == null) {
            return additionalParams;
        }
        if (additionalParams == null) {
            return null;
        }
        return StoreParamsBuilder.modify(baseParams, additionalParams);
    }

    public static String backup(DatasetGraphSwitchable container2) {
        DatabaseOps.checkSupportsAdmin(container2);
        Path dbPath = container2.getContainerPath();
        Path backupDir = dbPath.resolve(BACKUPS_DIR);
        if (!Files.exists(backupDir, new LinkOption[0])) {
            IOX.createDirectory(backupDir);
        }
        DatasetGraphSwitchable dsg = container2;
        Pair<OutputStream, Path> x = DatabaseOps.openUniqueFileForWriting(backupDir, BACKUPS_FN, "nq.gz");
        try (OutputStream out2 = x.getLeft();
             GZIPOutputStream out1 = new GZIPOutputStream(out2, 8192);
             BufferedOutputStream out = new BufferedOutputStream(out1);){
            Txn.executeRead(dsg, () -> RDFDataMgr.write(out, dsg, Lang.NQUADS));
        }
        catch (IOException e2) {
            throw IOX.exception(e2);
        }
        return x.getRight().toString();
    }

    private static void checkSupportsAdmin(DatasetGraphSwitchable container2) {
        if (!container2.hasContainerPath()) {
            throw new TDBException("Dataset does not support admin operations");
        }
    }

    private static Pair<OutputStream, Path> openUniqueFileForWriting(Path dirPath, String basename, String ext) {
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + String.valueOf(dirPath));
        }
        if (basename.contains("/") || basename.contains("\\")) {
            throw new IllegalArgumentException("Basename must not contain a file path separator (\"/\" or \"\\\")");
        }
        String timestamp = DateTimeUtils.nowAsString("yyyy-MM-dd_HHmmss");
        String filename = basename + "_" + timestamp;
        Path p = dirPath.resolve(filename + "." + ext);
        int x = 0;
        while (true) {
            try {
                OutputStream out = Files.newOutputStream(p, StandardOpenOption.CREATE_NEW);
                return Pair.create(out, p);
            }
            catch (AccessDeniedException ex) {
                throw IOX.exception("Access denied", ex);
            }
            catch (FileAlreadyExistsException ex) {
            }
            catch (IOException ex) {
                throw IOX.exception(ex);
            }
            if (++x >= 5) {
                throw new RuntimeIOException("Can't create the unique name: number of attempts exceeded");
            }
            p = dirPath.resolve(filename + "_" + x + "." + ext);
        }
    }

    public static void compact(DatasetGraphSwitchable container2) {
        DatabaseOps.compact(container2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compact(DatasetGraphSwitchable container2, boolean shouldDeleteOld) {
        if (Sys.isWindows) {
            DatabaseOpsWindows.compact_win(container2, shouldDeleteOld);
            return;
        }
        DatabaseOps.checkSupportsAdmin(container2);
        Object object = compactionLock;
        synchronized (object) {
            Path containerPath = container2.getContainerPath();
            Path db1 = DatabaseOps.findStorageLocation(containerPath);
            if (db1 == null) {
                throw new TDBException("No location: (" + String.valueOf(containerPath) + ", Data)");
            }
            Location loc1 = IO_DB.asLocation(db1);
            Location loc1a = ((DatasetGraphTDB)container2.get()).getLocation();
            if (loc1a.isMem()) {
                // empty if block
            }
            if (!loc1a.exists()) {
                throw new TDBException("No such location: " + String.valueOf(loc1a));
            }
            if (!loc1.equals(loc1a)) {
                throw new TDBException("Inconsistent (not latest?) : " + String.valueOf(loc1a) + " : " + String.valueOf(loc1));
            }
            int v = DatabaseOps.extractIndex(db1.getFileName().toString(), dbNameBase, SEP);
            String next = FilenameUtils.filename(dbNameBase, SEP, v + 1);
            Path db2 = db1.getParent().resolve(next);
            LOG.debug(String.format("Compact %s -> %s\n", db1.getFileName(), db2.getFileName()));
            if (Files.exists(db2, new LinkOption[0])) {
                throw new TDBException("Inconsistent : " + String.valueOf(db2) + " already exists");
            }
            Path tmpDir = DatabaseOps.makeTempDirName(db2);
            if (Files.exists(tmpDir, new LinkOption[0])) {
                throw new TDBException("Inconsistent : tmpdir" + String.valueOf(tmpDir) + " already exists");
            }
            IOX.createDirectory(tmpDir);
            Location loc2tmp = Location.create(tmpDir);
            try {
                DatabaseOps.compaction(container2, loc1, loc2tmp, db2);
            }
            catch (RuntimeIOException ex) {
                try {
                    IO.deleteAll(tmpDir);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw ex;
            }
            catch (Throwable th) {
                try {
                    IO.deleteAll(tmpDir);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw th;
            }
            if (shouldDeleteOld) {
                Path loc1Path = IO_DB.asPath(loc1);
                LOG.debug("Deleting old database after successful compaction (old db path='" + String.valueOf(loc1Path) + "')...");
                IO.deleteAll(loc1Path);
            }
        }
    }

    private static Path makeTempDirName(Path path) {
        String dirname = path.toString();
        if (dirname.endsWith("/")) {
            dirname = StrUtils.chop(dirname);
        }
        return Path.of(dirname + dbTmpSuffix, new String[0]);
    }

    private static void compaction(DatasetGraphSwitchable container2, Location loc1, Location loc2tmp, Path path2final) {
        if (loc1.isMem() || loc2tmp.isMem()) {
            throw new TDBException("Compact involves a memory location: " + String.valueOf(loc1) + " : " + String.valueOf(loc2tmp));
        }
        StoreConnection srcConn = StoreConnection.connectExisting(loc1);
        if (srcConn == null) {
            throw new TDBException("No database at location : " + String.valueOf(loc1));
        }
        if (!(container2.get() instanceof DatasetGraphTDB)) {
            throw new TDBException("Not a TDB2 database in DatasetGraphSwitchable");
        }
        DatasetGraphTDB dsgCurrent = (DatasetGraphTDB)container2.get();
        if (!dsgCurrent.getLocation().equals(loc1)) {
            throw new TDBException("Inconsistent locations for base : " + String.valueOf(dsgCurrent.getLocation()) + " , " + String.valueOf(dsgCurrent.getLocation()));
        }
        DatasetGraphTDB dsgBase = srcConn.getDatasetGraphTDB();
        if (dsgBase != dsgCurrent) {
            throw new TDBException("Inconsistent datasets : " + String.valueOf(dsgCurrent.getLocation()) + " , " + String.valueOf(dsgBase.getLocation()));
        }
        TransactionCoordinator txnMgr1 = dsgBase.getTxnSystem().getTxnMgr();
        container2.execReadOnlyDatabase(() -> {
            DatabaseOps.copyConfigFiles(loc1, loc2tmp);
            DatasetGraphTDB dsgTmpCompact = StoreConnection.connectCreate(loc2tmp).getDatasetGraphTDB();
            CopyDSG.copy(dsgBase, dsgTmpCompact);
            StoreConnection.internalExpel(loc2tmp, true);
            DatabaseOps.moveDirectory(loc2tmp, path2final);
            Location loc2final = Location.create(path2final);
            DatasetGraphTDB dsgCompact = StoreConnection.connectCreate(loc2final).getDatasetGraphTDB();
            TransactionCoordinator txnMgr2 = dsgCompact.getTxnSystem().getTxnMgr();
            txnMgr2.execExclusive(() -> {
                txnMgr2.takeOverFrom(txnMgr1);
                txnMgr2.modifyConfigDirect(() -> txnMgr1.listExternals().forEach(txnMgr2::addExternal));
                if (!container2.change(dsgCurrent, dsgCompact)) {
                    Log.warn(DatabaseOps.class, "Inconsistent: old datasetgraph not as expected");
                    container2.set(dsgCompact);
                }
            });
        });
        txnMgr1.startExclusiveMode();
        StoreConnection.release(dsgBase.getLocation());
    }

    private static void moveDirectory(Location locTmp, Path pathDst) {
        Path pathSrc = IO_DB.asPath(locTmp);
        try {
            Files.move(pathSrc, pathDst, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    private static void copyConfigFiles(Location loc1, Location loc2) {
        FileFilter copyFiles = pathname -> {
            String fn = pathname.getName();
            if (fn.equals("tdb.cfg")) {
                return true;
            }
            return fn.endsWith(".opt");
        };
        File d = new File(loc1.getDirectoryPath());
        File[] files = d.listFiles(copyFiles);
        DatabaseOps.copyFiles(loc1, loc2, files);
    }

    private static void copyFiles(Location loc1, Location loc2, File[] files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            String fn = f.getName();
            IOX.copy(loc1.getPath(fn), loc2.getPath(fn));
        }
    }

    private static List<Path> scanForDirByPattern(Path directory, String namebase, String nameSep, String trailerPattern, ScanAccept skipOthers) {
        Pattern pattern = Pattern.compile(Pattern.quote(namebase) + Pattern.quote(nameSep) + trailerPattern);
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + "*");){
            block11: for (Path entry : stream) {
                String filename = entry.getFileName().toString();
                if (!pattern.matcher(filename).matches()) {
                    switch (skipOthers) {
                        case EXACT: {
                            throw new DBOpEnvException("Invalid filename for matching: " + String.valueOf(entry.getFileName()));
                        }
                        case SKIP: {
                            continue block11;
                        }
                    }
                }
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    throw new DBOpEnvException("Not a directory: " + String.valueOf(entry));
                }
                paths.add(entry);
            }
        }
        catch (IOException ex) {
            FmtLog.warn(IO_DB.class, "Can't inspect directory: (%s, %s)", directory, namebase);
            throw new DBOpEnvException(ex);
        }
        Comparator comp = (f1, f2) -> {
            int num1 = DatabaseOps.extractIndex(f1.getFileName().toString(), namebase, nameSep);
            int num2 = DatabaseOps.extractIndex(f2.getFileName().toString(), namebase, nameSep);
            return Integer.compare(num1, num2);
        };
        paths.sort(comp);
        return paths;
    }

    private static int extractIndex(String name, String namebase, String nameSep) {
        Matcher matcher = numberPattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr);
            return num;
        }
        throw new InternalErrorException("Expected to find a number in '" + name + "'");
    }

    public static Path findStorageLocation(Location directory) {
        Path dirPath = IO_DB.asPath(directory);
        return DatabaseOps.findStorageLocation(dirPath);
    }

    public static Path findStorageLocation(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return null;
        }
        List<Path> maybe = DatabaseOps.scanForDirByPattern(directory, dbNameBase, SEP, dbSuffixPattern, ScanAccept.EXACT);
        return Util.getLastOrNull(maybe);
    }

    public static ReorderTransformation chooseReorderTransformation(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted(location.getPath("stats.opt"));
                LOG.debug("Statistics-based BGP optimizer");
            }
            catch (SSE_ParseException ex) {
                LOG.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            LOG.debug("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            LOG.debug("Optimizer explicitly turned off");
        }
        return reorder;
    }

    private static enum ScanAccept {
        EXACT,
        SKIP;

    }
}

