/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.bulkloader;

import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.event.EventType;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.solver.stats.Stats;
import org.apache.jena.tdb1.solver.stats.StatsCollector;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.bulkloader.BulkStreamRDF;
import org.apache.jena.tdb1.store.bulkloader.LoadMonitor;
import org.apache.jena.tdb1.store.bulkloader.LoaderNodeTupleTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTableView;
import org.slf4j.Logger;

public class BulkLoader {
    public static int DataTickPoint = 100000;
    public static long IndexTickPoint = 100000L;
    public static int superTick = 10;
    private static String baseName = "http://jena.apache.org/TDB/bulkload/event#";
    public static EventType evStartBulkload = new EventType(baseName + "start-bulkload");
    public static EventType evFinishBulkload = new EventType(baseName + "finish-bulkload");
    public static EventType evStartDataBulkload = new EventType(baseName + "start-bulkload-data");
    public static EventType evFinishDataBulkload = new EventType(baseName + "finish-bulkload-data");
    public static EventType evStartIndexBulkload = new EventType(baseName + "start-bulkload-index");
    public static EventType evFinishIndexBulkload = new EventType(baseName + "finish-bulkload-index");
    private static Logger loadLogger = TDB1.logLoader;

    public static void loadDefaultGraph(DatasetGraphTDB dsg, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationDefaultGraph(dsg, showProgress, collectStats);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadDefaultGraph(DatasetGraphTDB dsg, InputStream input, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationDefaultGraph(dsg, showProgress, collectStats);
        BulkLoader.loadTriples$(dest, input);
    }

    private static BulkStreamRDF destinationDefaultGraph(DatasetGraphTDB dsg, boolean showProgress, boolean collectStats) {
        return BulkLoader.destinationGraph(dsg, null, showProgress, collectStats);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress, collectStats);
        BulkLoader.loadTriples$(dest, urls);
    }

    public static void loadNamedGraph(DatasetGraphTDB dsg, Node graphNode, InputStream input, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationNamedGraph(dsg, graphNode, showProgress, collectStats);
        BulkLoader.loadTriples$(dest, input);
    }

    public static void loadDataset(DatasetGraphTDB dsg, List<String> urls, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationDataset(dsg, showProgress, collectStats);
        BulkLoader.loadQuads$(dest, urls);
    }

    public static void loadDataset(DatasetGraphTDB dsg, InputStream input, Lang lang, boolean showProgress, boolean collectStats) {
        BulkStreamRDF dest = BulkLoader.destinationDataset(dsg, showProgress, collectStats);
        BulkLoader.loadQuads$(dest, input, lang);
    }

    private static void loadTriples$(BulkStreamRDF dest, List<String> urls) {
        dest.startBulk();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + DateTimeUtils.nowAsString());
            Lang lang = RDFLanguages.filenameToLang(url, Lang.NTRIPLES);
            RDFParser.source(url).lang(lang).parse(dest);
        }
        dest.finishBulk();
    }

    private static void loadTriples$(BulkStreamRDF dest, InputStream input) {
        loadLogger.info("Load: from input stream -- " + DateTimeUtils.nowAsString());
        dest.startBulk();
        RDFParser.source(input).lang(Lang.NTRIPLES).parse(dest);
        dest.finishBulk();
    }

    private static void loadQuads$(BulkStreamRDF dest, List<String> urls) {
        dest.startBulk();
        for (String url : urls) {
            loadLogger.info("Load: " + url + " -- " + DateTimeUtils.nowAsString());
            Lang lang = RDFLanguages.filenameToLang(url, Lang.NQUADS);
            RDFParser.source(url).lang(lang).parse(dest);
        }
        dest.finishBulk();
    }

    private static void loadQuads$(BulkStreamRDF dest, InputStream input, Lang lang) {
        if (lang == null) {
            lang = Lang.NQUADS;
        }
        loadLogger.info("Load: from input stream -- " + DateTimeUtils.nowAsString());
        dest.startBulk();
        RDFParser.source(input).lang(lang).parse(dest);
        dest.finishBulk();
    }

    private static BulkStreamRDF destinationNamedGraph(DatasetGraphTDB dsg, Node graphName, boolean showProgress, boolean collectStats) {
        if (graphName == null) {
            return BulkLoader.destinationDefaultGraph(dsg, showProgress, collectStats);
        }
        return BulkLoader.destinationGraph(dsg, graphName, showProgress, collectStats);
    }

    public static LoadMonitor createLoadMonitor(DatasetGraphTDB dsg, String itemName, boolean showProgress) {
        if (showProgress) {
            return new LoadMonitor(dsg, loadLogger, itemName, DataTickPoint, IndexTickPoint);
        }
        return new LoadMonitor(dsg, null, itemName, DataTickPoint, IndexTickPoint);
    }

    private static BulkStreamRDF destinationDataset(DatasetGraphTDB dsg, boolean showProgress, boolean collectStats) {
        return new DestinationDSG(dsg, showProgress, collectStats);
    }

    private static BulkStreamRDF destinationGraph(DatasetGraphTDB dsg, Node graphNode, boolean showProgress, boolean collectStats) {
        return new DestinationGraph(dsg, graphNode, showProgress, collectStats);
    }

    static void forceSync(DatasetGraphTDB dsg) {
        dsg.getTripleTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getQuadTable().getNodeTupleTable().getNodeTable().sync();
        dsg.getStoragePrefixes().getNodeTupleTable().getNodeTable().sync();
        dsg.sync();
    }

    private static final class DestinationDSG
    implements BulkStreamRDF {
        private final DatasetGraphTDB dsg;
        private final boolean startedEmpty;
        private final LoadMonitor monitor1;
        private final LoadMonitor monitor2;
        private final LoaderNodeTupleTable loaderTriples;
        private final LoaderNodeTupleTable loaderQuads;
        private final boolean showProgress;
        private long count = 0L;
        private StatsCollector stats = null;
        private final boolean collectStats;

        DestinationDSG(DatasetGraphTDB dsg, boolean showProgress, boolean collectStats) {
            this.dsg = dsg;
            this.startedEmpty = dsg.isEmpty();
            this.monitor1 = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
            this.monitor2 = BulkLoader.createLoadMonitor(dsg, "quads", showProgress);
            this.loaderTriples = new LoaderNodeTupleTable(dsg.getTripleTable().getNodeTupleTable(), "triples", this.monitor1);
            this.loaderQuads = new LoaderNodeTupleTable(dsg.getQuadTable().getNodeTupleTable(), "quads", this.monitor2);
            this.showProgress = showProgress;
            this.collectStats = collectStats;
        }

        @Override
        public final void startBulk() {
            this.loaderTriples.loadStart();
            this.loaderQuads.loadStart();
            this.loaderTriples.loadDataStart();
            this.loaderQuads.loadDataStart();
            if (this.collectStats) {
                this.stats = new StatsCollector();
            }
        }

        @Override
        public void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        @Override
        public void quad(Quad quad) {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private void process(Node g, Node s, Node p, Node o) {
            if (g == null) {
                this.loaderTriples.load(s, p, o);
            } else {
                this.loaderQuads.load(g, s, p, o);
            }
            ++this.count;
            if (this.stats != null) {
                this.stats.record(g, s, p, o);
            }
        }

        @Override
        public void finishBulk() {
            this.loaderTriples.loadDataFinish();
            this.loaderQuads.loadDataFinish();
            this.loaderTriples.loadIndexStart();
            this.loaderQuads.loadIndexStart();
            this.loaderTriples.loadIndexFinish();
            this.loaderQuads.loadIndexFinish();
            this.loaderTriples.loadFinish();
            this.loaderQuads.loadFinish();
            if (!this.dsg.getLocation().isMem() && this.startedEmpty && this.stats != null) {
                String filename = this.dsg.getLocation().getPath("stats.opt");
                Stats.write(filename, this.stats.results());
            }
            BulkLoader.forceSync(this.dsg);
        }

        @Override
        public void start() {
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
            this.dsg.prefixes().add(prefix, iri2);
        }

        @Override
        public void finish() {
        }
    }

    private static final class DestinationGraph
    implements BulkStreamRDF {
        private final DatasetGraphTDB dsg;
        private final Node graphName;
        private final LoadMonitor monitor;
        private final LoaderNodeTupleTable loaderTriples;
        private final boolean startedEmpty;
        private long count = 0L;
        private StatsCollector stats = null;
        private final boolean collectStats;
        private final PrefixMap prefixMap;

        DestinationGraph(DatasetGraphTDB dsg, Node graphNode, boolean showProgress, boolean collectStats) {
            NodeTupleTable nodeTupleTable;
            this.dsg = dsg;
            this.graphName = graphNode;
            this.collectStats = collectStats;
            if (graphNode == null || Quad.isDefaultGraph(graphNode)) {
                nodeTupleTable = dsg.getTripleTable().getNodeTupleTable();
            } else {
                NodeTupleTable ntt = dsg.getQuadTable().getNodeTupleTable();
                nodeTupleTable = new NodeTupleTableView(ntt, this.graphName);
            }
            this.startedEmpty = dsg.isEmpty();
            this.monitor = BulkLoader.createLoadMonitor(dsg, "triples", showProgress);
            this.loaderTriples = new LoaderNodeTupleTable(nodeTupleTable, "triples", this.monitor);
            this.prefixMap = dsg.prefixes();
        }

        @Override
        public final void startBulk() {
            this.loaderTriples.loadStart();
            this.loaderTriples.loadDataStart();
            if (this.collectStats) {
                this.stats = new StatsCollector();
            }
        }

        @Override
        public final void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.loaderTriples.load(s, p, o);
            if (this.stats != null) {
                this.stats.record((Object)null, s, p, o);
            }
            ++this.count;
        }

        @Override
        public final void finishBulk() {
            this.loaderTriples.loadDataFinish();
            this.loaderTriples.loadIndexStart();
            this.loaderTriples.loadIndexFinish();
            this.loaderTriples.loadFinish();
            if (!this.dsg.getLocation().isMem() && this.startedEmpty && this.stats != null) {
                String filename = this.dsg.getLocation().getPath("stats.opt");
                Stats.write(filename, this.stats.results());
            }
            BulkLoader.forceSync(this.dsg);
        }

        @Override
        public void start() {
        }

        @Override
        public void quad(Quad quad) {
            throw new TDB1Exception("Quad encountered while loading a single graph");
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
            this.prefixMap.add(prefix, iri2);
        }

        @Override
        public void finish() {
        }
    }
}

