/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang.sparql_12;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_DateTimeDay;
import org.apache.jena.sparql.expr.E_DateTimeHours;
import org.apache.jena.sparql.expr.E_DateTimeMinutes;
import org.apache.jena.sparql.expr.E_DateTimeMonth;
import org.apache.jena.sparql.expr.E_DateTimeSeconds;
import org.apache.jena.sparql.expr.E_DateTimeTZ;
import org.apache.jena.sparql.expr.E_DateTimeTimezone;
import org.apache.jena.sparql.expr.E_DateTimeYear;
import org.apache.jena.sparql.expr.E_Divide;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_HasLang;
import org.apache.jena.sparql.expr.E_HasLangDir;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_IsLiteral;
import org.apache.jena.sparql.expr.E_IsNumeric;
import org.apache.jena.sparql.expr.E_IsTriple;
import org.apache.jena.sparql.expr.E_IsURI;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangDir;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_MD5;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_Now;
import org.apache.jena.sparql.expr.E_NumAbs;
import org.apache.jena.sparql.expr.E_NumCeiling;
import org.apache.jena.sparql.expr.E_NumFloor;
import org.apache.jena.sparql.expr.E_NumRound;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_Random;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_SHA1;
import org.apache.jena.sparql.expr.E_SHA256;
import org.apache.jena.sparql.expr.E_SHA384;
import org.apache.jena.sparql.expr.E_SHA512;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrAfter;
import org.apache.jena.sparql.expr.E_StrBefore;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrDatatype;
import org.apache.jena.sparql.expr.E_StrEncodeForURI;
import org.apache.jena.sparql.expr.E_StrEndsWith;
import org.apache.jena.sparql.expr.E_StrLang;
import org.apache.jena.sparql.expr.E_StrLangDir;
import org.apache.jena.sparql.expr.E_StrLength;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.E_StrStartsWith;
import org.apache.jena.sparql.expr.E_StrSubstring;
import org.apache.jena.sparql.expr.E_StrUUID;
import org.apache.jena.sparql.expr.E_StrUpperCase;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.E_TripleFn;
import org.apache.jena.sparql.expr.E_TripleObject;
import org.apache.jena.sparql.expr.E_TriplePredicate;
import org.apache.jena.sparql.expr.E_TripleSubject;
import org.apache.jena.sparql.expr.E_UUID;
import org.apache.jena.sparql.expr.E_UnaryMinus;
import org.apache.jena.sparql.expr.E_UnaryPlus;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorFactory;
import org.apache.jena.sparql.expr.aggregate.Args;
import org.apache.jena.sparql.lang.sparql_12.JavaCharStream;
import org.apache.jena.sparql.lang.sparql_12.ParseException;
import org.apache.jena.sparql.lang.sparql_12.SPARQLParser12Base;
import org.apache.jena.sparql.lang.sparql_12.SPARQLParser12Constants;
import org.apache.jena.sparql.lang.sparql_12.SPARQLParser12TokenManager;
import org.apache.jena.sparql.lang.sparql_12.Token;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.QuadAccSink;
import org.apache.jena.sparql.modify.request.QuadDataAccSink;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateWithUsing;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.TripleCollector;
import org.apache.jena.sparql.syntax.TripleCollectorBGP;
import org.apache.jena.sparql.syntax.TripleCollectorMark;
import org.apache.jena.update.Update;

public class SPARQLParser12
extends SPARQLParser12Base
implements SPARQLParser12Constants {
    public SPARQLParser12TokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[178];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public final void QueryUnit() throws ParseException {
        this.startQuery();
        this.Query();
        this.jj_consume_token(0);
        this.finishQuery();
    }

    public final void Query() throws ParseException {
        this.Prologue();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.SelectQuery();
                break;
            }
            case 25: {
                this.ConstructQuery();
                break;
            }
            case 24: {
                this.DescribeQuery();
                break;
            }
            case 26: {
                this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.ValuesClause();
    }

    public final void UpdateUnit() throws ParseException {
        this.startUpdateRequest();
        this.Update();
        this.jj_consume_token(0);
        this.finishUpdateRequest();
    }

    public final void Prologue() throws ParseException {
        block8: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 19: {
                        this.BaseDecl();
                        continue block7;
                    }
                    case 20: {
                        this.PrefixDecl();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void BaseDecl() throws ParseException {
        Token t = this.jj_consume_token(19);
        String iri2 = this.IRIREF();
        this.setBase(iri2, t.beginLine, t.beginColumn);
    }

    public final void PrefixDecl() throws ParseException {
        this.jj_consume_token(20);
        Token t = this.jj_consume_token(10);
        String iri2 = this.IRIREF();
        String s = this.fixupPrefix(t.image, t.beginLine, t.beginColumn);
        this.setPrefix(s, iri2, t.beginLine, t.beginColumn);
    }

    public final void SelectQuery() throws ParseException {
        this.SelectClause();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void SubSelect() throws ParseException {
        this.SelectClause();
        this.WhereClause();
        this.SolutionModifier();
        this.ValuesClause();
    }

    public final void SelectClause() throws ParseException {
        this.jj_consume_token(21);
        this.getQuery().setQuerySelectType();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: 
            case 23: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        this.getQuery().setDistinct(true);
                        break block0;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        this.getQuery().setReduced(true);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.setAllowAggregatesInExpressions(true);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 174: {
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 13: 
                        case 14: {
                            Var v = this.Var();
                            this.getQuery().addResultVar(v);
                            break;
                        }
                        case 174: {
                            Var v = null;
                            this.jj_consume_token(174);
                            Expr expr = this.Expression();
                            this.jj_consume_token(52);
                            v = this.Var();
                            this.jj_consume_token(175);
                            this.getQuery().addResultVar(v, expr);
                            this.getQuery().setQueryResultStar(false);
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 13: 
                        case 14: 
                        case 174: {
                            continue block18;
                        }
                    }
                    break;
                }
                this.jj_la1[7] = this.jj_gen;
                break;
            }
            case 204: {
                this.jj_consume_token(204);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.setAllowAggregatesInExpressions(false);
    }

    public final void ConstructQuery() throws ParseException {
        TripleCollectorBGP acc = new TripleCollectorBGP();
        this.jj_consume_token(25);
        this.getQuery().setQueryConstructType();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 177: {
                Template t = this.ConstructTemplate();
                this.getQuery().setConstructTemplate(t);
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 36: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.DatasetClause();
                }
                this.WhereClause();
                this.SolutionModifier();
                break;
            }
            case 36: 
            case 37: {
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 36: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.DatasetClause();
                }
                this.jj_consume_token(37);
                this.jj_consume_token(177);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 179: 
                    case 181: 
                    case 191: 
                    case 193: {
                        this.TriplesTemplate(acc);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                this.jj_consume_token(178);
                this.SolutionModifier();
                Template t = new Template(acc.getBGP());
                this.getQuery().setConstructTemplate(t);
                ElementPathBlock epb = new ElementPathBlock(acc.getBGP());
                ElementGroup elg = new ElementGroup();
                elg.addElement(epb);
                this.getQuery().setQueryPattern(elg);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DescribeQuery() throws ParseException {
        this.jj_consume_token(24);
        this.getQuery().setQueryDescribeType();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                block13: while (true) {
                    Node n = this.VarOrIri();
                    this.getQuery().addDescribeNode(n);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 14: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[13] = this.jj_gen;
                this.getQuery().setQueryResultStar(false);
                break;
            }
            case 204: {
                this.jj_consume_token(204);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: 
            case 177: {
                this.WhereClause();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.SolutionModifier();
    }

    public final void AskQuery() throws ParseException {
        this.jj_consume_token(26);
        this.getQuery().setQueryAskType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void DatasetClause() throws ParseException {
        this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                this.DefaultGraphClause();
                break;
            }
            case 35: {
                this.NamedGraphClause();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DefaultGraphClause() throws ParseException {
        String iri2 = this.SourceSelector();
        this.getQuery().addGraphURI(iri2);
    }

    public final void NamedGraphClause() throws ParseException {
        this.jj_consume_token(35);
        String iri2 = this.SourceSelector();
        this.getQuery().addNamedGraphURI(iri2);
    }

    public final String SourceSelector() throws ParseException {
        String iri2 = this.iri();
        return iri2;
    }

    public final void WhereClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.startWherePattern();
        Element el = this.GroupGraphPattern();
        this.getQuery().setQueryPattern(el);
        this.finishWherePattern();
    }

    public final void SolutionModifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: {
                this.GroupClause();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.HavingClause();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                this.OrderClause();
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: 
            case 28: {
                this.LimitOffsetClauses();
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
    }

    public final void GroupClause() throws ParseException {
        this.jj_consume_token(53);
        this.jj_consume_token(30);
        block3: while (true) {
            this.GroupCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 127: 
                case 128: 
                case 129: 
                case 174: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[24] = this.jj_gen;
    }

    public final void GroupCondition() throws ParseException {
        Var v = null;
        Expr expr = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: {
                expr = this.BuiltInCall();
                this.getQuery().addGroupBy(null, expr);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                expr = this.FunctionCall();
                this.getQuery().addGroupBy(null, expr);
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                expr = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 52: {
                        this.jj_consume_token(52);
                        v = this.Var();
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                    }
                }
                this.jj_consume_token(175);
                this.getQuery().addGroupBy(v, expr);
                break;
            }
            case 13: 
            case 14: {
                v = this.Var();
                this.getQuery().addGroupBy(v);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void HavingClause() throws ParseException {
        this.setAllowAggregatesInExpressions(true);
        this.jj_consume_token(54);
        block3: while (true) {
            this.HavingCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 127: 
                case 128: 
                case 129: 
                case 174: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[27] = this.jj_gen;
        this.setAllowAggregatesInExpressions(false);
    }

    public final void HavingCondition() throws ParseException {
        Expr c = this.Constraint();
        this.getQuery().addHavingCondition(c);
    }

    public final void OrderClause() throws ParseException {
        this.setAllowAggregatesInExpressions(true);
        this.jj_consume_token(29);
        this.jj_consume_token(30);
        block3: while (true) {
            this.OrderCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 33: 
                case 34: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 127: 
                case 128: 
                case 129: 
                case 174: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[28] = this.jj_gen;
        this.setAllowAggregatesInExpressions(false);
    }

    public final void OrderCondition() throws ParseException {
        int direction = 0;
        Expr expr = null;
        Var v = null;
        direction = -2;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: 
            case 34: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        direction = 1;
                        break;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        direction = -1;
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.BrackettedExpression();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 174: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 174: {
                        expr = this.Constraint();
                        break block0;
                    }
                    case 13: 
                    case 14: {
                        v = this.Var();
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (v == null) {
            this.getQuery().addOrderBy(expr, direction);
        } else {
            this.getQuery().addOrderBy(v, direction);
        }
    }

    public final void LimitOffsetClauses() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                this.LimitClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 28: {
                        this.OffsetClause();
                        break block0;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                break;
            }
            case 28: {
                this.OffsetClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 27: {
                        this.LimitClause();
                        break block0;
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LimitClause() throws ParseException {
        this.jj_consume_token(27);
        Token t = this.jj_consume_token(154);
        this.getQuery().setLimit(this.integerValue(t.image));
    }

    public final void OffsetClause() throws ParseException {
        this.jj_consume_token(28);
        Token t = this.jj_consume_token(154);
        this.getQuery().setOffset(this.integerValue(t.image));
    }

    public final void ValuesClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                Token t = this.jj_consume_token(31);
                this.startValuesClause(t.beginLine, t.beginColumn);
                this.DataBlock();
                this.finishValuesClause(t.beginLine, t.beginColumn);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
    }

    public final void Update() throws ParseException {
        this.Prologue();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 146: 
            case 151: {
                this.Update1();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 182: {
                        this.jj_consume_token(182);
                        this.Update();
                        break block0;
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
    }

    public final void Update1() throws ParseException {
        Update up = null;
        this.startUpdateOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                up = this.Load();
                break;
            }
            case 139: {
                up = this.Clear();
                break;
            }
            case 146: {
                up = this.Drop();
                break;
            }
            case 141: {
                up = this.Add();
                break;
            }
            case 142: {
                up = this.Move();
                break;
            }
            case 143: {
                up = this.Copy();
                break;
            }
            case 140: {
                up = this.Create();
                break;
            }
            case 137: {
                up = this.DeleteWhere();
                break;
            }
            case 133: 
            case 134: 
            case 151: {
                up = this.Modify();
                break;
            }
            case 135: {
                this.InsertData();
                break;
            }
            case 136: {
                this.DeleteData();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (null != up) {
            this.emitUpdate(up);
        }
        this.finishUpdateOperation();
    }

    public final Update Load() throws ParseException {
        Node dest = null;
        boolean silent = false;
        this.jj_consume_token(138);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        String url = this.iri();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 147: {
                this.jj_consume_token(147);
                dest = this.GraphRef();
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        return new UpdateLoad(url, dest, silent);
    }

    public final Update Clear() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        Target target = this.GraphRefAll();
        return new UpdateClear(target, silent);
    }

    public final Update Drop() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(146);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        Target target = this.GraphRefAll();
        return new UpdateDrop(target, silent);
    }

    public final Update Create() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(140);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        Node iri2 = this.GraphRef();
        return new UpdateCreate(iri2, silent);
    }

    public final Update Add() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(141);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        Target src = this.GraphOrDefault();
        this.jj_consume_token(148);
        Target dest = this.GraphOrDefault();
        return new UpdateAdd(src, dest, silent);
    }

    public final Update Move() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(142);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        Target src = this.GraphOrDefault();
        this.jj_consume_token(148);
        Target dest = this.GraphOrDefault();
        return new UpdateMove(src, dest, silent);
    }

    public final Update Copy() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(143);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        Target src = this.GraphOrDefault();
        this.jj_consume_token(148);
        Target dest = this.GraphOrDefault();
        return new UpdateCopy(src, dest, silent);
    }

    public final void InsertData() throws ParseException {
        QuadDataAccSink qd = this.createInsertDataSink();
        Token t = this.jj_consume_token(135);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        this.startDataInsert(qd, beginLine, beginColumn);
        this.QuadData(qd);
        this.finishDataInsert(qd, beginLine, beginColumn);
        qd.close();
    }

    public final void DeleteData() throws ParseException {
        QuadDataAccSink qd = this.createDeleteDataSink();
        Token t = this.jj_consume_token(136);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        this.startDataDelete(qd, beginLine, beginColumn);
        this.QuadData(qd);
        this.finishDataDelete(qd, beginLine, beginColumn);
        qd.close();
    }

    public final Update DeleteWhere() throws ParseException {
        QuadAcc qp = new QuadAcc();
        Token t = this.jj_consume_token(137);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        this.startDeleteTemplate(qp, beginLine, beginColumn);
        this.QuadPattern(qp);
        this.finishDeleteTemplate(qp, beginLine, beginColumn);
        return new UpdateDeleteWhere(qp);
    }

    public final Update Modify() throws ParseException {
        String iri2 = null;
        UpdateModify up = new UpdateModify();
        this.startModifyUpdate();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 151: {
                this.jj_consume_token(151);
                iri2 = this.iri();
                Node n = this.createNode(iri2);
                up.setWithIRI(n);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 134: {
                this.DeleteClause(up);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 133: {
                        this.InsertClause(up);
                        break block3;
                    }
                }
                this.jj_la1[48] = this.jj_gen;
                break;
            }
            case 133: {
                this.InsertClause(up);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 152: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block13;
                }
            }
            this.UsingClause(up);
        }
        this.jj_consume_token(37);
        this.startWherePattern();
        Element el = this.GroupGraphPattern();
        up.setElement(el);
        this.finishWherePattern();
        this.finishModifyUpdate();
        return up;
    }

    public final void DeleteClause(UpdateModify up) throws ParseException {
        QuadAcc qp = up.getDeleteAcc();
        Token t = this.jj_consume_token(134);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        this.startDeleteTemplate(qp, beginLine, beginColumn);
        this.QuadPattern(qp);
        this.finishDeleteTemplate(qp, beginLine, beginColumn);
        up.setHasDeleteClause(true);
    }

    public final void InsertClause(UpdateModify up) throws ParseException {
        QuadAcc qp = up.getInsertAcc();
        Token t = this.jj_consume_token(133);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        this.startInsertTemplate(qp, beginLine, beginColumn);
        this.QuadPattern(qp);
        this.finishInsertTemplate(qp, beginLine, beginColumn);
        up.setHasInsertClause(true);
    }

    public final void UsingClause(UpdateWithUsing update2) throws ParseException {
        this.jj_consume_token(152);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                Node n = this.createNode(iri2);
                update2.addUsing(n);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                String iri3 = this.iri();
                Node n = this.createNode(iri3);
                update2.addUsingNamed(n);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Target GraphOrDefault() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 149: {
                this.jj_consume_token(149);
                return Target.DEFAULT;
            }
            case 9: 
            case 10: 
            case 11: 
            case 39: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                    }
                }
                String iri2 = this.iri();
                return Target.create(this.createNode(iri2));
            }
        }
        this.jj_la1[53] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node GraphRef() throws ParseException {
        this.jj_consume_token(39);
        String iri2 = this.iri();
        return this.createNode(iri2);
    }

    public final Target GraphRefAll() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                Node iri2 = this.GraphRef();
                return Target.create(iri2);
            }
            case 149: {
                this.jj_consume_token(149);
                return Target.DEFAULT;
            }
            case 35: {
                this.jj_consume_token(35);
                return Target.NAMED;
            }
            case 150: {
                this.jj_consume_token(150);
                return Target.ALL;
            }
        }
        this.jj_la1[54] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void QuadPattern(QuadAcc acc) throws ParseException {
        this.jj_consume_token(177);
        this.Quads(acc);
        this.jj_consume_token(178);
    }

    public final void QuadData(QuadDataAccSink acc) throws ParseException {
        this.jj_consume_token(177);
        this.Quads(acc);
        this.jj_consume_token(178);
    }

    public final void Quads(QuadAccSink acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 179: 
            case 181: 
            case 191: 
            case 193: {
                this.TriplesTemplate(acc);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block12;
                }
            }
            this.QuadsNotTriples(acc);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 184: {
                    this.jj_consume_token(184);
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 130: 
                case 131: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 179: 
                case 181: 
                case 191: 
                case 193: {
                    this.TriplesTemplate(acc);
                    continue block12;
                }
            }
            this.jj_la1[58] = this.jj_gen;
        }
    }

    public final void QuadsNotTriples(QuadAccSink acc) throws ParseException {
        Node prev = acc.getGraph();
        this.jj_consume_token(39);
        Node gn = this.VarOrIri();
        this.setAccGraph(acc, gn);
        this.jj_consume_token(177);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 179: 
            case 181: 
            case 191: 
            case 193: {
                this.TriplesTemplate(acc);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.jj_consume_token(178);
        this.setAccGraph(acc, prev);
    }

    public final void TriplesTemplate(TripleCollector acc) throws ParseException {
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 184: {
                this.jj_consume_token(184);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 179: 
                    case 181: 
                    case 191: 
                    case 193: {
                        this.TriplesTemplate(acc);
                        break block0;
                    }
                }
                this.jj_la1[60] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
    }

    public final Element GroupGraphPattern() throws ParseException {
        Element el = null;
        Token t = this.jj_consume_token(177);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.startSubSelect(beginLine, beginColumn);
                this.SubSelect();
                Query q = this.endSubSelect(beginLine, beginColumn);
                el = new ElementSubQuery(q);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                el = this.GroupGraphPatternSub();
            }
        }
        this.jj_consume_token(178);
        return el;
    }

    public final Element GroupGraphPatternSub() throws ParseException {
        Element el = null;
        ElementGroup elg = new ElementGroup();
        this.startGroup(elg);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 179: 
            case 181: 
            case 191: 
            case 193: {
                this.startTriplesBlock();
                el = this.TriplesBlock(null);
                this.endTriplesBlock();
                elg.addElement(el);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: 
                case 39: 
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 70: 
                case 177: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block12;
                }
            }
            el = this.GraphPatternNotTriples();
            elg.addElement(el);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 184: {
                    this.jj_consume_token(184);
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 130: 
                case 131: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 179: 
                case 181: 
                case 191: 
                case 193: {
                    this.startTriplesBlock();
                    el = this.TriplesBlock(null);
                    this.endTriplesBlock();
                    elg.addElement(el);
                    continue block12;
                }
            }
            this.jj_la1[66] = this.jj_gen;
        }
        this.endGroup(elg);
        return elg;
    }

    public final Element TriplesBlock(ElementPathBlock acc) throws ParseException {
        if (acc == null) {
            acc = new ElementPathBlock();
        }
        this.TriplesSameSubjectPath(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 184: {
                this.jj_consume_token(184);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 179: 
                    case 181: 
                    case 191: 
                    case 193: {
                        this.TriplesBlock(acc);
                        break block0;
                    }
                }
                this.jj_la1[67] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        return acc;
    }

    public final Node ReifiedTripleBlock(TripleCollector acc) throws ParseException {
        Node reifId = this.ReifiedTriple(acc);
        this.PropertyList(reifId, acc);
        return reifId;
    }

    public final Node ReifiedTripleBlockPath(TripleCollector acc) throws ParseException {
        Node reifId = this.ReifiedTriple(acc);
        this.PropertyListPath(reifId, acc);
        return reifId;
    }

    public final Element GraphPatternNotTriples() throws ParseException {
        Element el = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 177: {
                el = this.GroupOrUnionGraphPattern();
                break;
            }
            case 40: {
                el = this.OptionalGraphPattern();
                break;
            }
            case 42: {
                el = this.MinusGraphPattern();
                break;
            }
            case 39: {
                el = this.GraphGraphPattern();
                break;
            }
            case 44: {
                el = this.ServiceGraphPattern();
                break;
            }
            case 70: {
                el = this.Filter();
                break;
            }
            case 43: {
                el = this.Bind();
                break;
            }
            case 31: {
                el = this.InlineData();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return el;
    }

    public final Element OptionalGraphPattern() throws ParseException {
        this.jj_consume_token(40);
        Element el = this.GroupGraphPattern();
        return new ElementOptional(el);
    }

    public final Element GraphGraphPattern() throws ParseException {
        this.jj_consume_token(39);
        Node n = this.VarOrIri();
        Element el = this.GroupGraphPattern();
        return new ElementNamedGraph(n, el);
    }

    public final Element ServiceGraphPattern() throws ParseException {
        boolean silent = false;
        this.jj_consume_token(44);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 145: {
                this.jj_consume_token(145);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
            }
        }
        Node n = this.VarOrIri();
        Element el = this.GroupGraphPattern();
        return new ElementService(n, el, silent);
    }

    public final Element Bind() throws ParseException {
        this.jj_consume_token(43);
        this.jj_consume_token(174);
        Expr expr = this.Expression();
        this.jj_consume_token(52);
        Var v = this.Var();
        this.jj_consume_token(175);
        return new ElementBind(v, expr);
    }

    public final Element InlineData() throws ParseException {
        Token t = this.jj_consume_token(31);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        ElementData el = new ElementData();
        this.startInlineData(el.getVars(), el.getRows(), beginLine, beginColumn);
        this.DataBlock();
        this.finishInlineData(beginLine, beginColumn);
        return el;
    }

    public final void DataBlock() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                this.InlineDataOneVar();
                break;
            }
            case 174: 
            case 176: {
                this.InlineDataFull();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void InlineDataOneVar() throws ParseException {
        Var v = this.Var();
        this.emitDataBlockVariable(v);
        Token t = this.jj_consume_token(177);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 32: 
                case 130: 
                case 131: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 191: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block3;
                }
            }
            Node n = this.DataBlockValue();
            this.startDataBlockValueRow(beginLine, beginColumn);
            this.emitDataBlockValue(n, beginLine, beginColumn);
            this.finishDataBlockValueRow(beginLine, beginColumn);
        }
        t = this.jj_consume_token(178);
    }

    public final void InlineDataFull() throws ParseException {
        block20: {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 176: {
                    this.jj_consume_token(176);
                    break;
                }
                case 174: {
                    this.jj_consume_token(174);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 13: 
                            case 14: {
                                break;
                            }
                            default: {
                                this.jj_la1[73] = this.jj_gen;
                                break block17;
                            }
                        }
                        Var v = this.Var();
                        this.emitDataBlockVariable(v);
                    }
                    this.jj_consume_token(175);
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(177);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 174: 
                    case 176: {
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                        break block20;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 174: {
                        Token t = this.jj_consume_token(174);
                        int beginLine = t.beginLine;
                        int beginColumn = t.beginColumn;
                        t = null;
                        this.startDataBlockValueRow(beginLine, beginColumn);
                        block19: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 9: 
                                case 10: 
                                case 11: 
                                case 32: 
                                case 130: 
                                case 131: 
                                case 154: 
                                case 155: 
                                case 156: 
                                case 157: 
                                case 158: 
                                case 159: 
                                case 160: 
                                case 161: 
                                case 162: 
                                case 170: 
                                case 171: 
                                case 172: 
                                case 173: 
                                case 191: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[76] = this.jj_gen;
                                    break block19;
                                }
                            }
                            Node n = this.DataBlockValue();
                            this.emitDataBlockValue(n, beginLine, beginColumn);
                        }
                        t = this.jj_consume_token(175);
                        beginLine = t.beginLine;
                        beginColumn = t.beginColumn;
                        t = null;
                        this.finishDataBlockValueRow(beginLine, beginColumn);
                        continue block18;
                    }
                    case 176: {
                        Token t = this.jj_consume_token(176);
                        int beginLine = t.beginLine;
                        int beginColumn = t.beginColumn;
                        t = null;
                        this.startDataBlockValueRow(beginLine, beginColumn);
                        this.finishDataBlockValueRow(beginLine, beginColumn);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[77] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(178);
    }

    public final Node DataBlockValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                return this.createNode(iri2);
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                Node n = this.RDFLiteral();
                return n;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                Node n = this.NumericLiteral();
                return n;
            }
            case 130: 
            case 131: {
                Node n = this.BooleanLiteral();
                return n;
            }
            case 32: {
                this.jj_consume_token(32);
                return null;
            }
            case 191: {
                Node n = this.TripleTermData();
                return n;
            }
        }
        this.jj_la1[78] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node Reifier() throws ParseException {
        Token tok = null;
        Node reifId = null;
        tok = this.jj_consume_token(197);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 181: {
                reifId = this.VarOrReifierId();
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        return reifId;
    }

    public final Node VarOrReifierId() throws ParseException {
        Node n = null;
        String iri2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                n = this.Var();
                return n;
            }
            case 9: 
            case 10: 
            case 11: {
                iri2 = this.iri();
                return this.createNode(iri2);
            }
            case 12: 
            case 181: {
                n = this.BlankNode();
                return n;
            }
        }
        this.jj_la1[80] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element MinusGraphPattern() throws ParseException {
        this.jj_consume_token(42);
        Element el = this.GroupGraphPattern();
        return new ElementMinus(el);
    }

    public final Element GroupOrUnionGraphPattern() throws ParseException {
        Element el = null;
        ElementUnion el2 = null;
        el = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            if (el2 == null) {
                el2 = new ElementUnion();
                el2.addElement(el);
            }
            el = this.GroupGraphPattern();
            el2.addElement(el);
        }
        return el2 == null ? el : el2;
    }

    public final Element Filter() throws ParseException {
        this.jj_consume_token(70);
        Expr c = this.Constraint();
        return new ElementFilter(c);
    }

    public final Expr Constraint() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174 -> this.BrackettedExpression();
            case 45, 46, 47, 48, 49, 50, 51, 57, 58, 59, 60, 61, 68, 69, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 127, 128, 129 -> this.BuiltInCall();
            case 9, 10, 11 -> this.FunctionCall();
            default -> {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Expr FunctionCall() throws ParseException {
        String fname = this.iri();
        Args a = this.ArgList();
        if (AggregateRegistry.isRegistered(fname)) {
            if (!this.getAllowAggregatesInExpressions()) {
                SPARQLParser12.throwParseException("Aggregate expression not legal at this point : " + fname, this.token.beginLine, this.token.beginColumn);
            }
            Aggregator agg = AggregatorFactory.createCustom(fname, a);
            Expr exprAgg = this.getQuery().allocAggregate(agg);
            return exprAgg;
        }
        return new E_Function(fname, a);
    }

    public final Args ArgList() throws ParseException {
        Args args = new Args();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        Token t = this.jj_consume_token(22);
                        args.distinct = true;
                        int beginLine = t.beginLine;
                        int beginColumn = t.beginColumn;
                        t = null;
                        if (this.getAllowAggregatesInExpressions()) break;
                        SPARQLParser12.throwParseException("Aggregate expression not legal at this point", beginLine, beginColumn);
                        break;
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                Expr expr = this.Expression();
                args.add(expr);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 183: {
                            break;
                        }
                        default: {
                            this.jj_la1[84] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(183);
                    expr = this.Expression();
                    args.add(expr);
                }
                this.jj_consume_token(175);
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    public final ExprList ExpressionList() throws ParseException {
        Expr expr = null;
        ExprList exprList = new ExprList();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 176: {
                this.jj_consume_token(176);
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                expr = this.Expression();
                exprList.add(expr);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 183: {
                            break;
                        }
                        default: {
                            this.jj_la1[86] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(183);
                    expr = this.Expression();
                    exprList.add(expr);
                }
                this.jj_consume_token(175);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exprList;
    }

    public final Template ConstructTemplate() throws ParseException {
        TripleCollectorBGP acc = new TripleCollectorBGP();
        Template t = new Template(acc.getBGP());
        this.setInConstructTemplate(true);
        this.jj_consume_token(177);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 176: 
            case 179: 
            case 181: 
            case 191: 
            case 193: {
                this.ConstructTriples(acc);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        this.jj_consume_token(178);
        this.setInConstructTemplate(false);
        return t;
    }

    public final void ConstructTriples(TripleCollector acc) throws ParseException {
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 184: {
                this.jj_consume_token(184);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 176: 
                    case 179: 
                    case 181: 
                    case 191: 
                    case 193: {
                        this.ConstructTriples(acc);
                        break block0;
                    }
                }
                this.jj_la1[89] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
            }
        }
    }

    public final void TriplesSameSubject(TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 176: 
            case 181: 
            case 191: {
                Node s = this.VarOrTerm();
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            case 174: 
            case 179: {
                ElementPathBlock tempAcc = new ElementPathBlock();
                Node s = this.TriplesNode(tempAcc);
                this.PropertyList(s, tempAcc);
                this.insert(acc, tempAcc);
                break;
            }
            case 193: {
                this.ReifiedTripleBlock(acc);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PropertyList(Node s, TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
    }

    public final void PropertyListNotEmpty(Node s, TripleCollector acc) throws ParseException {
        Node p = null;
        p = this.Verb();
        this.ObjectList(s, p, null, acc);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(182);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 18: {
                    p = this.Verb();
                    this.ObjectList(s, p, null, acc);
                    continue block6;
                }
            }
            this.jj_la1[94] = this.jj_gen;
        }
    }

    public final Node Verb() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9, 10, 11, 13, 14 -> this.VarOrIri();
            case 18 -> {
                this.jj_consume_token(18);
                yield this.nRDFtype;
            }
            default -> {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final void ObjectList(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
        this.Object(s, p, path, acc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 183: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(183);
            this.Object(s, p, path, acc);
        }
    }

    public final void Object(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
        ElementPathBlock tempAcc = new ElementPathBlock();
        int mark = tempAcc.mark();
        Node o = this.GraphNode(tempAcc);
        this.insert(tempAcc, mark, s, p, path, o);
        this.insert(acc, tempAcc);
        this.Annotation(acc, s, p, path, o);
    }

    public final void TriplesSameSubjectPath(TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 176: 
            case 181: 
            case 191: {
                Node s = this.VarOrTerm();
                this.PropertyListPathNotEmpty(s, acc);
                break;
            }
            case 174: 
            case 179: {
                ElementPathBlock tempAcc = new ElementPathBlock();
                Node s = this.TriplesNodePath(tempAcc);
                this.PropertyListPath(s, tempAcc);
                this.insert(acc, tempAcc);
                break;
            }
            case 193: {
                this.ReifiedTripleBlockPath(acc);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PropertyListPath(Node s, TripleCollector acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 174: 
            case 198: 
            case 209: {
                this.PropertyListPathNotEmpty(s, acc);
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
    }

    public final void PropertyListPathNotEmpty(Node s, TripleCollector acc) throws ParseException {
        Path path = null;
        Node p = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 174: 
            case 198: 
            case 209: {
                path = this.VerbPath();
                break;
            }
            case 13: 
            case 14: {
                p = this.VerbSimple();
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.ObjectListPath(s, p, path, acc);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(182);
            path = null;
            p = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 18: 
                case 174: 
                case 198: 
                case 209: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 18: 
                        case 174: 
                        case 198: 
                        case 209: {
                            path = this.VerbPath();
                            break;
                        }
                        case 13: 
                        case 14: {
                            p = this.VerbSimple();
                            break;
                        }
                        default: {
                            this.jj_la1[101] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.ObjectListPath(s, p, path, acc);
                    continue block14;
                }
            }
            this.jj_la1[102] = this.jj_gen;
        }
    }

    public final Path VerbPath() throws ParseException {
        Path path = this.Path();
        return path;
    }

    public final Node VerbSimple() throws ParseException {
        Var p = this.Var();
        return p;
    }

    public final void ObjectListPath(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
        this.ObjectPath(s, p, path, acc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 183: {
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(183);
            this.ObjectPath(s, p, path, acc);
        }
    }

    public final void ObjectPath(Node s, Node p, Path path, TripleCollector acc) throws ParseException {
        ElementPathBlock tempAcc = new ElementPathBlock();
        int mark = tempAcc.mark();
        Node o = this.GraphNodePath(tempAcc);
        this.insert(tempAcc, mark, s, p, path, o);
        this.insert(acc, tempAcc);
        this.AnnotationPath(acc, s, p, path, o);
    }

    public final Path Path() throws ParseException {
        Path p = this.PathAlternative();
        return p;
    }

    public final Path PathAlternative() throws ParseException {
        Path p1 = this.PathSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 208: {
                    break;
                }
                default: {
                    this.jj_la1[104] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(208);
            Path p2 = this.PathSequence();
            p1 = PathFactory.pathAlt(p1, p2);
        }
        return p1;
    }

    public final Path PathSequence() throws ParseException {
        Path p1 = this.PathEltOrInverse();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 205: {
                    break;
                }
                default: {
                    this.jj_la1[105] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(205);
            Path p2 = this.PathEltOrInverse();
            p1 = PathFactory.pathSeq(p1, p2);
        }
        return p1;
    }

    public final Path PathElt() throws ParseException {
        Path p = this.PathPrimary();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 202: 
            case 204: 
            case 212: {
                p = this.PathMod(p);
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
            }
        }
        return p;
    }

    public final Path PathEltOrInverse() throws ParseException {
        Path p;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 174: 
            case 198: {
                p = this.PathElt();
                break;
            }
            case 209: {
                this.jj_consume_token(209);
                p = this.PathElt();
                p = PathFactory.pathInverse(p);
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final Path PathMod(Path p) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 212: {
                this.jj_consume_token(212);
                return PathFactory.pathZeroOrOne(p);
            }
            case 204: {
                this.jj_consume_token(204);
                return PathFactory.pathZeroOrMore1(p);
            }
            case 202: {
                this.jj_consume_token(202);
                return PathFactory.pathOneOrMore1(p);
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Path PathPrimary() throws ParseException {
        Path p;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String str2 = this.iri();
                Node n = this.createNode(str2);
                p = PathFactory.pathLink(n);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                p = PathFactory.pathLink(this.nRDFtype);
                break;
            }
            case 198: {
                this.jj_consume_token(198);
                p = this.PathNegatedPropertySet();
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                p = this.Path();
                this.jj_consume_token(175);
                break;
            }
            default: {
                this.jj_la1[109] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return p;
    }

    public final Path PathNegatedPropertySet() throws ParseException {
        P_NegPropSet pNegSet = new P_NegPropSet();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 209: {
                P_Path0 p = this.PathOneInPropertySet();
                pNegSet.add(p);
                break;
            }
            case 174: {
                this.jj_consume_token(174);
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: 
                    case 209: {
                        P_Path0 p = this.PathOneInPropertySet();
                        pNegSet.add(p);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 208: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[110] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(208);
                            p = this.PathOneInPropertySet();
                            pNegSet.add(p);
                        }
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                    }
                }
                this.jj_consume_token(175);
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return pNegSet;
    }

    public final P_Path0 PathOneInPropertySet() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String str2 = this.iri();
                Node n = this.createNode(str2);
                return new P_Link(n);
            }
            case 18: {
                this.jj_consume_token(18);
                return new P_Link(this.nRDFtype);
            }
            case 209: {
                this.jj_consume_token(209);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 11: {
                        String str3 = this.iri();
                        Node n = this.createNode(str3);
                        return new P_ReverseLink(n);
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        return new P_ReverseLink(this.nRDFtype);
                    }
                }
                this.jj_la1[113] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[114] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node TriplesNode(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174: {
                Node n = this.Collection(acc);
                return n;
            }
            case 179: {
                Node n = this.BlankNodePropertyList(acc);
                return n;
            }
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNodePropertyList(TripleCollector acc) throws ParseException {
        Token t = this.jj_consume_token(179);
        Node n = this.createBNode(t.beginLine, t.beginColumn);
        this.PropertyListNotEmpty(n, acc);
        this.jj_consume_token(180);
        return n;
    }

    public final Node TriplesNodePath(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174: {
                Node n = this.CollectionPath(acc);
                return n;
            }
            case 179: {
                Node n = this.BlankNodePropertyListPath(acc);
                return n;
            }
        }
        this.jj_la1[116] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNodePropertyListPath(TripleCollector acc) throws ParseException {
        Token t = this.jj_consume_token(179);
        Node n = this.createBNode(t.beginLine, t.beginColumn);
        this.PropertyListPathNotEmpty(n, acc);
        this.jj_consume_token(180);
        return n;
    }

    public final Node Collection(TripleCollectorMark acc) throws ParseException {
        Node listHead = this.nRDFnil;
        Node lastCell = null;
        Token t = this.jj_consume_token(174);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        block3: while (true) {
            Node cell = this.createListNode(beginLine, beginColumn);
            if (listHead == this.nRDFnil) {
                listHead = cell;
            }
            if (lastCell != null) {
                this.insert(acc, lastCell, this.nRDFrest, cell);
            }
            int mark = acc.mark();
            Node n = this.GraphNode(acc);
            this.insert(acc, mark, cell, this.nRDFfirst, n);
            lastCell = cell;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 130: 
                case 131: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 179: 
                case 181: 
                case 191: 
                case 193: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[117] = this.jj_gen;
        this.jj_consume_token(175);
        if (lastCell != null) {
            this.insert(acc, lastCell, this.nRDFrest, this.nRDFnil);
        }
        return listHead;
    }

    public final Node CollectionPath(TripleCollectorMark acc) throws ParseException {
        Node listHead = this.nRDFnil;
        Node lastCell = null;
        Token t = this.jj_consume_token(174);
        int beginLine = t.beginLine;
        int beginColumn = t.beginColumn;
        t = null;
        block3: while (true) {
            Node cell = this.createListNode(beginLine, beginColumn);
            if (listHead == this.nRDFnil) {
                listHead = cell;
            }
            if (lastCell != null) {
                this.insert(acc, lastCell, this.nRDFrest, cell);
            }
            int mark = acc.mark();
            Node n = this.GraphNodePath(acc);
            this.insert(acc, mark, cell, this.nRDFfirst, n);
            lastCell = cell;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 130: 
                case 131: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 176: 
                case 179: 
                case 181: 
                case 191: 
                case 193: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(175);
        if (lastCell != null) {
            this.insert(acc, lastCell, this.nRDFrest, this.nRDFnil);
        }
        return listHead;
    }

    public final void AnnotationPath(TripleCollector acc, Node s, Node p, Path path, Node o) throws ParseException {
        block8: {
            Node reifId = null;
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 195: 
                    case 197: {
                        break;
                    }
                    default: {
                        this.jj_la1[119] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 197: {
                        p = this.preConditionReifier(s, p, path, o, this.token.beginLine, this.token.beginColumn);
                        reifId = this.Reifier();
                        reifId = this.insertTripleReifier(acc, reifId, s, p, o, this.token.beginLine, this.token.beginColumn);
                        this.setReifierId(reifId);
                        continue block7;
                    }
                    case 195: {
                        p = this.preConditionReifier(s, p, path, o, this.token.beginLine, this.token.beginColumn);
                        reifId = this.getOrAllocReifierId(acc, s, p, o, this.token.beginLine, this.token.beginColumn);
                        this.clearReifierId();
                        this.AnnotationBlockPath(acc, reifId);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[120] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.clearReifierId();
    }

    public final void AnnotationBlockPath(TripleCollector acc, Node reifId) throws ParseException {
        this.jj_consume_token(195);
        this.PropertyListPathNotEmpty(reifId, acc);
        this.jj_consume_token(196);
    }

    public final void Annotation(TripleCollector acc, Node s, Node p, Path path, Node o) throws ParseException {
        block8: {
            Node reifId = null;
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 195: 
                    case 197: {
                        break;
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 197: {
                        p = this.preConditionReifier(s, p, path, o, this.token.beginLine, this.token.beginColumn);
                        reifId = this.Reifier();
                        reifId = this.insertTripleReifier(acc, reifId, s, p, o, this.token.beginLine, this.token.beginColumn);
                        this.setReifierId(reifId);
                        continue block7;
                    }
                    case 195: {
                        p = this.preConditionReifier(s, p, path, o, this.token.beginLine, this.token.beginColumn);
                        reifId = this.getOrAllocReifierId(acc, s, p, o, this.token.beginLine, this.token.beginColumn);
                        this.clearReifierId();
                        this.AnnotationBlock(acc, reifId);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[122] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void AnnotationBlock(TripleCollector acc, Node reifId) throws ParseException {
        this.jj_consume_token(195);
        this.PropertyListNotEmpty(reifId, acc);
        this.jj_consume_token(196);
    }

    public final Node GraphNode(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 176: 
            case 181: 
            case 191: {
                Node n = this.VarOrTerm();
                return n;
            }
            case 174: 
            case 179: {
                Node n = this.TriplesNode(acc);
                return n;
            }
            case 193: {
                Node n = this.ReifiedTriple(acc);
                return n;
            }
        }
        this.jj_la1[123] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node GraphNodePath(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 176: 
            case 181: 
            case 191: {
                Node n = this.VarOrTerm();
                return n;
            }
            case 174: 
            case 179: {
                Node n = this.TriplesNodePath(acc);
                return n;
            }
            case 193: {
                Node n = this.ReifiedTriple(acc);
                return n;
            }
        }
        this.jj_la1[124] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node VarOrTerm() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                n = this.Var();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                return this.createNode(iri2);
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                n = this.RDFLiteral();
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                n = this.NumericLiteral();
                break;
            }
            case 130: 
            case 131: {
                n = this.BooleanLiteral();
                break;
            }
            case 12: 
            case 181: {
                n = this.BlankNode();
                break;
            }
            case 176: {
                this.jj_consume_token(176);
                return this.nRDFnil;
            }
            case 191: {
                n = this.TripleTerm();
                return n;
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node ReifiedTriple(TripleCollector acc) throws ParseException {
        Node reifId = null;
        Token tok = this.jj_consume_token(193);
        Node s = this.ReifiedTripleSubject(acc);
        Node p = this.Verb();
        Node o = this.ReifiedTripleObject(acc);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 197: {
                reifId = this.Reifier();
                break;
            }
            default: {
                this.jj_la1[126] = this.jj_gen;
            }
        }
        reifId = this.insertTripleReifier(acc, reifId, s, p, o, tok.beginLine, tok.beginColumn);
        this.jj_consume_token(194);
        return reifId;
    }

    public final Node ReifiedTripleSubject(TripleCollector acc) throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13, 14 -> this.Var();
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 170, 171, 172, 173 -> this.RDFLiteral();
            case 154, 155, 156, 157, 158, 159, 160, 161, 162 -> this.NumericLiteral();
            case 130, 131 -> this.BooleanLiteral();
            case 12, 181 -> this.BlankNode();
            case 193 -> this.ReifiedTriple(acc);
            default -> {
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node ReifiedTripleObject(TripleCollector acc) throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13, 14 -> this.Var();
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 170, 171, 172, 173 -> this.RDFLiteral();
            case 154, 155, 156, 157, 158, 159, 160, 161, 162 -> this.NumericLiteral();
            case 130, 131 -> this.BooleanLiteral();
            case 12, 181 -> this.BlankNode();
            case 193 -> this.ReifiedTriple(acc);
            case 191 -> this.TripleTerm();
            default -> {
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node TripleTerm() throws ParseException {
        Node n = null;
        Token openToken = this.jj_consume_token(191);
        Node s = this.TripleTermSubject();
        Node p = this.Verb();
        Node o = this.TripleTermObject();
        n = this.createTripleTerm(s, p, o, openToken.beginLine, openToken.beginColumn);
        this.jj_consume_token(192);
        return n;
    }

    public final Node TripleTermSubject() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13, 14 -> this.Var();
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 170, 171, 172, 173 -> this.RDFLiteral();
            case 154, 155, 156, 157, 158, 159, 160, 161, 162 -> this.NumericLiteral();
            case 130, 131 -> this.BooleanLiteral();
            case 12, 181 -> this.BlankNode();
            default -> {
                this.jj_la1[129] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node TripleTermObject() throws ParseException {
        Node n;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                n = this.Var();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                n = this.createNode(iri2);
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                n = this.RDFLiteral();
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                n = this.NumericLiteral();
                break;
            }
            case 130: 
            case 131: {
                n = this.BooleanLiteral();
                break;
            }
            case 12: 
            case 181: {
                n = this.BlankNode();
                break;
            }
            case 191: {
                Node n2 = this.TripleTerm();
                return n2;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node TripleTermData() throws ParseException {
        Node n = null;
        Token openToken = this.jj_consume_token(191);
        Node s = this.TripleTermDataSubject();
        Node p = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 18 -> {
                this.jj_consume_token(18);
                yield this.nRDFtype;
            }
            default -> {
                this.jj_la1[131] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        Node o = this.TripleTermDataObject();
        n = this.createTripleTerm(s, p, o, openToken.beginLine, openToken.beginColumn);
        this.jj_consume_token(192);
        return n;
    }

    public final Node TripleTermDataSubject() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                n = this.createNode(iri2);
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                n = this.RDFLiteral();
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                n = this.NumericLiteral();
                break;
            }
            case 130: 
            case 131: {
                n = this.BooleanLiteral();
                break;
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node TripleTermDataObject() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                n = this.createNode(iri2);
                break;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                n = this.RDFLiteral();
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                n = this.NumericLiteral();
                break;
            }
            case 130: 
            case 131: {
                n = this.BooleanLiteral();
                break;
            }
            case 191: {
                n = this.TripleTermData();
                break;
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node VarOrIri() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                n = this.Var();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                String iri2 = this.iri();
                n = this.createNode(iri2);
                break;
            }
            default: {
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Var Var() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13 -> this.jj_consume_token(13);
            case 14 -> this.jj_consume_token(14);
            default -> {
                this.jj_la1[135] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return this.createVariable(t.image, t.beginLine, t.beginColumn);
    }

    public final Expr Expression() throws ParseException {
        Expr expr = this.ConditionalOrExpression();
        return expr;
    }

    public final Expr ConditionalOrExpression() throws ParseException {
        Expr expr1 = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 200: {
                    break;
                }
                default: {
                    this.jj_la1[136] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(200);
            Expr expr2 = this.ConditionalAndExpression();
            expr1 = new E_LogicalOr(expr1, expr2);
        }
        return expr1;
    }

    public final Expr ConditionalAndExpression() throws ParseException {
        Expr expr1 = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 201: {
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(201);
            Expr expr2 = this.ValueLogical();
            expr1 = new E_LogicalAnd(expr1, expr2);
        }
        return expr1;
    }

    public final Expr ValueLogical() throws ParseException {
        Expr expr = this.RelationalExpression();
        return expr;
    }

    public final Expr RelationalExpression() throws ParseException {
        Expr expr1 = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: 
            case 73: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 185: {
                        this.jj_consume_token(185);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_Equals(expr1, expr2);
                        break block0;
                    }
                    case 186: {
                        this.jj_consume_token(186);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_NotEquals(expr1, expr2);
                        break block0;
                    }
                    case 188: {
                        this.jj_consume_token(188);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_LessThan(expr1, expr2);
                        break block0;
                    }
                    case 187: {
                        this.jj_consume_token(187);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_GreaterThan(expr1, expr2);
                        break block0;
                    }
                    case 189: {
                        this.jj_consume_token(189);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_LessThanOrEqual(expr1, expr2);
                        break block0;
                    }
                    case 190: {
                        this.jj_consume_token(190);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_GreaterThanOrEqual(expr1, expr2);
                        break block0;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        ExprList a = this.ExpressionList();
                        expr1 = new E_OneOf(expr1, a);
                        break block0;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        this.jj_consume_token(73);
                        ExprList a = this.ExpressionList();
                        expr1 = new E_NotOneOf(expr1, a);
                        break block0;
                    }
                }
                this.jj_la1[138] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
            }
        }
        return expr1;
    }

    public final Expr NumericExpression() throws ParseException {
        Expr expr = this.AdditiveExpression();
        return expr;
    }

    /*
     * Unable to fully structure code
     */
    public final Expr AdditiveExpression() throws ParseException {
        block22: {
            expr1 = this.MultiplicativeExpression();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 202: 
                    case 203: {
                        break;
                    }
                    default: {
                        this.jj_la1[140] = this.jj_gen;
                        break block22;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 202: {
                        this.jj_consume_token(202);
                        expr2 = this.MultiplicativeExpression();
                        expr1 = new E_Add(expr1, expr2);
                        continue block19;
                    }
                    case 203: {
                        this.jj_consume_token(203);
                        expr2 = this.MultiplicativeExpression();
                        expr1 = new E_Subtract(expr1, expr2);
                        continue block19;
                    }
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 157: 
                            case 158: 
                            case 159: {
                                n = this.NumericLiteralPositive();
                                n = this.stripSign(n);
                                expr2 = this.asExpr(n);
                                addition = true;
                                break;
                            }
                            case 160: 
                            case 161: 
                            case 162: {
                                n = this.NumericLiteralNegative();
                                n = this.stripSign(n);
                                expr2 = this.asExpr(n);
                                addition = false;
                                break;
                            }
                            default: {
                                this.jj_la1[141] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 204: 
                                case 205: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[142] = this.jj_gen;
                                    ** GOTO lbl65
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 204: {
                                    this.jj_consume_token(204);
                                    expr3 = this.UnaryExpression();
                                    expr2 = new E_Multiply(expr2, expr3);
                                    continue block20;
                                }
                                case 205: {
                                    this.jj_consume_token(205);
                                    expr3 = this.UnaryExpression();
                                    expr2 = new E_Divide(expr2, expr3);
                                    continue block20;
                                }
                            }
                            break;
                        }
                        this.jj_la1[143] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
lbl65:
                        // 1 sources

                        if (addition) {
                            expr1 = new E_Add(expr1, expr2);
                            continue block19;
                        }
                        expr1 = new E_Subtract(expr1, expr2);
                        continue block19;
                    }
                }
                break;
            }
            this.jj_la1[144] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr1;
    }

    public final Expr MultiplicativeExpression() throws ParseException {
        Expr expr1;
        block8: {
            expr1 = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 204: 
                    case 205: {
                        break;
                    }
                    default: {
                        this.jj_la1[145] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 204: {
                        this.jj_consume_token(204);
                        Expr expr2 = this.UnaryExpression();
                        expr1 = new E_Multiply(expr1, expr2);
                        continue block7;
                    }
                    case 205: {
                        this.jj_consume_token(205);
                        Expr expr2 = this.UnaryExpression();
                        expr1 = new E_Divide(expr1, expr2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[146] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr1;
    }

    public final Expr UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 198: {
                this.jj_consume_token(198);
                Expr expr = this.PrimaryExpression();
                return new E_LogicalNot(expr);
            }
            case 202: {
                this.jj_consume_token(202);
                Expr expr = this.PrimaryExpression();
                return new E_UnaryPlus(expr);
            }
            case 203: {
                this.jj_consume_token(203);
                Expr expr = this.PrimaryExpression();
                return new E_UnaryMinus(expr);
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 191: {
                Expr expr = this.PrimaryExpression();
                return expr;
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174: {
                Expr expr = this.BrackettedExpression();
                return expr;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: {
                Expr expr = this.BuiltInCall();
                return expr;
            }
            case 9: 
            case 10: 
            case 11: {
                Expr expr = this.iriOrFunction();
                return expr;
            }
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                Node n = this.RDFLiteral();
                return this.asExpr(n);
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                Node n = this.NumericLiteral();
                return this.asExpr(n);
            }
            case 130: 
            case 131: {
                Node n = this.BooleanLiteral();
                return this.asExpr(n);
            }
            case 13: 
            case 14: {
                Var n = this.Var();
                return this.asExpr(n);
            }
            case 191: {
                Node n = this.ExprTripleTerm();
                return this.asExpr(n);
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node ExprTripleTerm() throws ParseException {
        Token t = this.jj_consume_token(191);
        Node s = this.ExprTripleTermSubject();
        Node p = this.Verb();
        Node o = this.ExprTripleTermObject();
        Node n = this.createTripleTerm(s, p, o, t.beginLine, t.beginColumn);
        this.jj_consume_token(192);
        return n;
    }

    public final Node ExprTripleTermSubject() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 170, 171, 172, 173 -> this.RDFLiteral();
            case 154, 155, 156, 157, 158, 159, 160, 161, 162 -> this.NumericLiteral();
            case 130, 131 -> this.BooleanLiteral();
            case 13, 14 -> this.Var();
            default -> {
                this.jj_la1[149] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node ExprTripleTermObject() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9, 10, 11 -> {
                String iri = this.iri();
                yield this.createNode(iri);
            }
            case 170, 171, 172, 173 -> this.RDFLiteral();
            case 154, 155, 156, 157, 158, 159, 160, 161, 162 -> this.NumericLiteral();
            case 130, 131 -> this.BooleanLiteral();
            case 13, 14 -> this.Var();
            case 191 -> this.ExprTripleTerm();
            default -> {
                this.jj_la1[150] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Expr BrackettedExpression() throws ParseException {
        this.jj_consume_token(174);
        Expr expr = this.Expression();
        this.jj_consume_token(175);
        return expr;
    }

    public final Expr BuiltInCall() throws ParseException {
        Expr expr1 = null;
        Expr expr2 = null;
        Expr expr3 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: {
                Expr expr = this.Aggregate();
                return expr;
            }
            case 78: {
                this.jj_consume_token(78);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_Str(expr);
            }
            case 83: {
                this.jj_consume_token(83);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_Lang(expr);
            }
            case 84: {
                this.jj_consume_token(84);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_LangMatches(expr1, expr2);
            }
            case 85: {
                this.jj_consume_token(85);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_LangDir(expr);
            }
            case 82: {
                this.jj_consume_token(82);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_Datatype(expr);
            }
            case 71: {
                this.jj_consume_token(71);
                this.jj_consume_token(174);
                Var gn = this.Var();
                this.jj_consume_token(175);
                return new E_Bound(new ExprVar((Node)gn));
            }
            case 76: {
                this.jj_consume_token(76);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return this.makeFunction_IRI(expr);
            }
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return this.makeFunction_URI(expr);
            }
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 174: {
                        this.jj_consume_token(174);
                        expr1 = this.Expression();
                        this.jj_consume_token(175);
                        return this.makeFunction_BNode(expr1);
                    }
                    case 176: {
                        this.jj_consume_token(176);
                        return this.makeFunction_BNode();
                    }
                }
                this.jj_la1[151] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 96: {
                this.jj_consume_token(96);
                this.jj_consume_token(176);
                return new E_Random();
            }
            case 97: {
                this.jj_consume_token(97);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_NumAbs(expr1);
            }
            case 98: {
                this.jj_consume_token(98);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_NumCeiling(expr1);
            }
            case 99: {
                this.jj_consume_token(99);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_NumFloor(expr1);
            }
            case 100: {
                this.jj_consume_token(100);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_NumRound(expr1);
            }
            case 101: {
                this.jj_consume_token(101);
                ExprList a = this.ExpressionList();
                return new E_StrConcat(a);
            }
            case 102: {
                Expr expr = this.SubstringExpression();
                return expr;
            }
            case 103: {
                this.jj_consume_token(103);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrLength(expr1);
            }
            case 104: {
                Expr expr = this.StrReplaceExpression();
                return expr;
            }
            case 105: {
                this.jj_consume_token(105);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrUpperCase(expr1);
            }
            case 106: {
                this.jj_consume_token(106);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrLowerCase(expr1);
            }
            case 107: {
                this.jj_consume_token(107);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrEncodeForURI(expr1);
            }
            case 108: {
                this.jj_consume_token(108);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrContains(expr1, expr2);
            }
            case 109: {
                this.jj_consume_token(109);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrStartsWith(expr1, expr2);
            }
            case 110: {
                this.jj_consume_token(110);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrEndsWith(expr1, expr2);
            }
            case 111: {
                this.jj_consume_token(111);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrBefore(expr1, expr2);
            }
            case 112: {
                this.jj_consume_token(112);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrAfter(expr1, expr2);
            }
            case 113: {
                this.jj_consume_token(113);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeYear(expr1);
            }
            case 114: {
                this.jj_consume_token(114);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeMonth(expr1);
            }
            case 115: {
                this.jj_consume_token(115);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeDay(expr1);
            }
            case 116: {
                this.jj_consume_token(116);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeHours(expr1);
            }
            case 117: {
                this.jj_consume_token(117);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeMinutes(expr1);
            }
            case 118: {
                this.jj_consume_token(118);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeSeconds(expr1);
            }
            case 119: {
                this.jj_consume_token(119);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeTimezone(expr1);
            }
            case 120: {
                this.jj_consume_token(120);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_DateTimeTZ(expr1);
            }
            case 121: {
                this.jj_consume_token(121);
                this.jj_consume_token(176);
                return new E_Now();
            }
            case 122: {
                this.jj_consume_token(122);
                this.jj_consume_token(176);
                return new E_UUID();
            }
            case 123: {
                this.jj_consume_token(123);
                this.jj_consume_token(176);
                return new E_StrUUID();
            }
            case 124: {
                this.jj_consume_token(124);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_MD5(expr1);
            }
            case 125: {
                this.jj_consume_token(125);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_SHA1(expr1);
            }
            case 127: {
                this.jj_consume_token(127);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_SHA256(expr1);
            }
            case 128: {
                this.jj_consume_token(128);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_SHA384(expr1);
            }
            case 129: {
                this.jj_consume_token(129);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(175);
                return new E_SHA512(expr1);
            }
            case 72: {
                this.jj_consume_token(72);
                ExprList a = this.ExpressionList();
                return new E_Coalesce(a);
            }
            case 74: {
                this.jj_consume_token(74);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(183);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_Conditional(expr, expr1, expr2);
            }
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrLang(expr1, expr2);
            }
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(183);
                expr3 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrLangDir(expr1, expr2, expr3);
            }
            case 81: {
                this.jj_consume_token(81);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_StrDatatype(expr1, expr2);
            }
            case 94: {
                this.jj_consume_token(94);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(175);
                return new E_SameTerm(expr1, expr2);
            }
            case 87: {
                this.jj_consume_token(87);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsIRI(expr);
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsURI(expr);
            }
            case 88: {
                this.jj_consume_token(88);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsBlank(expr);
            }
            case 89: {
                this.jj_consume_token(89);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsLiteral(expr);
            }
            case 90: {
                this.jj_consume_token(90);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsNumeric(expr);
            }
            case 91: {
                this.jj_consume_token(91);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_HasLang(expr);
            }
            case 92: {
                this.jj_consume_token(92);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_HasLangDir(expr);
            }
            case 93: {
                Expr expr = this.RegexExpression();
                return expr;
            }
            case 50: {
                Expr expr = this.ExistsFunc();
                return expr;
            }
            case 51: {
                Expr expr = this.NotExistsFunc();
                return expr;
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_IsTriple(expr);
            }
            case 45: {
                this.jj_consume_token(45);
                this.jj_consume_token(174);
                expr1 = this.Expression();
                this.jj_consume_token(183);
                expr2 = this.Expression();
                this.jj_consume_token(183);
                expr3 = this.Expression();
                this.jj_consume_token(175);
                return new E_TripleFn(expr1, expr2, expr3);
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_TripleSubject(expr);
            }
            case 48: {
                this.jj_consume_token(48);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_TriplePredicate(expr);
            }
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(174);
                Expr expr = this.Expression();
                this.jj_consume_token(175);
                return new E_TripleObject(expr);
            }
        }
        this.jj_la1[152] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr RegexExpression() throws ParseException {
        Expr patExpr = null;
        Expr flagsExpr = null;
        this.jj_consume_token(93);
        this.jj_consume_token(174);
        Expr expr = this.Expression();
        this.jj_consume_token(183);
        patExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 183: {
                this.jj_consume_token(183);
                flagsExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
            }
        }
        this.jj_consume_token(175);
        return new E_Regex(expr, patExpr, flagsExpr);
    }

    public final Expr SubstringExpression() throws ParseException {
        Expr expr2 = null;
        Expr expr3 = null;
        this.jj_consume_token(102);
        this.jj_consume_token(174);
        Expr expr1 = this.Expression();
        this.jj_consume_token(183);
        expr2 = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 183: {
                this.jj_consume_token(183);
                expr3 = this.Expression();
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
            }
        }
        this.jj_consume_token(175);
        return new E_StrSubstring(expr1, expr2, expr3);
    }

    public final Expr StrReplaceExpression() throws ParseException {
        Expr expr2 = null;
        Expr expr3 = null;
        Expr expr4 = null;
        this.jj_consume_token(104);
        this.jj_consume_token(174);
        Expr expr1 = this.Expression();
        this.jj_consume_token(183);
        expr2 = this.Expression();
        this.jj_consume_token(183);
        expr3 = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 183: {
                this.jj_consume_token(183);
                expr4 = this.Expression();
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
            }
        }
        this.jj_consume_token(175);
        return new E_StrReplace(expr1, expr2, expr3, expr4);
    }

    public final Expr ExistsFunc() throws ParseException {
        this.jj_consume_token(50);
        Element el = this.GroupGraphPattern();
        return this.createExprExists(el);
    }

    public final Expr NotExistsFunc() throws ParseException {
        this.jj_consume_token(51);
        this.jj_consume_token(50);
        Element el = this.GroupGraphPattern();
        return this.createExprNotExists(el);
    }

    public final Expr Aggregate() throws ParseException {
        Token t;
        Aggregator agg = null;
        String sep = null;
        Expr expr = null;
        Object expr2 = null;
        boolean distinct = false;
        ExprList ordered = new ExprList();
        this.startAggregate();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                t = this.jj_consume_token(57);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[156] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 204: {
                        this.jj_consume_token(204);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 191: 
                    case 198: 
                    case 202: 
                    case 203: {
                        expr = this.Expression();
                        break;
                    }
                    default: {
                        this.jj_la1[157] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(175);
                if (expr == null) {
                    agg = AggregatorFactory.createCount(distinct);
                }
                if (expr == null) break;
                agg = AggregatorFactory.createCountExpr(distinct, expr);
                break;
            }
            case 60: {
                t = this.jj_consume_token(60);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[158] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                this.jj_consume_token(175);
                agg = AggregatorFactory.createSum(distinct, expr);
                break;
            }
            case 58: {
                t = this.jj_consume_token(58);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                this.jj_consume_token(175);
                agg = AggregatorFactory.createMin(distinct, expr);
                break;
            }
            case 59: {
                t = this.jj_consume_token(59);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[160] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                this.jj_consume_token(175);
                agg = AggregatorFactory.createMax(distinct, expr);
                break;
            }
            case 61: {
                t = this.jj_consume_token(61);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[161] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                this.jj_consume_token(175);
                agg = AggregatorFactory.createAvg(distinct, expr);
                break;
            }
            case 68: {
                t = this.jj_consume_token(68);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[162] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                this.jj_consume_token(175);
                agg = AggregatorFactory.createSample(distinct, expr);
                break;
            }
            case 69: {
                t = this.jj_consume_token(69);
                this.jj_consume_token(174);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 22: {
                        t = this.jj_consume_token(22);
                        distinct = true;
                        break;
                    }
                    default: {
                        this.jj_la1[163] = this.jj_gen;
                    }
                }
                expr = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 182: {
                        this.jj_consume_token(182);
                        this.jj_consume_token(55);
                        this.jj_consume_token(185);
                        sep = this.String();
                        break;
                    }
                    default: {
                        this.jj_la1[164] = this.jj_gen;
                    }
                }
                this.jj_consume_token(175);
                agg = AggregatorFactory.createGroupConcat(distinct, expr, sep, ordered);
                break;
            }
            default: {
                this.jj_la1[165] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!this.getAllowAggregatesInExpressions()) {
            SPARQLParser12.throwParseException("Aggregate expression not legal at this point", t.beginLine, t.beginColumn);
        }
        if (this.getAggregateDepth() > 1) {
            SPARQLParser12.throwParseException("Nested aggregate in expression not legal", t.beginLine, t.beginColumn);
        }
        Expr exprAgg = this.getQuery().allocAggregate(agg);
        this.finishAggregate();
        return exprAgg;
    }

    public final Expr iriOrFunction() throws ParseException {
        Args a = null;
        String iri2 = this.iri();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174: 
            case 176: {
                a = this.ArgList();
                break;
            }
            default: {
                this.jj_la1[166] = this.jj_gen;
            }
        }
        if (a == null) {
            return this.asExpr(this.createNode(iri2));
        }
        if (AggregateRegistry.isRegistered(iri2)) {
            if (!this.getAllowAggregatesInExpressions()) {
                SPARQLParser12.throwParseException("Aggregate expression not legal at this point : " + iri2, this.token.beginLine, this.token.beginColumn);
            }
            Aggregator agg = AggregatorFactory.createCustom(iri2, a);
            Expr exprAgg = this.getQuery().allocAggregate(agg);
            return exprAgg;
        }
        return new E_Function(iri2, a);
    }

    public final Node RDFLiteral() throws ParseException {
        String lex = null;
        String uri = null;
        lex = this.String();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 206: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        Token t = this.jj_consume_token(15);
                        return this.createLiteralLang(lex, t.image, this.token.beginLine, this.token.beginColumn);
                    }
                    case 206: {
                        this.jj_consume_token(206);
                        uri = this.iri();
                        return this.createLiteralDT(lex, uri, this.token.beginLine, this.token.beginColumn);
                    }
                }
                this.jj_la1[167] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[168] = this.jj_gen;
        return this.createLiteralString(lex, this.token.beginLine, this.token.beginColumn);
    }

    public final Node NumericLiteral() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154, 155, 156 -> this.NumericLiteralUnsigned();
            case 157, 158, 159 -> this.NumericLiteralPositive();
            case 160, 161, 162 -> this.NumericLiteralNegative();
            default -> {
                this.jj_la1[169] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node NumericLiteralUnsigned() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                Token t = this.jj_consume_token(154);
                return this.createLiteralInteger(t.image);
            }
            case 155: {
                Token t = this.jj_consume_token(155);
                return this.createLiteralDecimal(t.image);
            }
            case 156: {
                Token t = this.jj_consume_token(156);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[170] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralPositive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 157: {
                Token t = this.jj_consume_token(157);
                return this.createLiteralInteger(t.image);
            }
            case 158: {
                Token t = this.jj_consume_token(158);
                return this.createLiteralDecimal(t.image);
            }
            case 159: {
                Token t = this.jj_consume_token(159);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[171] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralNegative() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 160: {
                Token t = this.jj_consume_token(160);
                return this.createLiteralInteger(t.image);
            }
            case 161: {
                Token t = this.jj_consume_token(161);
                return this.createLiteralDecimal(t.image);
            }
            case 162: {
                Token t = this.jj_consume_token(162);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[172] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                return this.XSD_TRUE;
            }
            case 131: {
                this.jj_consume_token(131);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[173] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String String() throws ParseException {
        Token t;
        String lex = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170 -> {
                t = this.jj_consume_token(170);
                yield SPARQLParser12.stripQuotes(t.image);
            }
            case 171 -> {
                t = this.jj_consume_token(171);
                yield SPARQLParser12.stripQuotes(t.image);
            }
            case 172 -> {
                t = this.jj_consume_token(172);
                yield SPARQLParser12.stripQuotes3(t.image);
            }
            case 173 -> {
                t = this.jj_consume_token(173);
                yield SPARQLParser12.stripQuotes3(t.image);
            }
            default -> {
                this.jj_la1[174] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        lex = SPARQLParser12.unescapeStr(lex, t.beginLine, t.beginColumn);
        this.checkString(lex, t.beginLine, t.beginColumn);
        return lex;
    }

    public final String iri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                String iri2 = this.IRIREF();
                return iri2;
            }
            case 10: 
            case 11: {
                String iri3 = this.PrefixedName();
                return iri3;
            }
        }
        this.jj_la1[175] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String PrefixedName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                Token t = this.jj_consume_token(11);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[176] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNode() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                return this.createBNode(t.image, t.beginLine, t.beginColumn);
            }
            case 181: {
                t = this.jj_consume_token(181);
                return this.createBNode(t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[177] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String IRIREF() throws ParseException {
        Token t = this.jj_consume_token(9);
        return this.resolveQuotedIRI(t.image, t.beginLine, t.beginColumn);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x7200000, 0x180000, 0x180000, 0, 0xC00000, 0xC00000, 24576, 24576, 24576, 0, 0, 32256, 0, 28160, 28160, 0, 0, 0, 3584, 0, 0, 0, 0x20000000, 0x18000000, 28160, 0, 28160, 3584, 28160, 0, 28160, 28160, 0x10000000, 0x8000000, 0x18000000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3584, 0, 3584, 0, 32256, 0, 0, 32256, 32256, 32256, 0, 0x200000, 32256, Integer.MIN_VALUE, 0, 32256, 32256, 0, Integer.MIN_VALUE, 0, 24576, 3584, 24576, 0, 0, 3584, 0, 3584, 32256, 32256, 0, 3584, 0x400000, 0, 0, 0, 0, 32256, 32256, 0, 32256, 290304, 0, 290304, 290304, 0, 32256, 290304, 290304, 0, 290304, 290304, 0, 0, 0, 0, 265728, 0, 265728, 0, 265728, 265728, 265728, 265728, 0, 0, 32256, 32256, 0, 0, 0, 0, 32256, 32256, 32256, 0, 32256, 32256, 32256, 32256, 265728, 3584, 3584, 28160, 24576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28160, 28160, 28160, 28160, 0, 0, 0, 0, 0, 0x400000, 28160, 0x400000, 0x400000, 0x400000, 0x400000, 0x400000, 0x400000, 0, 0, 0, 32768, 32768, 0, 0, 0, 0, 0, 0, 3584, 3072, 4096};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 16, 0, 0, 0, 0, 0, 16, 16, 0, 48, 0, 0, 16, 32, 16, 8, 32, 0x200000, 0x400000, 0, 0, 1041227776, 0x100000, 1041227776, 1041227776, 1041227782, 6, 1041227776, 1041227782, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 128, 128, 136, 0, 128, 0, 0, 0, 0, 0, 0, 0, 7552, 0, 0, 0, 0, 7552, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 512, 1041227776, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 524288, 0, 0, 0, 0, 0, 0, 0, 1041227776, 1041227776, 0, 0, 0, 1041227776, 0, 0, 0, 0, 1041227776, 0, 0, 0, 0, 0, 0, 0, 0x3E000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2147483056, 0, 2147483056, 2147483056, 2147483056, 0, 2147483056, 2147483056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2147483056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0, 0, 0, 0, 0, 2147483056, 2147483056, 0, 0, 0, 2147483056, 0, 0, 0, 0, 2147483056, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073741825, 0, -1073741825, -1073741825, -1073741825, 0, -1073741825, -1073741825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073741825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073741825, -1073741825, 0, 0, 0, -1073741825, 0, 0, 0, 0, -1073741825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -67108852, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 3, 3, 0, 3, 3, 0, 0, 0, 0, 0, 8716256, 8716256, 131072, 524288, 131072, 131072, 131072, 131072, 131072, 131072, 0x800000, 32, 96, 0x1000000, 0, 0, 0x200000, 0x600000, -67108852, 0, 0, -67108852, -67108852, -67108852, 0, 0, -67108852, 0, 0, -67108852, -67108852, 0, 0, 131072, 0, -67108852, 0, 0, 0, -67108852, 0, -67108852, 0, 0, 0, 3, 0, 0, 0, 0, 0, -67108852, -67108852, 0, -67108852, 0, 0, 0, 0, 0, -67108852, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -67108852, -67108852, 0, 0, 0, 0, -67108852, -67108852, -67108852, 0, -67108852, -67108852, -67108852, -67108852, 0, -67108852, -67108852, 0, 0, 0, 0, 0, 0, -536870912, -536870912, 0, 0, -536870912, 0, 0, -67108849, -67108849, -67108852, -67108852, 0, 3, 0, 0, 0, 0, -67108849, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -67108864, 0x1C000000, -536870912, 0, 12, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 16384, 16384, 16384, 0, 0, -2144764921, 131072, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 16384, 16384, 16384, 0, 16384, 16384, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2144764921, 0, 0x1000000, -2144764921, -2144764921, -2144764921, 0x1000000, 0, -2144764921, 131072, 0x1000000, -2144764921, -2144764921, 0x1000000, 131072, 0, 81920, -2147468281, 0, 81920, 81920, -2147468281, 81920, -2147468281, 0x200000, 0x200000, 0, 16384, 0, 0x800000, 81920, 0x800000, 81920, -2144764921, -2144764921, 0x1000000, -2144764921, 0, 0x400000, 0, 0, 0x800000, -2144764921, 16384, 16384, 0x400000, 16384, 16384, 0x800000, 0, 0, 0, 16384, 0, 16384, 0, 0, 16384, 0, 0, 540672, 540672, -2144764921, -2144764921, 0, 0, 0, 0, -2144764921, -2144764921, -2145305593, 0, 2112519, -2145371129, 2112519, -2145371129, 0, 15367, -2147468281, 0, 0, 0, 0, 0x7E000000, 0x7E000000, 7, 7, 0, 0, 7, 0, 0, -2147451897, -2147451897, 15367, -2147468281, 81920, 0, 0x800000, 0x800000, 0x800000, 0, -2147451897, 0, 0, 0, 0, 0, 0, 0x400000, 0, 81920, 0, 0, 7, 0, 0, 7, 0, 15360, 0, 0, 0x200000};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 2, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 2, 2, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 0, 0, 0, 0, 0, 2, 131136, 131136, 0, 131136, 131136, 0, 65536, 8192, 0x101400, 131136, 0x101400, 64, 65536, 131072, 131072, 0, 131072, 0, 0, 2, 2, 40, 40, 40, 40, 2, 2, 0, 32, 2, 2, 0, 0, 0, 0, 0, 0, 0, 256, 512, 0, 0, 3072, 0, 12288, 12288, 3072, 12288, 12288, 3136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SPARQLParser12(InputStream stream) {
        this(stream, null);
    }

    public SPARQLParser12(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source = new SPARQLParser12TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser12(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SPARQLParser12TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SPARQLParser12TokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser12(SPARQLParser12TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SPARQLParser12TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 178; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[224];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 178; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 224; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SPARQLParser12.jj_la1_init_0();
        SPARQLParser12.jj_la1_init_1();
        SPARQLParser12.jj_la1_init_2();
        SPARQLParser12.jj_la1_init_3();
        SPARQLParser12.jj_la1_init_4();
        SPARQLParser12.jj_la1_init_5();
        SPARQLParser12.jj_la1_init_6();
    }
}

