/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterProcessBinding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.ExprUtils;

public class QueryIterFilterExpr
extends QueryIterProcessBinding {
    private final Expr expr;

    public QueryIterFilterExpr(QueryIterator input, Expr expr, ExecutionContext context2) {
        super(input, context2);
        this.expr = expr;
    }

    @Override
    public Binding accept(Binding binding) {
        try {
            if (this.expr.isSatisfied(binding, super.getExecContext())) {
                return binding;
            }
            return null;
        }
        catch (QueryCancelledException ex) {
            ex.addSuppressed(new RuntimeException("Query cancelled exception."));
            throw ex;
        }
        catch (ExprException ex) {
            Log.warn(this, "Expression Exception in " + String.valueOf(this.expr), ex);
            return null;
        }
        catch (Exception ex) {
            Log.warn(this, "General exception in " + String.valueOf(this.expr), ex);
            return null;
        }
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext cxt) {
        out.print(Lib.className(this));
        out.print(" ");
        ExprUtils.fmtSPARQL(out, this.expr, cxt);
    }
}

