/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.tokens;

import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.PeekReader;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.slf4j.Logger;

public class TokenizerTextBuilder {
    private PeekReader peekReader = null;
    private InputStream input = null;
    private Reader reader = null;
    private String string = null;
    private boolean singleLineMode = false;
    private boolean utf8 = true;
    private ErrorHandler errorHandler = null;
    private static Logger LOG = SysRIOT.getLogger();

    TokenizerTextBuilder() {
    }

    private void clearInput() {
        this.peekReader = null;
        this.input = null;
        this.reader = null;
        this.string = null;
    }

    public TokenizerTextBuilder source(InputStream input) {
        this.clearInput();
        this.input = input;
        return this;
    }

    public TokenizerTextBuilder source(Reader reader) {
        this.clearInput();
        this.reader = reader;
        return this;
    }

    public TokenizerTextBuilder source(PeekReader peekReader) {
        this.clearInput();
        this.peekReader = peekReader;
        return this;
    }

    public TokenizerTextBuilder fromString(String string) {
        this.clearInput();
        this.string = string;
        return this;
    }

    public TokenizerTextBuilder lineMode(boolean lineMode) {
        this.singleLineMode = lineMode;
        return this;
    }

    public TokenizerTextBuilder asciiOnly(boolean asciiOnly) {
        this.utf8 = !asciiOnly;
        return this;
    }

    public TokenizerTextBuilder errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    private static int countNulls(Object ... objs) {
        int x = 0;
        for (Object obj : objs) {
            if (obj != null) continue;
            ++x;
        }
        return x;
    }

    private static int countNotNulls(Object ... objs) {
        int x = 0;
        for (Object obj : objs) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }

    private static ErrorHandler errorHandlerDft() {
        return ErrorHandlerFactory.errorHandlerWarnOrExceptions(LOG);
    }

    public Tokenizer build() {
        PeekReader pr;
        ErrorHandler errHandler = this.errorHandler != null ? this.errorHandler : TokenizerTextBuilder.errorHandlerDft();
        int x = TokenizerTextBuilder.countNotNulls(this.peekReader, this.input, this.reader, this.string);
        if (x > 1) {
            throw new InternalErrorException("Too many data sources");
        }
        if (this.input != null) {
            pr = this.utf8 ? PeekReader.makeUTF8(this.input) : PeekReader.makeASCII(this.input);
        } else if (this.string != null) {
            pr = PeekReader.readString(this.string);
        } else if (this.reader != null) {
            pr = PeekReader.make(this.reader);
        } else if (this.peekReader != null) {
            pr = this.peekReader;
        } else {
            throw new IllegalStateException("No data source");
        }
        return TokenizerText.internal(pr, this.singleLineMode, !this.utf8, errHandler);
    }
}

