/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.Params;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.Tokenizer;

public class GenericTokenizerAssembler
extends AssemblerBase {
    @Override
    public TokenizerSpec open(Assembler a, Resource root2, Mode mode) {
        if (root2.hasProperty(TextVocab.pClass)) {
            String className = root2.getProperty(TextVocab.pClass).getString();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                Log.error(this, "Tokenizer class " + className + " not found. " + e2.getMessage(), e2);
                return null;
            }
            if (!Tokenizer.class.isAssignableFrom(clazz)) {
                Log.error(this, clazz.getName() + " has to be a subclass of " + Tokenizer.class.getName());
                return null;
            }
            if (root2.hasProperty(TextVocab.pParams)) {
                RDFNode node = root2.getProperty(TextVocab.pParams).getObject();
                if (!node.isResource()) {
                    throw new TextIndexException("text:params must be a list of parameter resources: " + String.valueOf(node));
                }
                List<Params.ParamSpec> specs = Params.getParamSpecs((Resource)node);
                Class[] paramClasses = new Class[specs.size()];
                Object[] paramValues = new Object[specs.size()];
                for (int i = 0; i < specs.size(); ++i) {
                    Params.ParamSpec spec = specs.get(i);
                    paramClasses[i] = spec.getValueClass();
                    paramValues[i] = spec.getValue();
                }
                return new TokenizerSpec(clazz, paramClasses, paramValues);
            }
            return new TokenizerSpec(clazz, new Class[0], new Object[0]);
        }
        throw new TextIndexException("text:class property is required by GenericTokenizer: " + String.valueOf(root2));
    }

    public static class TokenizerSpec {
        public Class<?> clazz;
        public Class<?>[] paramClasses;
        public Object[] paramValues;

        public TokenizerSpec(Class<?> clazz, Class<?>[] paramClasses, Object[] paramValues) {
            this.clazz = clazz;
            this.paramClasses = paramClasses;
            this.paramValues = paramValues;
        }
    }
}

