/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.langtag.InternalLangTag;
import org.apache.jena.langtag.LangTag;

public final class LangTagRFC5646
implements LangTag {
    private final String langTagString;
    private boolean isGrandfathered = false;
    private boolean isPrivateUseLanguage = false;
    private int language0 = -1;
    private int language1 = -1;
    private int script0 = -1;
    private int script1 = -1;
    private int region0 = -1;
    private int region1 = -1;
    private int variant0 = -1;
    private int variant1 = -1;
    private int extension0 = -1;
    private int extension1 = -1;
    private int privateuse0 = -1;
    private int privateuse1 = -1;
    private static Set<String> regular = Set.of("art-lojban", "cel-gaulish", "no-bok", "no-nyn", "zh-guoyu", "zh-hakka", "zh-min", "zh-min-nan", "zh-xiang");
    private static Set<String> irregular = Set.of("en-GB-oed", "i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo", "i-navajo", "i-pwn", "i-tao", "i-tay", "i-tsu", "sgn-BE-FR", "sgn-BE-NL", "sgn-CH-DE");
    private static Set<String> irregular_i = Set.of("i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo", "i-navajo", "i-pwn", "i-tao", "i-tay", "i-tsu");
    private static Set<String> grandfathered = new HashSet<String>(2 * (regular.size() + irregular.size()));

    public static LangTag create(String string) {
        LangTagRFC5646 langtag2 = LangTagRFC5646.parser(string);
        return langtag2;
    }

    @Override
    public String getLanguage() {
        String x = LangTagRFC5646.getSubTag("Language", this.langTagString, this.language0, this.language1, CaseRule.LOWER);
        if (!this.isGrandfathered) {
            return x;
        }
        return switch (x) {
            case "sgn-be-fr" -> "sgn-BE-FR";
            case "sgn-be-nl" -> "sgn-BE-NL";
            case "sgn-ch-de" -> "sgn-CH-DE";
            default -> x;
        };
    }

    @Override
    public String getScript() {
        return LangTagRFC5646.getSubTag("Script", this.langTagString, this.script0, this.script1, CaseRule.TITLE);
    }

    @Override
    public String getRegion() {
        return LangTagRFC5646.getSubTag("Region", this.langTagString, this.region0, this.region1, CaseRule.UPPER);
    }

    @Override
    public String getVariant() {
        return LangTagRFC5646.getSubTag("Variant", this.langTagString, this.variant0, this.variant1, CaseRule.LOWER);
    }

    @Override
    public String getExtension() {
        return LangTagRFC5646.getSubTag("Extension", this.langTagString, this.extension0, this.extension1, CaseRule.LOWER);
    }

    @Override
    public String getPrivateUse() {
        return LangTagRFC5646.getSubTag("Private", this.langTagString, this.privateuse0, this.privateuse1, CaseRule.LOWER);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.langTagString, this.language0, this.language1, this.script0, this.script1, this.variant0, this.variant1, this.extension0, this.extension1, this.privateuse0, this.privateuse1, this.isGrandfathered, this.isPrivateUseLanguage);
    }

    @Override
    public boolean equals(Object obj) {
        boolean sameParsePoints;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LangTagRFC5646)) {
            return false;
        }
        LangTagRFC5646 other = (LangTagRFC5646)obj;
        boolean bl = sameParsePoints = this.extension0 == other.extension0 && this.extension1 == other.extension1 && this.isGrandfathered == other.isGrandfathered && this.isPrivateUseLanguage == other.isPrivateUseLanguage && this.language0 == other.language0 && this.language1 == other.language1 && this.privateuse0 == other.privateuse0 && this.privateuse1 == other.privateuse1 && this.region0 == other.region0 && this.region1 == other.region1 && this.script0 == other.script0 && this.script1 == other.script1 && this.variant0 == other.variant0 && this.variant1 == other.variant1;
        if (!sameParsePoints) {
            return false;
        }
        return Objects.equals(this.langTagString, other.langTagString);
    }

    @Override
    public String toString() {
        return this.langTagString;
    }

    @Override
    public String str() {
        if (this.isPrivateUseLanguage) {
            return InternalLangTag.lowercase(this.langTagString);
        }
        String x = LangTagRFC5646.irregularFormat(this.langTagString);
        if (x != null) {
            return x;
        }
        StringBuffer sb = new StringBuffer();
        this.add(sb, this.getLanguage());
        this.add(sb, this.getScript());
        this.add(sb, this.getRegion());
        this.add(sb, this.getVariant());
        this.add(sb, this.getExtension());
        this.add(sb, this.getPrivateUse());
        return sb.toString();
    }

    private static String irregularFormat(String langTagString) {
        String lcLangTagStr;
        if (InternalLangTag.caseInsensitivePrefix(langTagString, "sgn-")) {
            if (langTagString.equalsIgnoreCase("sgn-BE-FR")) {
                return "sgn-BE-FR";
            }
            if (langTagString.equalsIgnoreCase("sgn-BE-NL")) {
                return "sgn-BE-NL";
            }
            if (langTagString.equalsIgnoreCase("sgn-CH-DE")) {
                return "sgn-CH-DE";
            }
        }
        if ((langTagString.startsWith("i-") || langTagString.startsWith("I-")) && irregular_i.contains(lcLangTagStr = InternalLangTag.lowercase(langTagString))) {
            return lcLangTagStr;
        }
        return null;
    }

    private void add(StringBuffer sb, String subtag) {
        if (subtag == null) {
            return;
        }
        if (!sb.isEmpty()) {
            sb.append('-');
        }
        sb.append(subtag);
    }

    private static String getSubTag(String label, String string, int start, int finish, CaseRule format) {
        if (start == -1) {
            return null;
        }
        if (finish == -1) {
            throw new InternalError(InternalLangTag.titlecase(label) + " start is set but not subtag end: " + string);
        }
        if (start >= finish) {
            throw new InternalError(InternalLangTag.titlecase(label) + " start index is after " + InternalLangTag.lowercase(label) + " end index: " + string);
        }
        String x = string.substring(start, finish);
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case CaseRule.TITLE -> InternalLangTag.titlecase(x);
            case CaseRule.LOWER -> InternalLangTag.lowercase(x);
            case CaseRule.UPPER -> InternalLangTag.uppercase(x);
        };
    }

    private static LangTagRFC5646 parser(String string) {
        LangTagRFC5646 langtag2 = new LangTagRFC5646(string);
        int N = string.length();
        if (N == 0) {
            InternalLangTag.error("Empty string", new Object[0]);
        }
        if (LangTagRFC5646.grandfathered(string)) {
            langtag2.language0 = 0;
            langtag2.language1 = N;
            langtag2.isGrandfathered = true;
            if (string.equalsIgnoreCase("en-GB-oed")) {
                langtag2.language0 = 0;
                langtag2.language1 = 2;
                langtag2.region0 = 3;
                langtag2.region1 = 5;
                langtag2.variant0 = 6;
                langtag2.variant1 = N;
            }
            return langtag2;
        }
        int idx = 0;
        int idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        int segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 1) {
            if (string.startsWith("x-") || string.startsWith("X-")) {
                langtag2.isPrivateUseLanguage = true;
                int idxPrivateUseStart = 0;
                int idxPrivateUseEnd = LangTagRFC5646.maybeSubtags(string, N, idxPrivateUseStart + segLen, 1, 8);
                langtag2.privateuse0 = idxPrivateUseStart;
                langtag2.privateuse1 = idxPrivateUseEnd;
                if (langtag2.privateuse1 < N) {
                    InternalLangTag.error("Trailing characters in private langtag: '%s'", string.substring(langtag2.privateuse1));
                }
                return langtag2;
            }
            InternalLangTag.error("Language part is 1 character: it must be 2-3 characters (4-8 reserved for future use), \"x-\", or a recognized grandfathered tag", new Object[0]);
        }
        if (idx2 < 0) {
            if (segLen > 8) {
                InternalLangTag.error("Language too long (2-3 characters, 4-8 reserved for future use)", new Object[0]);
            }
            langtag2.language0 = 0;
            langtag2.language1 = N;
            InternalLangTag.checkAlpha(string, N, langtag2.language0, langtag2.language1);
            return langtag2;
        }
        if (idx == idx2) {
            InternalLangTag.error("Can not find the language subtag: '%s'", string);
        }
        if (segLen < 2 || segLen > 4) {
            InternalLangTag.error("Language: '%s'", string);
        }
        langtag2.language0 = idx;
        if (segLen == 2 || segLen == 3) {
            int extStart = idx + segLen;
            InternalLangTag.checkAlpha(string, N, langtag2.language0, extStart);
            int extEnd = LangTagRFC5646.maybeSubtags(string, N, extStart, 3, 3);
            if (extEnd > extStart) {
                idx2 = extEnd;
                InternalLangTag.checkAlphaMinus(string, N, extStart, langtag2.language1);
            }
        } else if (segLen > 8) {
            InternalLangTag.error("Language too long (2-3 characters, 4-8 reserved for future use)", new Object[0]);
        }
        langtag2.language1 = idx2;
        LangTagRFC5646.noteSegment("language", string, langtag2.language0, langtag2.language1);
        idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
        idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 4 && InternalLangTag.isAlpha(string.charAt(idx))) {
            int start = idx;
            int finish = idx + segLen;
            langtag2.script0 = idx;
            langtag2.script1 = idx + segLen;
            InternalLangTag.checkAlpha(string, N, langtag2.script0, langtag2.script1);
            LangTagRFC5646.noteSegment("script", string, langtag2.script0, langtag2.script1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        if (segLen == 2 || segLen == 3) {
            langtag2.region0 = idx;
            langtag2.region1 = idx + segLen;
            if (segLen == 2) {
                InternalLangTag.checkAlpha(string, N, langtag2.region0, langtag2.region1);
            } else {
                InternalLangTag.checkDigits(string, N, langtag2.region0, langtag2.region1);
            }
            LangTagRFC5646.noteSegment("region", string, langtag2.region0, langtag2.region1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        while (true) {
            if (segLen >= 5 && segLen <= 8) {
                if (langtag2.variant0 == -1) {
                    langtag2.variant0 = idx;
                }
                langtag2.variant1 = idx + segLen;
                InternalLangTag.checkAlphaNum(string, N, idx, langtag2.variant1);
                LangTagRFC5646.noteSegment("variant", string, langtag2.variant0, langtag2.variant1);
                idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
                idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
                segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
                continue;
            }
            if (segLen != 4) break;
            char ch = string.charAt(idx);
            if (ch >= '0' || ch <= '9') {
                if (langtag2.variant0 == -1) {
                    langtag2.variant0 = idx;
                }
                langtag2.variant1 = idx + segLen;
                InternalLangTag.checkAlphaNum(string, N, idx, langtag2.variant1);
                LangTagRFC5646.noteSegment("variant", string, langtag2.variant0, langtag2.variant1);
            }
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        boolean inPrivateUseSubtag = false;
        HashSet<Character> extSingletons = null;
        new HashSet();
        while (segLen == 1) {
            int idxEndExtra;
            int idxExtStart;
            char singleton = string.charAt(idx);
            if (singleton == 'x' || singleton == 'X') {
                inPrivateUseSubtag = true;
                break;
            }
            if (extSingletons == null) {
                extSingletons = new HashSet<Character>();
                extSingletons.add(Character.valueOf(singleton));
            } else {
                boolean newEntry = extSingletons.add(Character.valueOf(singleton));
                if (!newEntry) {
                    InternalLangTag.error("Duplicate extension singleton: '" + singleton + "'", new Object[0]);
                }
            }
            if (langtag2.extension0 == -1) {
                langtag2.extension0 = idx;
            }
            if ((idxExtStart = idx + segLen) == (idxEndExtra = LangTagRFC5646.maybeSubtags(string, N, idxExtStart, 2, 8))) {
                InternalLangTag.error("Ill-formed extension", new Object[0]);
            }
            if (idxEndExtra > idxExtStart) {
                idx2 = idxEndExtra;
            }
            langtag2.extension1 = idx2;
            InternalLangTag.checkAlphaNumMinus(string, N, langtag2.extension0, langtag2.extension1);
            LangTagRFC5646.noteSegment("extension", string, langtag2.extension0, langtag2.extension1);
            segLen = LangTagRFC5646.segmentLength(N, idx = LangTagRFC5646.segmentNextStart(N, idx, idx2), idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx));
            if (segLen != 0) continue;
            InternalLangTag.error("Ill-formed extension. Trailing dash.", new Object[0]);
        }
        if (inPrivateUseSubtag) {
            langtag2.privateuse0 = idx;
            int idxPrivateUseStart = idx + segLen;
            int idxPrivateUseEnd = LangTagRFC5646.maybeSubtags(string, N, idxPrivateUseStart, 1, 8);
            if (idxPrivateUseStart == idxPrivateUseEnd) {
                InternalLangTag.error("Ill-formed private use component", new Object[0]);
            }
            if (idxPrivateUseEnd > idxPrivateUseStart) {
                idx2 = idxPrivateUseEnd;
            }
            langtag2.privateuse1 = idx2;
            InternalLangTag.checkAlphaNumMinus(string, N, langtag2.privateuse0, langtag2.privateuse1);
            LangTagRFC5646.noteSegment("private use", string, langtag2.privateuse0, langtag2.privateuse1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
            if (segLen == 0) {
                InternalLangTag.error("Ill-formed private use subtag. Trailing dash.", new Object[0]);
            }
        }
        if (idx != -1 && idx < N) {
            InternalLangTag.error("Trailing characters: '%s'", string.substring(idx));
        }
        if (idx2 >= 0) {
            InternalLangTag.error("Bad string: '%s'", string);
        }
        return langtag2;
    }

    private LangTagRFC5646(String string) {
        this.langTagString = string;
    }

    private LangTagRFC5646(String string, int language0, int language1, int script0, int script1, int region0, int region1, int variant0, int variant1, int extension0, int extension1, int privateuse0, int privateuse1, boolean isGrandfathered) {
        this.langTagString = string;
        this.isGrandfathered = isGrandfathered;
        this.language0 = language0;
        this.language1 = language1;
        this.script0 = script0;
        this.script1 = script1;
        this.variant0 = variant0;
        this.variant1 = variant1;
        this.extension0 = extension0;
        this.extension1 = extension1;
        this.privateuse0 = privateuse0;
        this.privateuse1 = privateuse1;
    }

    private static int maybeSubtags(String string, int N, int idxStart, int min2, int max2) {
        int x1;
        char ch;
        boolean numExt = false;
        boolean count = false;
        int x = idxStart;
        while (x >= 0 && x < N && (ch = string.charAt(x)) == '-' && (x1 = LangTagRFC5646.maybeOneSubtag(string, N, x + 1, min2, max2)) > 0) {
            if (x1 == N) {
                x = N;
                break;
            }
            x = x1;
        }
        return x;
    }

    private static int maybeOneSubtag(String string, int N, int idxStart, int min2, int max2) {
        int idx = idxStart;
        if (idx >= N) {
            return -1;
        }
        int idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        int segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 0) {
            InternalLangTag.error("Bad langtag. Found '--'", new Object[0]);
        }
        if (segLen < min2 || segLen > max2) {
            return -1;
        }
        if (!InternalLangTag.isAlpha(string, idxStart, idxStart + segLen)) {
            return -1;
        }
        return idxStart + segLen;
    }

    private static String getSegment(String string, int x0, int x1) {
        if (x0 < 0 && x1 < 0) {
            return null;
        }
        if (x0 < 0 || x1 < 0) {
            InternalLangTag.error("Segment one undef index", new Object[0]);
            return null;
        }
        return string.substring(x0, x1);
    }

    private static int segmentLength(int N, int idx, int idx2) {
        if (idx < 0) {
            return -1;
        }
        if (idx2 < 0) {
            return N - idx;
        }
        return idx2 - idx;
    }

    private static int segmentNextStart(int N, int idx, int idx2) {
        if (idx2 == -1) {
            return -1;
        }
        idx = idx2;
        return ++idx;
    }

    private static void noteSegment(String label, String string, int idx, int idx2) {
    }

    private static int segmentNextFinish(String x, int N, int idx) {
        if (idx == -1) {
            return -1;
        }
        if (idx == N) {
            return -1;
        }
        while (idx < N) {
            char ch = x.charAt(idx);
            if (ch == '-') {
                if (idx == N - 1) {
                    InternalLangTag.error("Language tag string ends in '-'", new Object[0]);
                }
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static boolean grandfathered(String s) {
        return grandfathered.contains(s = s.toLowerCase(Locale.ROOT)) || regular.contains(s);
    }

    static {
        for (String s : irregular) {
            grandfathered.add(InternalLangTag.lowercase(s));
        }
        for (String s : regular) {
            grandfathered.add(InternalLangTag.lowercase(s));
        }
    }

    private static enum CaseRule {
        TITLE,
        LOWER,
        UPPER;

    }

    private static enum CharSet {
        ALPHA,
        ALPHANUM;

    }
}

