/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.Constants;
import org.apache.commons.csv.DuplicateHeaderMode;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOStream;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.output.AppendableOutputStream;

public final class CSVFormat
implements Serializable {
    public static final CSVFormat DEFAULT = new CSVFormat(Builder.create());
    public static final CSVFormat EXCEL = DEFAULT.builder().setIgnoreEmptyLines(false).setAllowMissingColumnNames(true).setTrailingData(true).setLenientEof(true).get();
    public static final CSVFormat INFORMIX_UNLOAD = DEFAULT.builder().setDelimiter('|').setEscape('\\').setQuote(Constants.DOUBLE_QUOTE_CHAR).setRecordSeparator('\n').get();
    public static final CSVFormat INFORMIX_UNLOAD_CSV = DEFAULT.builder().setDelimiter(",").setQuote(Constants.DOUBLE_QUOTE_CHAR).setRecordSeparator('\n').get();
    public static final CSVFormat MONGODB_CSV = DEFAULT.builder().setDelimiter(",").setEscape(Constants.DOUBLE_QUOTE_CHAR).setQuote(Constants.DOUBLE_QUOTE_CHAR).setQuoteMode(QuoteMode.MINIMAL).get();
    public static final CSVFormat MONGODB_TSV = DEFAULT.builder().setDelimiter('\t').setEscape(Constants.DOUBLE_QUOTE_CHAR).setQuote(Constants.DOUBLE_QUOTE_CHAR).setQuoteMode(QuoteMode.MINIMAL).setSkipHeaderRecord(false).get();
    public static final CSVFormat MYSQL = DEFAULT.builder().setDelimiter('\t').setEscape('\\').setIgnoreEmptyLines(false).setQuote(null).setRecordSeparator('\n').setNullString("\\N").setQuoteMode(QuoteMode.ALL_NON_NULL).get();
    public static final CSVFormat ORACLE = DEFAULT.builder().setDelimiter(",").setEscape('\\').setIgnoreEmptyLines(false).setQuote(Constants.DOUBLE_QUOTE_CHAR).setNullString("\\N").setTrim(true).setRecordSeparator(System.lineSeparator()).setQuoteMode(QuoteMode.MINIMAL).get();
    public static final CSVFormat POSTGRESQL_CSV = DEFAULT.builder().setDelimiter(",").setEscape(null).setIgnoreEmptyLines(false).setQuote(Constants.DOUBLE_QUOTE_CHAR).setRecordSeparator('\n').setNullString("").setQuoteMode(QuoteMode.ALL_NON_NULL).get();
    public static final CSVFormat POSTGRESQL_TEXT = DEFAULT.builder().setDelimiter('\t').setEscape('\\').setIgnoreEmptyLines(false).setQuote(null).setRecordSeparator('\n').setNullString("\\N").setQuoteMode(QuoteMode.ALL_NON_NULL).get();
    public static final CSVFormat RFC4180 = DEFAULT.builder().setIgnoreEmptyLines(false).get();
    private static final long serialVersionUID = 2L;
    public static final CSVFormat TDF = DEFAULT.builder().setDelimiter('\t').setIgnoreSurroundingSpaces(true).get();
    private final DuplicateHeaderMode duplicateHeaderMode;
    private final boolean allowMissingColumnNames;
    private final boolean autoFlush;
    private final Character commentMarker;
    private final String delimiter;
    private final Character escapeCharacter;
    private final String[] headers;
    private final String[] headerComments;
    private final boolean ignoreEmptyLines;
    private final boolean ignoreHeaderCase;
    private final boolean ignoreSurroundingSpaces;
    private final String nullString;
    private final Character quoteCharacter;
    private final String quotedNullString;
    private final QuoteMode quoteMode;
    private final String recordSeparator;
    private final boolean skipHeaderRecord;
    private final boolean lenientEof;
    private final boolean trailingData;
    private final boolean trailingDelimiter;
    private final boolean trim;
    private final long maxRows;

    @SafeVarargs
    static <T> T[] clone(T ... values) {
        return values == null ? null : (Object[])values.clone();
    }

    private static boolean contains(String source, char searchCh) {
        return Objects.requireNonNull(source, "source").indexOf(searchCh) >= 0;
    }

    private static boolean containsLineBreak(String source) {
        return CSVFormat.contains(source, '\r') || CSVFormat.contains(source, '\n');
    }

    static CSVFormat copy(CSVFormat format) {
        return format != null ? format.copy() : null;
    }

    static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    private static boolean isTrimChar(char ch) {
        return ch <= ' ';
    }

    private static boolean isTrimChar(CharSequence charSequence, int pos) {
        return CSVFormat.isTrimChar(charSequence.charAt(pos));
    }

    public static CSVFormat newFormat(char delimiter) {
        return new CSVFormat(new Builder().setDelimiter(delimiter));
    }

    static String[] toStringArray(Object[] values) {
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.length];
        Arrays.setAll(strings, i -> Objects.toString(values[i], null));
        return strings;
    }

    static CharSequence trim(CharSequence charSequence) {
        int pos;
        int count;
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int len = count = charSequence.length();
        for (pos = 0; pos < len && CSVFormat.isTrimChar(charSequence, pos); ++pos) {
        }
        while (pos < len && CSVFormat.isTrimChar(charSequence, len - 1)) {
            --len;
        }
        return pos > 0 || len < count ? charSequence.subSequence(pos, len) : charSequence;
    }

    public static CSVFormat valueOf(String format) {
        return Predefined.valueOf(format).getFormat();
    }

    private CSVFormat(Builder builder) {
        this.allowMissingColumnNames = builder.allowMissingColumnNames;
        this.autoFlush = builder.autoFlush;
        this.commentMarker = builder.commentMarker;
        this.delimiter = builder.delimiter;
        this.duplicateHeaderMode = builder.duplicateHeaderMode;
        this.escapeCharacter = builder.escapeCharacter;
        this.headerComments = builder.headerComments;
        this.headers = builder.headers;
        this.ignoreEmptyLines = builder.ignoreEmptyLines;
        this.ignoreHeaderCase = builder.ignoreHeaderCase;
        this.ignoreSurroundingSpaces = builder.ignoreSurroundingSpaces;
        this.lenientEof = builder.lenientEof;
        this.maxRows = builder.maxRows;
        this.nullString = builder.nullString;
        this.quoteCharacter = builder.quoteCharacter;
        this.quoteMode = builder.quoteMode;
        this.quotedNullString = builder.quotedNullString;
        this.recordSeparator = builder.recordSeparator;
        this.skipHeaderRecord = builder.skipHeaderRecord;
        this.trailingData = builder.trailingData;
        this.trailingDelimiter = builder.trailingDelimiter;
        this.trim = builder.trim;
        this.validate();
    }

    private void append(char c, Appendable appendable) throws IOException {
        appendable.append(c);
    }

    private void append(CharSequence csq, Appendable appendable) throws IOException {
        appendable.append(csq);
    }

    public Builder builder() {
        return Builder.create(this);
    }

    CSVFormat copy() {
        return this.builder().get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVFormat other = (CSVFormat)obj;
        return this.allowMissingColumnNames == other.allowMissingColumnNames && this.autoFlush == other.autoFlush && Objects.equals(this.commentMarker, other.commentMarker) && Objects.equals(this.delimiter, other.delimiter) && this.duplicateHeaderMode == other.duplicateHeaderMode && Objects.equals(this.escapeCharacter, other.escapeCharacter) && Arrays.equals(this.headerComments, other.headerComments) && Arrays.equals(this.headers, other.headers) && this.ignoreEmptyLines == other.ignoreEmptyLines && this.ignoreHeaderCase == other.ignoreHeaderCase && this.ignoreSurroundingSpaces == other.ignoreSurroundingSpaces && this.lenientEof == other.lenientEof && Objects.equals(this.nullString, other.nullString) && Objects.equals(this.quoteCharacter, other.quoteCharacter) && this.quoteMode == other.quoteMode && Objects.equals(this.quotedNullString, other.quotedNullString) && Objects.equals(this.recordSeparator, other.recordSeparator) && this.skipHeaderRecord == other.skipHeaderRecord && this.trailingData == other.trailingData && this.trailingDelimiter == other.trailingDelimiter && this.trim == other.trim;
    }

    private void escape(char c, Appendable appendable) throws IOException {
        this.append(this.escapeCharacter.charValue(), appendable);
        this.append(c, appendable);
    }

    public String format(Object ... values) {
        return Uncheck.get(() -> this.format_(values));
    }

    private String format_(Object ... values) throws IOException {
        StringWriter out = new StringWriter();
        try (CSVPrinter csvPrinter = new CSVPrinter(out, this);){
            csvPrinter.printRecord(values);
            String res = out.toString();
            int len = this.recordSeparator != null ? res.length() - this.recordSeparator.length() : res.length();
            String string = res.substring(0, len);
            return string;
        }
    }

    @Deprecated
    public boolean getAllowDuplicateHeaderNames() {
        return this.duplicateHeaderMode == DuplicateHeaderMode.ALLOW_ALL;
    }

    public boolean getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    @Deprecated
    public char getDelimiter() {
        return this.delimiter.charAt(0);
    }

    char[] getDelimiterCharArray() {
        return this.delimiter.toCharArray();
    }

    public String getDelimiterString() {
        return this.delimiter;
    }

    public DuplicateHeaderMode getDuplicateHeaderMode() {
        return this.duplicateHeaderMode;
    }

    char getEscapeChar() {
        return this.escapeCharacter != null ? this.escapeCharacter.charValue() : (char)'\u0000';
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String[] getHeader() {
        return this.headers != null ? (String[])this.headers.clone() : null;
    }

    public String[] getHeaderComments() {
        return this.headerComments != null ? (String[])this.headerComments.clone() : null;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public boolean getIgnoreHeaderCase() {
        return this.ignoreHeaderCase;
    }

    public boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public boolean getLenientEof() {
        return this.lenientEof;
    }

    public long getMaxRows() {
        return this.maxRows;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Character getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public QuoteMode getQuoteMode() {
        return this.quoteMode;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public boolean getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public boolean getTrailingData() {
        return this.trailingData;
    }

    public boolean getTrailingDelimiter() {
        return this.trailingDelimiter;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.headerComments);
        result = 31 * result + Arrays.hashCode(this.headers);
        return 31 * result + Objects.hash(new Object[]{this.allowMissingColumnNames, this.autoFlush, this.commentMarker, this.delimiter, this.duplicateHeaderMode, this.escapeCharacter, this.ignoreEmptyLines, this.ignoreHeaderCase, this.ignoreSurroundingSpaces, this.lenientEof, this.nullString, this.quoteCharacter, this.quoteMode, this.quotedNullString, this.recordSeparator, this.skipHeaderRecord, this.trailingData, this.trailingDelimiter, this.trim});
    }

    public boolean isCommentMarkerSet() {
        return this.commentMarker != null;
    }

    private boolean isDelimiter(char ch0, CharSequence charSeq, int startIndex, char[] delimiter, int delimiterLength) {
        if (ch0 != delimiter[0]) {
            return false;
        }
        int len = charSeq.length();
        if (startIndex + delimiterLength > len) {
            return false;
        }
        for (int i = 1; i < delimiterLength; ++i) {
            if (charSeq.charAt(startIndex + i) == delimiter[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEscapeCharacterSet() {
        return this.escapeCharacter != null;
    }

    public boolean isNullStringSet() {
        return this.nullString != null;
    }

    public boolean isQuoteCharacterSet() {
        return this.quoteCharacter != null;
    }

    <T> IOStream<T> limit(IOStream<T> stream) {
        return this.useMaxRows() ? stream.limit(this.getMaxRows()) : stream;
    }

    public CSVParser parse(Reader reader) throws IOException {
        return ((CSVParser.Builder)CSVParser.builder().setReader(reader)).setFormat(this).get();
    }

    public CSVPrinter print(Appendable out) throws IOException {
        return new CSVPrinter(out, this);
    }

    public CSVPrinter print(File out, Charset charset) throws IOException {
        return this.print(out.toPath(), charset);
    }

    private void print(InputStream inputStream, Appendable out, boolean newRecord) throws IOException {
        boolean quoteCharacterSet;
        if (!newRecord) {
            this.append(this.getDelimiterString(), out);
        }
        if (quoteCharacterSet = this.isQuoteCharacterSet()) {
            this.append(this.getQuoteCharacter().charValue(), out);
        }
        try (Base64OutputStream outputStream = new Base64OutputStream(new AppendableOutputStream<Appendable>(out));){
            IOUtils.copy(inputStream, (OutputStream)outputStream);
        }
        if (quoteCharacterSet) {
            this.append(this.getQuoteCharacter().charValue(), out);
        }
    }

    public synchronized void print(Object value, Appendable out, boolean newRecord) throws IOException {
        CharSequence charSequence;
        if (value == null) {
            charSequence = null == this.nullString ? "" : (QuoteMode.ALL == this.quoteMode ? this.quotedNullString : this.nullString);
        } else if (value instanceof CharSequence) {
            charSequence = (CharSequence)value;
        } else {
            if (value instanceof Reader) {
                this.print((Reader)value, out, newRecord);
                return;
            }
            if (value instanceof InputStream) {
                this.print((InputStream)value, out, newRecord);
                return;
            }
            charSequence = value.toString();
        }
        charSequence = this.getTrim() ? CSVFormat.trim(charSequence) : charSequence;
        this.print(value, charSequence, out, newRecord);
    }

    private synchronized void print(Object object, CharSequence value, Appendable out, boolean newRecord) throws IOException {
        boolean offset = false;
        int len = value.length();
        if (!newRecord) {
            out.append(this.getDelimiterString());
        }
        if (object == null) {
            out.append(value);
        } else if (this.isQuoteCharacterSet()) {
            this.printWithQuotes(object, value, out, newRecord);
        } else if (this.isEscapeCharacterSet()) {
            this.printWithEscapes(value, out);
        } else {
            out.append(value, 0, len);
        }
    }

    public CSVPrinter print(Path out, Charset charset) throws IOException {
        return this.print(Files.newBufferedWriter(out, charset, new OpenOption[0]));
    }

    private void print(Reader reader, Appendable out, boolean newRecord) throws IOException {
        if (!newRecord) {
            this.append(this.getDelimiterString(), out);
        }
        if (this.isQuoteCharacterSet()) {
            this.printWithQuotes(reader, out);
        } else if (this.isEscapeCharacterSet()) {
            this.printWithEscapes(reader, out);
        } else if (out instanceof Writer) {
            IOUtils.copyLarge(reader, (Writer)out);
        } else {
            IOUtils.copy(reader, out);
        }
    }

    public CSVPrinter printer() throws IOException {
        return new CSVPrinter(System.out, this);
    }

    public synchronized void println(Appendable appendable) throws IOException {
        if (this.getTrailingDelimiter()) {
            this.append(this.getDelimiterString(), appendable);
        }
        if (this.recordSeparator != null) {
            this.append(this.recordSeparator, appendable);
        }
    }

    public synchronized void printRecord(Appendable appendable, Object ... values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            this.print(values[i], appendable, i == 0);
        }
        this.println(appendable);
    }

    private void printWithEscapes(CharSequence charSeq, Appendable appendable) throws IOException {
        int pos;
        int start = 0;
        int end = charSeq.length();
        char[] delimArray = this.getDelimiterCharArray();
        int delimLength = delimArray.length;
        char escape = this.getEscapeChar();
        for (pos = 0; pos < end; ++pos) {
            boolean isLf;
            char c = charSeq.charAt(pos);
            boolean isDelimiterStart = this.isDelimiter(c, charSeq, pos, delimArray, delimLength);
            boolean isCr = c == '\r';
            boolean bl = isLf = c == '\n';
            if (!isCr && !isLf && c != escape && !isDelimiterStart) continue;
            if (pos > start) {
                appendable.append(charSeq, start, pos);
            }
            if (isLf) {
                c = 'n';
            } else if (isCr) {
                c = 'r';
            }
            this.escape(c, appendable);
            if (isDelimiterStart) {
                for (int i = 1; i < delimLength; ++i) {
                    this.escape(charSeq.charAt(++pos), appendable);
                }
            }
            start = pos + 1;
        }
        if (pos > start) {
            appendable.append(charSeq, start, pos);
        }
    }

    private void printWithEscapes(Reader reader, Appendable appendable) throws IOException {
        int c;
        int start = 0;
        int pos = 0;
        ExtendedBufferedReader bufferedReader = new ExtendedBufferedReader(reader);
        char[] delimArray = this.getDelimiterCharArray();
        int delimLength = delimArray.length;
        char escape = this.getEscapeChar();
        StringBuilder builder = new StringBuilder(8192);
        char[] lookAheadBuffer = new char[delimLength - 1];
        while (-1 != (c = bufferedReader.read())) {
            boolean isLf;
            builder.append((char)c);
            Arrays.fill(lookAheadBuffer, '\u0000');
            bufferedReader.peek(lookAheadBuffer);
            String test = builder.toString() + new String(lookAheadBuffer);
            boolean isDelimiterStart = this.isDelimiter((char)c, test, pos, delimArray, delimLength);
            boolean isCr = c == 13;
            boolean bl = isLf = c == 10;
            if (isCr || isLf || c == escape || isDelimiterStart) {
                if (pos > start) {
                    this.append(builder.substring(start, pos), appendable);
                    builder.setLength(0);
                    pos = -1;
                }
                if (isLf) {
                    c = 110;
                } else if (isCr) {
                    c = 114;
                }
                this.escape((char)c, appendable);
                if (isDelimiterStart) {
                    for (int i = 1; i < delimLength; ++i) {
                        this.escape((char)bufferedReader.read(), appendable);
                    }
                }
                start = pos + 1;
            }
            ++pos;
        }
        if (pos > start) {
            appendable.append(builder, start, pos);
        }
    }

    private void printWithQuotes(Object object, CharSequence charSeq, Appendable out, boolean newRecord) throws IOException {
        char c;
        boolean quote = false;
        int start = 0;
        int pos = 0;
        int len = charSeq.length();
        char[] delim = this.getDelimiterCharArray();
        int delimLength = delim.length;
        char quoteChar = this.getQuoteCharacter().charValue();
        char escapeChar = this.isEscapeCharacterSet() ? this.getEscapeChar() : quoteChar;
        QuoteMode quoteModePolicy = this.getQuoteMode();
        if (quoteModePolicy == null) {
            quoteModePolicy = QuoteMode.MINIMAL;
        }
        switch (quoteModePolicy) {
            case ALL: 
            case ALL_NON_NULL: {
                quote = true;
                break;
            }
            case NON_NUMERIC: {
                quote = !(object instanceof Number);
                break;
            }
            case NONE: {
                this.printWithEscapes(charSeq, out);
                return;
            }
            case MINIMAL: {
                if (len <= 0) {
                    if (newRecord) {
                        quote = true;
                    }
                } else {
                    c = charSeq.charAt(pos);
                    if (c <= '#') {
                        quote = true;
                    } else {
                        while (pos < len) {
                            c = charSeq.charAt(pos);
                            if (c == '\n' || c == '\r' || c == quoteChar || c == escapeChar || this.isDelimiter(c, charSeq, pos, delim, delimLength)) {
                                quote = true;
                                break;
                            }
                            ++pos;
                        }
                        if (!quote && CSVFormat.isTrimChar(c = charSeq.charAt(pos = len - 1))) {
                            quote = true;
                        }
                    }
                }
                if (quote) break;
                out.append(charSeq, start, len);
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected Quote value: " + (Object)((Object)quoteModePolicy));
            }
        }
        if (!quote) {
            out.append(charSeq, start, len);
            return;
        }
        out.append(quoteChar);
        while (pos < len) {
            c = charSeq.charAt(pos);
            if (c == quoteChar || c == escapeChar) {
                out.append(charSeq, start, pos);
                out.append(escapeChar);
                start = pos;
            }
            ++pos;
        }
        out.append(charSeq, start, pos);
        out.append(quoteChar);
    }

    private void printWithQuotes(Reader reader, Appendable appendable) throws IOException {
        int c;
        if (this.getQuoteMode() == QuoteMode.NONE) {
            this.printWithEscapes(reader, appendable);
            return;
        }
        char quote = this.getQuoteCharacter().charValue();
        this.append(quote, appendable);
        while (-1 != (c = reader.read())) {
            this.append((char)c, appendable);
            if (c != quote) continue;
            this.append(quote, appendable);
        }
        this.append(quote, appendable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscapeCharacterSet()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escapeCharacter).append('>');
        }
        if (this.isQuoteCharacterSet()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteCharacter).append('>');
        }
        if (this.quoteMode != null) {
            sb.append(' ');
            sb.append("QuoteMode=<").append((Object)this.quoteMode).append('>');
        }
        if (this.isCommentMarkerSet()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentMarker).append('>');
        }
        if (this.isNullStringSet()) {
            sb.append(' ');
            sb.append("NullString=<").append(this.nullString).append('>');
        }
        if (this.recordSeparator != null) {
            sb.append(' ');
            sb.append("RecordSeparator=<").append(this.recordSeparator).append('>');
        }
        if (this.getIgnoreEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.getIgnoreSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        if (this.getIgnoreHeaderCase()) {
            sb.append(" IgnoreHeaderCase:ignored");
        }
        sb.append(" SkipHeaderRecord:").append(this.skipHeaderRecord);
        if (this.headerComments != null) {
            sb.append(' ');
            sb.append("HeaderComments:").append(Arrays.toString(this.headerComments));
        }
        if (this.headers != null) {
            sb.append(' ');
            sb.append("Header:").append(Arrays.toString(this.headers));
        }
        return sb.toString();
    }

    String trim(String value) {
        return this.getTrim() ? value.trim() : value;
    }

    boolean useMaxRows() {
        return this.getMaxRows() > 0L;
    }

    boolean useRow(long rowNum) {
        return !this.useMaxRows() || rowNum <= this.getMaxRows();
    }

    private void validate() throws IllegalArgumentException {
        if (this.quoteCharacter != null && CSVFormat.contains(this.delimiter, this.quoteCharacter.charValue())) {
            throw new IllegalArgumentException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteCharacter + "')");
        }
        if (this.escapeCharacter != null && CSVFormat.contains(this.delimiter, this.escapeCharacter.charValue())) {
            throw new IllegalArgumentException("The escape character and the delimiter cannot be the same ('" + this.escapeCharacter + "')");
        }
        if (this.commentMarker != null && CSVFormat.contains(this.delimiter, this.commentMarker.charValue())) {
            throw new IllegalArgumentException("The comment start character and the delimiter cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.quoteCharacter != null && this.quoteCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start character and the quoteChar cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter != null && this.escapeCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start and the escape character cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter == null && this.quoteMode == QuoteMode.NONE) {
            throw new IllegalArgumentException("Quote mode set to NONE but no escape character is set");
        }
        if (this.headers != null && this.duplicateHeaderMode != DuplicateHeaderMode.ALLOW_ALL) {
            HashSet<String> dupCheckSet = new HashSet<String>(this.headers.length);
            boolean emptyDuplicatesAllowed = this.duplicateHeaderMode == DuplicateHeaderMode.ALLOW_EMPTY;
            for (String header : this.headers) {
                boolean containsHeader;
                boolean blank = CSVFormat.isBlank(header);
                boolean bl = containsHeader = !dupCheckSet.add(blank ? "" : header);
                if (!containsHeader || blank && emptyDuplicatesAllowed) continue;
                throw new IllegalArgumentException(String.format("The header contains a duplicate name: \"%s\" in %s. If this is valid then use CSVFormat.Builder.setDuplicateHeaderMode().", header, Arrays.toString(this.headers)));
            }
        }
    }

    @Deprecated
    public CSVFormat withAllowDuplicateHeaderNames() {
        return this.builder().setDuplicateHeaderMode(DuplicateHeaderMode.ALLOW_ALL).get();
    }

    @Deprecated
    public CSVFormat withAllowDuplicateHeaderNames(boolean allowDuplicateHeaderNames) {
        DuplicateHeaderMode mode = allowDuplicateHeaderNames ? DuplicateHeaderMode.ALLOW_ALL : DuplicateHeaderMode.ALLOW_EMPTY;
        return this.builder().setDuplicateHeaderMode(mode).get();
    }

    @Deprecated
    public CSVFormat withAllowMissingColumnNames() {
        return this.builder().setAllowMissingColumnNames(true).get();
    }

    @Deprecated
    public CSVFormat withAllowMissingColumnNames(boolean allowMissingColumnNames) {
        return this.builder().setAllowMissingColumnNames(allowMissingColumnNames).get();
    }

    @Deprecated
    public CSVFormat withAutoFlush(boolean autoFlush) {
        return this.builder().setAutoFlush(autoFlush).get();
    }

    @Deprecated
    public CSVFormat withCommentMarker(char commentMarker) {
        return this.builder().setCommentMarker(commentMarker).get();
    }

    @Deprecated
    public CSVFormat withCommentMarker(Character commentMarker) {
        return this.builder().setCommentMarker(commentMarker).get();
    }

    @Deprecated
    public CSVFormat withDelimiter(char delimiter) {
        return this.builder().setDelimiter(delimiter).get();
    }

    @Deprecated
    public CSVFormat withEscape(char escape) {
        return this.builder().setEscape(escape).get();
    }

    @Deprecated
    public CSVFormat withEscape(Character escape) {
        return this.builder().setEscape(escape).get();
    }

    @Deprecated
    public CSVFormat withFirstRecordAsHeader() {
        return this.builder().setHeader(new String[0]).setSkipHeaderRecord(true).get();
    }

    @Deprecated
    public CSVFormat withHeader(Class<? extends Enum<?>> headerEnum) {
        return this.builder().setHeader(headerEnum).get();
    }

    @Deprecated
    public CSVFormat withHeader(ResultSet resultSet) throws SQLException {
        return this.builder().setHeader(resultSet).get();
    }

    @Deprecated
    public CSVFormat withHeader(ResultSetMetaData resultSetMetaData) throws SQLException {
        return this.builder().setHeader(resultSetMetaData).get();
    }

    @Deprecated
    public CSVFormat withHeader(String ... header) {
        return this.builder().setHeader(header).get();
    }

    @Deprecated
    public CSVFormat withHeaderComments(Object ... headerComments) {
        return this.builder().setHeaderComments(headerComments).get();
    }

    @Deprecated
    public CSVFormat withIgnoreEmptyLines() {
        return this.builder().setIgnoreEmptyLines(true).get();
    }

    @Deprecated
    public CSVFormat withIgnoreEmptyLines(boolean ignoreEmptyLines) {
        return this.builder().setIgnoreEmptyLines(ignoreEmptyLines).get();
    }

    @Deprecated
    public CSVFormat withIgnoreHeaderCase() {
        return this.builder().setIgnoreHeaderCase(true).get();
    }

    @Deprecated
    public CSVFormat withIgnoreHeaderCase(boolean ignoreHeaderCase) {
        return this.builder().setIgnoreHeaderCase(ignoreHeaderCase).get();
    }

    @Deprecated
    public CSVFormat withIgnoreSurroundingSpaces() {
        return this.builder().setIgnoreSurroundingSpaces(true).get();
    }

    @Deprecated
    public CSVFormat withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
        return this.builder().setIgnoreSurroundingSpaces(ignoreSurroundingSpaces).get();
    }

    @Deprecated
    public CSVFormat withNullString(String nullString) {
        return this.builder().setNullString(nullString).get();
    }

    @Deprecated
    public CSVFormat withQuote(char quoteChar) {
        return this.builder().setQuote(quoteChar).get();
    }

    @Deprecated
    public CSVFormat withQuote(Character quoteChar) {
        return this.builder().setQuote(quoteChar).get();
    }

    @Deprecated
    public CSVFormat withQuoteMode(QuoteMode quoteMode) {
        return this.builder().setQuoteMode(quoteMode).get();
    }

    @Deprecated
    public CSVFormat withRecordSeparator(char recordSeparator) {
        return this.builder().setRecordSeparator(recordSeparator).get();
    }

    @Deprecated
    public CSVFormat withRecordSeparator(String recordSeparator) {
        return this.builder().setRecordSeparator(recordSeparator).get();
    }

    @Deprecated
    public CSVFormat withSkipHeaderRecord() {
        return this.builder().setSkipHeaderRecord(true).get();
    }

    @Deprecated
    public CSVFormat withSkipHeaderRecord(boolean skipHeaderRecord) {
        return this.builder().setSkipHeaderRecord(skipHeaderRecord).get();
    }

    @Deprecated
    public CSVFormat withSystemRecordSeparator() {
        return this.builder().setRecordSeparator(System.lineSeparator()).get();
    }

    @Deprecated
    public CSVFormat withTrailingDelimiter() {
        return this.builder().setTrailingDelimiter(true).get();
    }

    @Deprecated
    public CSVFormat withTrailingDelimiter(boolean trailingDelimiter) {
        return this.builder().setTrailingDelimiter(trailingDelimiter).get();
    }

    @Deprecated
    public CSVFormat withTrim() {
        return this.builder().setTrim(true).get();
    }

    @Deprecated
    public CSVFormat withTrim(boolean trim) {
        return this.builder().setTrim(trim).get();
    }

    public static class Builder
    implements Supplier<CSVFormat> {
        private boolean allowMissingColumnNames;
        private boolean autoFlush;
        private Character commentMarker;
        private String delimiter;
        private DuplicateHeaderMode duplicateHeaderMode;
        private Character escapeCharacter;
        private String[] headerComments;
        private String[] headers;
        private boolean ignoreEmptyLines;
        private boolean ignoreHeaderCase;
        private boolean ignoreSurroundingSpaces;
        private String nullString;
        private Character quoteCharacter;
        private String quotedNullString;
        private QuoteMode quoteMode;
        private String recordSeparator;
        private boolean skipHeaderRecord;
        private boolean lenientEof;
        private boolean trailingData;
        private boolean trailingDelimiter;
        private boolean trim;
        private long maxRows;

        public static Builder create() {
            return new Builder().setDelimiter(",").setQuote(Constants.DOUBLE_QUOTE_CHAR).setRecordSeparator("\r\n").setIgnoreEmptyLines(true).setDuplicateHeaderMode(DuplicateHeaderMode.ALLOW_ALL);
        }

        public static Builder create(CSVFormat csvFormat) {
            return new Builder(csvFormat);
        }

        private Builder() {
        }

        private Builder(CSVFormat csvFormat) {
            this.allowMissingColumnNames = csvFormat.allowMissingColumnNames;
            this.autoFlush = csvFormat.autoFlush;
            this.commentMarker = csvFormat.commentMarker;
            this.delimiter = csvFormat.delimiter;
            this.duplicateHeaderMode = csvFormat.duplicateHeaderMode;
            this.escapeCharacter = csvFormat.escapeCharacter;
            this.headerComments = csvFormat.headerComments;
            this.headers = csvFormat.headers;
            this.ignoreEmptyLines = csvFormat.ignoreEmptyLines;
            this.ignoreHeaderCase = csvFormat.ignoreHeaderCase;
            this.ignoreSurroundingSpaces = csvFormat.ignoreSurroundingSpaces;
            this.lenientEof = csvFormat.lenientEof;
            this.maxRows = csvFormat.maxRows;
            this.nullString = csvFormat.nullString;
            this.quoteCharacter = csvFormat.quoteCharacter;
            this.quoteMode = csvFormat.quoteMode;
            this.quotedNullString = csvFormat.quotedNullString;
            this.recordSeparator = csvFormat.recordSeparator;
            this.skipHeaderRecord = csvFormat.skipHeaderRecord;
            this.trailingData = csvFormat.trailingData;
            this.trailingDelimiter = csvFormat.trailingDelimiter;
            this.trim = csvFormat.trim;
        }

        @Deprecated
        public CSVFormat build() {
            return this.get();
        }

        @Override
        public CSVFormat get() {
            return new CSVFormat(this);
        }

        @Deprecated
        public Builder setAllowDuplicateHeaderNames(boolean allowDuplicateHeaderNames) {
            this.setDuplicateHeaderMode(allowDuplicateHeaderNames ? DuplicateHeaderMode.ALLOW_ALL : DuplicateHeaderMode.ALLOW_EMPTY);
            return this;
        }

        public Builder setAllowMissingColumnNames(boolean allowMissingColumnNames) {
            this.allowMissingColumnNames = allowMissingColumnNames;
            return this;
        }

        public Builder setAutoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
            return this;
        }

        public Builder setCommentMarker(char commentMarker) {
            this.setCommentMarker(Character.valueOf(commentMarker));
            return this;
        }

        public Builder setCommentMarker(Character commentMarker) {
            if (CSVFormat.isLineBreak(commentMarker)) {
                throw new IllegalArgumentException("The comment start marker character cannot be a line break");
            }
            this.commentMarker = commentMarker;
            return this;
        }

        public Builder setDelimiter(char delimiter) {
            return this.setDelimiter(String.valueOf(delimiter));
        }

        public Builder setDelimiter(String delimiter) {
            if (CSVFormat.containsLineBreak(delimiter)) {
                throw new IllegalArgumentException("The delimiter cannot be a line break");
            }
            if (delimiter.isEmpty()) {
                throw new IllegalArgumentException("The delimiter cannot be empty");
            }
            this.delimiter = delimiter;
            return this;
        }

        public Builder setDuplicateHeaderMode(DuplicateHeaderMode duplicateHeaderMode) {
            this.duplicateHeaderMode = Objects.requireNonNull(duplicateHeaderMode, "duplicateHeaderMode");
            return this;
        }

        public Builder setEscape(char escapeCharacter) {
            this.setEscape(Character.valueOf(escapeCharacter));
            return this;
        }

        public Builder setEscape(Character escapeCharacter) {
            if (CSVFormat.isLineBreak(escapeCharacter)) {
                throw new IllegalArgumentException("The escape character cannot be a line break");
            }
            this.escapeCharacter = escapeCharacter;
            return this;
        }

        public Builder setHeader(Class<? extends Enum<?>> headerEnum) {
            String[] header = null;
            if (headerEnum != null) {
                Enum[] enumValues = headerEnum.getEnumConstants();
                header = new String[enumValues.length];
                Arrays.setAll(header, i -> enumValues[i].name());
            }
            return this.setHeader(header);
        }

        public Builder setHeader(ResultSet resultSet) throws SQLException {
            return this.setHeader(resultSet != null ? resultSet.getMetaData() : null);
        }

        public Builder setHeader(ResultSetMetaData resultSetMetaData) throws SQLException {
            String[] labels = null;
            if (resultSetMetaData != null) {
                int columnCount = resultSetMetaData.getColumnCount();
                labels = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    labels[i] = resultSetMetaData.getColumnLabel(i + 1);
                }
            }
            return this.setHeader(labels);
        }

        public Builder setHeader(String ... header) {
            this.headers = CSVFormat.clone(header);
            return this;
        }

        public Builder setHeaderComments(Object ... headerComments) {
            this.headerComments = CSVFormat.clone(CSVFormat.toStringArray(headerComments));
            return this;
        }

        public Builder setHeaderComments(String ... headerComments) {
            this.headerComments = CSVFormat.clone(headerComments);
            return this;
        }

        public Builder setIgnoreEmptyLines(boolean ignoreEmptyLines) {
            this.ignoreEmptyLines = ignoreEmptyLines;
            return this;
        }

        public Builder setIgnoreHeaderCase(boolean ignoreHeaderCase) {
            this.ignoreHeaderCase = ignoreHeaderCase;
            return this;
        }

        public Builder setIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
            this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
            return this;
        }

        public Builder setLenientEof(boolean lenientEof) {
            this.lenientEof = lenientEof;
            return this;
        }

        public Builder setMaxRows(long maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder setNullString(String nullString) {
            this.nullString = nullString;
            this.quotedNullString = this.quoteCharacter + nullString + this.quoteCharacter;
            return this;
        }

        public Builder setQuote(char quoteCharacter) {
            this.setQuote(Character.valueOf(quoteCharacter));
            return this;
        }

        public Builder setQuote(Character quoteCharacter) {
            if (CSVFormat.isLineBreak(quoteCharacter)) {
                throw new IllegalArgumentException("The quoteCharacter cannot be a line break");
            }
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public Builder setQuoteMode(QuoteMode quoteMode) {
            this.quoteMode = quoteMode;
            return this;
        }

        public Builder setRecordSeparator(char recordSeparator) {
            this.recordSeparator = String.valueOf(recordSeparator);
            return this;
        }

        public Builder setRecordSeparator(String recordSeparator) {
            this.recordSeparator = recordSeparator;
            return this;
        }

        public Builder setSkipHeaderRecord(boolean skipHeaderRecord) {
            this.skipHeaderRecord = skipHeaderRecord;
            return this;
        }

        public Builder setTrailingData(boolean trailingData) {
            this.trailingData = trailingData;
            return this;
        }

        public Builder setTrailingDelimiter(boolean trailingDelimiter) {
            this.trailingDelimiter = trailingDelimiter;
            return this;
        }

        public Builder setTrim(boolean trim) {
            this.trim = trim;
            return this;
        }
    }

    public static enum Predefined {
        Default(DEFAULT),
        Excel(EXCEL),
        InformixUnload(INFORMIX_UNLOAD),
        InformixUnloadCsv(INFORMIX_UNLOAD_CSV),
        MongoDBCsv(MONGODB_CSV),
        MongoDBTsv(MONGODB_TSV),
        MySQL(MYSQL),
        Oracle(ORACLE),
        PostgreSQLCsv(POSTGRESQL_CSV),
        PostgreSQLText(POSTGRESQL_TEXT),
        RFC4180(RFC4180),
        TDF(TDF);

        private final CSVFormat format;

        private Predefined(CSVFormat format) {
            this.format = format;
        }

        public CSVFormat getFormat() {
            return this.format;
        }
    }
}

