/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmdline.CmdARQ;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.DatasetBuilderStd;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.sys.TDBInternal;
import tdb.cmdline.ModTDBDataset;

public abstract class CmdTDB
extends CmdARQ {
    protected final ModTDBDataset tdbDatasetAssembler = new ModTDBDataset();
    private static boolean initialized = false;

    protected CmdTDB(String[] argv) {
        super(argv);
        CmdTDB.init();
        super.addModule(this.tdbDatasetAssembler);
        this.modVersion.addClass("TDB1", TDB1.class);
    }

    public static synchronized void init() {
        JenaSystem.init();
        if (initialized) {
            return;
        }
        initialized = true;
        DatasetBuilderStd.setOptimizerWarningFlag(false);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    protected Location getLocation() {
        return this.tdbDatasetAssembler.getLocation();
    }

    protected DatasetGraph getDatasetGraph() {
        return this.getDataset().asDatasetGraph();
    }

    protected DatasetGraphTDB getDatasetGraphTDB() {
        DatasetGraph dsg = this.getDatasetGraph();
        return TDBInternal.getBaseDatasetGraphTDB(dsg);
    }

    protected Dataset getDataset() {
        return this.tdbDatasetAssembler.getDataset();
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }
}

