/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.Dispatcher;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ResponseUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletChannel {
    private static final Logger LOG = LoggerFactory.getLogger(ServletChannel.class);
    private final ServletChannelState _state;
    private final ServletContextHandler.ServletScopedContext _context;
    private final ServletContextHandler.ServletContextApi _servletContextApi;
    private final ConnectionMetaData _connectionMetaData;
    private final AtomicLong _requests = new AtomicLong();
    final HttpInput _httpInput;
    private final HttpOutput _httpOutput;
    private ServletContextRequest _servletContextRequest;
    private Request _request;
    private Response _response;
    private Callback _callback;

    public ServletChannel(ServletContextHandler servletContextHandler, Request request) {
        this(servletContextHandler, request.getConnectionMetaData());
    }

    public ServletChannel(ServletContextHandler servletContextHandler, ConnectionMetaData connectionMetaData) {
        this._context = servletContextHandler.getContext();
        this._servletContextApi = this._context.getServletContext();
        this._connectionMetaData = connectionMetaData;
        this._state = new ServletChannelState(this);
        this._httpInput = new HttpInput(this);
        this._httpOutput = new HttpOutput(this);
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void associate(ServletContextRequest servletContextRequest) {
        this._httpInput.reopen();
        this._servletContextRequest = servletContextRequest;
        this._request = this._servletContextRequest;
        this._response = this._servletContextRequest.getServletContextResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("associate {} -> {} : {}", this, this._servletContextRequest, this._state);
        }
    }

    public void associate(Request request, Response response, Callback callback) {
        if (this._callback != null) {
            throw new IllegalStateException();
        }
        if (request != this._request && Request.as(request, ServletContextRequest.class) != this._servletContextRequest) {
            throw new IllegalStateException();
        }
        this._request = request;
        this._response = response;
        this._callback = callback;
        this._state.openOutput();
        if (LOG.isDebugEnabled()) {
            LOG.debug("associate {} -> {},{},{}", this, this._request, this._response, this._callback);
        }
    }

    public ServletContextHandler.ServletScopedContext getContext() {
        return this._context;
    }

    public ServletContextHandler getServletContextHandler() {
        return (ServletContextHandler)this._context.getContextHandler();
    }

    public ServletContextHandler.ServletContextApi getServletContextApi() {
        return this._servletContextApi;
    }

    public HttpOutput getHttpOutput() {
        return this._httpOutput;
    }

    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public boolean isAborted() {
        return this._state.isAborted();
    }

    public boolean isSendError() {
        return this._state.isSendError();
    }

    protected String formatAddrOrHost(String addr) {
        return HostPort.normalizeHost(addr);
    }

    public ServletChannelState getServletRequestState() {
        return this._state;
    }

    private long getBytesWritten() {
        return Response.getContentBytesWritten(this.getServletContextResponse());
    }

    public long getIdleTimeout() {
        return this._connectionMetaData.getConnection().getEndPoint().getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._connectionMetaData.getConnection().getEndPoint().setIdleTimeout(timeoutMs);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._connectionMetaData.getHttpConfiguration();
    }

    public Server getServer() {
        return ((Handler.Abstract)this._context.getContextHandler()).getServer();
    }

    public ServletContextRequest getServletContextRequest() {
        return this._servletContextRequest;
    }

    public Request getRequest() {
        return this._request;
    }

    public ServletContextResponse getServletContextResponse() {
        ServletContextRequest request = this._servletContextRequest;
        if (this._servletContextRequest == null) {
            throw new IllegalStateException("Request/Response does not exist (likely recycled)");
        }
        return request.getServletContextResponse();
    }

    public Response getResponse() {
        if (this._response == null) {
            throw new IllegalStateException("Response does not exist (likely recycled)");
        }
        return this._response;
    }

    public Connection getConnection() {
        return this._connectionMetaData.getConnection();
    }

    public EndPoint getEndPoint() {
        return this.getConnection().getEndPoint();
    }

    public String getLocalName() {
        InetSocketAddress local = this.getLocalAddress();
        if (local != null) {
            return Request.getHostName(local);
        }
        return null;
    }

    public int getLocalPort() {
        InetSocketAddress local = this.getLocalAddress();
        return local == null ? 0 : local.getPort();
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = this.getRequest().getConnectionMetaData().getLocalSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress inetSocketAddress;
        SocketAddress socketAddress = this.getRequest().getConnectionMetaData().getRemoteSocketAddress();
        return socketAddress instanceof InetSocketAddress ? (inetSocketAddress = (InetSocketAddress)socketAddress) : null;
    }

    public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null) {
            return httpConfiguration.getServerAuthority();
        }
        return null;
    }

    void recycle(Throwable x) {
        this._httpInput.recycle();
        this._httpOutput.recycle();
        this._state.recycle();
        this._servletContextRequest = null;
        this._request = null;
        this._response = null;
        this._callback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} ", (Object)this._servletContextRequest.getHttpURI(), (Object)this);
        }
        ServletChannelState.Action action = this._state.handling();
        block21: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action {} {}", (Object)action, (Object)this);
                }
                switch (action) {
                    case TERMINATED: {
                        this.onCompleted();
                        break block21;
                    }
                    case WAIT: {
                        break block21;
                    }
                    case DISPATCH: {
                        this.reopen();
                        this.dispatch();
                        break;
                    }
                    case ASYNC_DISPATCH: {
                        this.reopen();
                        this.dispatchAsync();
                        break;
                    }
                    case ASYNC_TIMEOUT: {
                        this._state.onTimeout();
                        break;
                    }
                    case SEND_ERROR: {
                        Throwable throwable;
                        Object errorException = this._servletContextRequest.getAttribute("jakarta.servlet.error.exception");
                        Throwable cause = errorException instanceof Throwable ? (throwable = (Throwable)errorException) : null;
                        try {
                            this.getServletContextResponse().resetContent();
                            Integer code = (Integer)this._servletContextRequest.getAttribute("jakarta.servlet.error.status_code");
                            if (code == null) {
                                code = 500;
                            }
                            this.getServletContextResponse().setStatus(code);
                            if (!this._httpInput.consumeAvailable()) {
                                ResponseUtils.ensureNotPersistent(this._servletContextRequest, this._servletContextRequest.getServletContextResponse());
                            }
                            ContextHandler.ScopedContext context2 = (ContextHandler.ScopedContext)this._servletContextRequest.getAttribute("org.eclipse.jetty.server.error_context");
                            Request.Handler errorHandler = ErrorHandler.getErrorHandler(this.getServer(), context2 == null ? null : (ContextHandler)context2.getContextHandler());
                            if (HttpStatus.hasNoBody(this.getServletContextResponse().getStatus()) || errorHandler == null) {
                                this.sendErrorResponseAndComplete();
                            } else {
                                this.reopen();
                                this._state.errorHandling();
                                errorHandler.handle(this.getServletContextRequest(), this.getServletContextResponse(), Callback.from(() -> this._state.errorHandlingComplete(null), this._state::errorHandlingComplete));
                            }
                            break;
                        }
                        catch (Throwable x) {
                            if (cause == null) {
                                cause = x;
                            } else {
                                ExceptionUtil.addSuppressedIfNotAssociated(cause, x);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Could not perform error handling, aborting", cause);
                            }
                            try {
                                if (this._state.isResponseCommitted()) {
                                    this._state.errorHandlingComplete(cause);
                                    break;
                                }
                                this.getServletContextResponse().resetContent();
                                this.sendErrorResponseAndComplete();
                            }
                            catch (Throwable t) {
                                ExceptionUtil.addSuppressedIfNotAssociated(t, cause);
                                this.abort(t);
                            }
                            break;
                        }
                        finally {
                            this._servletContextRequest.removeAttribute("org.eclipse.jetty.server.error_context");
                        }
                    }
                    case ASYNC_ERROR: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case READ_CALLBACK: {
                        this._context.run(this._servletContextRequest.getHttpInput()::readCallback);
                        break;
                    }
                    case WRITE_CALLBACK: {
                        this._context.run(this._servletContextRequest.getHttpOutput()::writeCallback);
                        break;
                    }
                    case COMPLETE: {
                        long written;
                        ServletContextResponse response = this.getServletContextResponse();
                        if (!response.isCommitted() && response.getStatus() >= 200) {
                            ResponseUtils.ensureConsumeAvailableOrNotPersistent(this._servletContextRequest, response);
                        }
                        if (!this._servletContextRequest.isHead() && response.getStatus() != 304 && response.isContentIncomplete(written = response.getContentBytesWritten())) {
                            this.sendErrorOrAbort("Insufficient content written %d < %d".formatted(written, response.getContentLength()));
                            break;
                        }
                        response.completeOutput(Callback.from(Invocable.InvocationType.NON_BLOCKING, () -> this._state.completed(null), this._state::completed));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.toString());
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    LOG.trace("IGNORED", failure);
                }
                this.handleException(failure);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!handle {} {}", (Object)action, (Object)this);
        }
    }

    private void reopen() {
        this._servletContextRequest.getServletContextResponse().getHttpOutput().reopen();
        this.getHttpOutput().reopen();
    }

    private boolean sendErrorOrAbort(String message) {
        try {
            if (this.isCommitted()) {
                this.abort(new IOException(message));
                return false;
            }
            this.getServletContextResponse().getServletApiResponse().sendError(500, message);
            return true;
        }
        catch (Throwable x) {
            LOG.trace("IGNORED", x);
            this.abort(x);
            return false;
        }
    }

    protected void handleException(Throwable failure) {
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (quiet != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._servletContextRequest.getServletApiRequest().getRequestURI(), failure);
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("handleException {}", (Object)this._servletContextRequest.getServletApiRequest().getRequestURI(), (Object)failure);
            } else {
                LOG.warn("handleException {} {}", (Object)this._servletContextRequest.getServletApiRequest().getRequestURI(), (Object)noStack.toString());
            }
        } else {
            ServletContextRequest request = this._servletContextRequest;
            LOG.warn(request == null ? "unknown request" : request.getServletApiRequest().getRequestURI(), failure);
        }
        try {
            boolean abort = this._state.onError(failure);
            if (abort) {
                this.abort(failure);
            }
        }
        catch (Throwable x) {
            this.abort(failure);
        }
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            for (Class<?> x : targets) {
                if (!x.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    public void sendErrorResponseAndComplete() {
        try {
            this._state.completing();
            this.getServletContextResponse().write(true, this.getServletContextResponse().getHttpOutput().getByteBuffer(), Callback.from(() -> this._state.completed(null), this._state::completed));
        }
        catch (Throwable x) {
            this.abort(x);
            this._state.completed(x);
        }
    }

    public String toString() {
        if (this._servletContextRequest == null) {
            return String.format("%s@%x{null}", this.getClass().getSimpleName(), this.hashCode());
        }
        long timeStamp = Request.getTimeStamp(this._servletContextRequest);
        return String.format("%s@%x{s=%s,r=%s,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._requests, this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._servletContextRequest.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - timeStamp});
    }

    void onTrailers(HttpFields trailers) {
        this._servletContextRequest.setTrailers(trailers);
    }

    public void onCompleted() {
        ServletApiRequest apiRequest = this._servletContextRequest.getServletApiRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCompleted for {} written app={} net={}", apiRequest.getRequestURI(), this.getHttpOutput().getWritten(), this.getBytesWritten());
        }
        if (this.getServer().getRequestLog() instanceof CustomRequestLog) {
            CustomRequestLog.LogDetail logDetail = new CustomRequestLog.LogDetail(this._servletContextRequest.getServletName(), apiRequest.getServletContext().getRealPath(Request.getPathInContext(this._servletContextRequest)));
            this._servletContextRequest.setAttribute(CustomRequestLog.LOG_DETAIL, logDetail);
        }
        Callback callback = this._callback;
        Throwable failure = this._state.completeResponse();
        if (failure == null) {
            callback.succeeded();
        } else {
            callback.failed(failure);
        }
    }

    public boolean isCommitted() {
        return this._state.isResponseCommitted();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._state.isResponseCompleted();
    }

    protected void execute(Runnable task) {
        this._context.execute(task);
    }

    protected void execute(Runnable task, Request request) {
        this._context.execute(task, request);
    }

    public void abort(Throwable failure) {
        this._state.abort(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() throws Exception {
        ServletContextHandler servletContextHandler = this.getServletContextHandler();
        ServletContextRequest servletContextRequest = this.getServletContextRequest();
        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
        try {
            servletContextHandler.requestInitialized(servletContextRequest, servletApiRequest);
            ServletHandler servletHandler = servletContextHandler.getServletHandler();
            ServletHandler.MappedServlet mappedServlet = servletContextRequest.getMatchedResource().getResource();
            mappedServlet.handle(servletHandler, Request.getPathInContext(servletContextRequest), servletApiRequest, servletContextRequest.getHttpServletResponse());
        }
        finally {
            servletContextHandler.requestDestroyed(servletContextRequest, servletApiRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchAsync() throws Exception {
        ServletContextHandler servletContextHandler = this.getServletContextHandler();
        ServletContextRequest servletContextRequest = this.getServletContextRequest();
        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
        try {
            HttpURI uri;
            String pathInContext;
            servletContextHandler.requestInitialized(servletContextRequest, servletApiRequest);
            AsyncContextEvent asyncContextEvent = this._state.getAsyncContextEvent();
            String dispatchString = asyncContextEvent.getDispatchPath();
            if (dispatchString != null) {
                String contextPath = this._context.getContextPath();
                HttpURI.Immutable dispatchUri = HttpURI.from(dispatchString);
                pathInContext = URIUtil.canonicalPath(dispatchUri.getPath());
                uri = HttpURI.build(servletContextRequest.getHttpURI()).path(URIUtil.addPaths(contextPath, pathInContext)).query(dispatchUri.getQuery());
            } else {
                uri = asyncContextEvent.getBaseURI();
                if (uri == null) {
                    uri = servletContextRequest.getHttpURI();
                    pathInContext = Request.getPathInContext(servletContextRequest);
                } else {
                    pathInContext = uri.getCanonicalPath();
                    int length = this._context.getContextPath().length();
                    if (length > 1) {
                        pathInContext = pathInContext.substring(length);
                    }
                }
            }
            String decodedPathInContext = URIUtil.decodePath(pathInContext);
            Dispatcher dispatcher = new Dispatcher(servletContextHandler, uri, decodedPathInContext);
            dispatcher.async(asyncContextEvent.getSuppliedRequest(), asyncContextEvent.getSuppliedResponse());
        }
        finally {
            servletContextHandler.requestDestroyed(servletContextRequest, servletApiRequest);
        }
    }
}

