/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.QuerySyntaxSubstituteScope;
import org.apache.jena.sparql.syntax.syntaxtransform.TransformElementLib;

public class QueryTransformOps {
    public static Query syntaxSubstitute(Query input, Map<Var, Node> substitutions) {
        QuerySyntaxSubstituteScope.scopeCheck(input, substitutions.keySet());
        Query output = QueryTransformOps.transformTopLevel(input, substitutions);
        return output;
    }

    private static Query transformTopLevel(Query query2, Map<Var, Node> substitutions) {
        Query query22 = QueryTransformOps.transformSubstitute(query2, substitutions);
        if (query2.isSelectType()) {
            query22.setQueryResultStar(false);
            substitutions.forEach((v, n) -> {
                NodeValue nv = NodeValue.makeNode(n);
                query22.getProject().update((Var)v, NodeValue.makeNode(n));
            });
        }
        return query22;
    }

    @Deprecated
    public static Query transform(Query query2, Map<Var, ? extends Node> substitutions) {
        return QueryTransformOps.replaceVars(query2, substitutions);
    }

    public static Query replaceVars(Query query2, Map<Var, ? extends Node> substitutions) {
        return QueryTransformOps.transformSubstitute(query2, substitutions);
    }

    @Deprecated
    public static Query transformQuery(Query query2, Map<String, ? extends RDFNode> substitutions) {
        return QueryTransformOps.queryReplaceVars(query2, substitutions);
    }

    public static Query queryReplaceVars(Query query2, Map<String, ? extends RDFNode> substitutions) {
        Map<Var, Node> map = TransformElementLib.convert(substitutions);
        return QueryTransformOps.replaceVars(query2, map);
    }

    private static Query transformSubstitute(Query query2, Map<Var, ? extends Node> substitutions) {
        QuerySyntaxSubstituteScope.scopeCheck(query2, substitutions.keySet());
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return QueryTransformOps.transform(query2, eltrans, exprTrans);
    }

    public static Query transform(Query query2, ElementTransform transform, ExprTransform exprTransform) {
        Query q2 = QueryTransformOps.shallowCopy(query2);
        QueryTransformOps.mutateByQueryType(q2, exprTransform);
        QueryTransformOps.mutateVarExprList(q2.getGroupBy(), exprTransform);
        QueryTransformOps.mutateExprList(q2.getHavingExprs(), exprTransform);
        if (q2.getOrderBy() != null) {
            QueryTransformOps.mutateSortConditions(q2.getOrderBy(), exprTransform);
        }
        QueryTransformOps.mutateQueryPattern(q2, transform, exprTransform);
        if (query2.isQueryResultStar()) {
            q2.resetResultVars();
        }
        QueryTransformOps.setAggregators(q2, query2, exprTransform);
        return q2;
    }

    private static void mutateQueryPattern(Query q2, ElementTransform transform, ExprTransform exprTransform) {
        Element el2;
        Element el = q2.getQueryPattern();
        Element element = el2 = el == null ? null : ElementTransformer.transform(el, transform, exprTransform);
        if (el2 != null && !(el2 instanceof ElementGroup) && !(el2 instanceof ElementSubQuery)) {
            ElementGroup eg = new ElementGroup();
            eg.addElement(el2);
            el2 = eg;
        }
        q2.setQueryPattern(el2);
        if (q2.hasValues()) {
            ElementData elData = new ElementData(q2.getValuesVariables(), q2.getValuesData());
            Element rawElData2 = ElementTransformer.transform(elData, transform, exprTransform);
            if (!(rawElData2 instanceof ElementData)) {
                throw new ARQException("Can't transform a values data block to a different type other than ElementData. Transform yeld type " + Objects.toString(rawElData2.getClass()));
            }
            ElementData elData2 = (ElementData)rawElData2;
            q2.setValuesDataBlock(elData2.getVars(), elData2.getRows());
        }
    }

    private static void setAggregators(Query newQuery, Query query2, ExprTransform exprTransform) {
        for (ExprAggregator aggregator : query2.getAggregators()) {
            newQuery.getAggregators().add((ExprAggregator)exprTransform.transform(aggregator));
        }
    }

    private static void mutateByQueryType(Query q2, ExprTransform exprTransform) {
        switch (q2.queryType()) {
            case ASK: {
                break;
            }
            case CONSTRUCT: {
                Template template = q2.getConstructTemplate();
                QuadAcc acc = new QuadAcc();
                List<Quad> quads = template.getQuads();
                quads.forEach(q -> {
                    Node g = QueryTransformOps.transform(q.getGraph(), exprTransform);
                    Node s = QueryTransformOps.transform(q.getSubject(), exprTransform);
                    Node p = QueryTransformOps.transform(q.getPredicate(), exprTransform);
                    Node o = QueryTransformOps.transform(q.getObject(), exprTransform);
                    acc.addQuad(Quad.create(g, s, p, o));
                });
                Template template2 = new Template(acc);
                q2.setConstructTemplate(template2);
                break;
            }
            case DESCRIBE: {
                QueryTransformOps.mutateDescribeVar(q2.getProjectVars(), q2.getResultURIs(), exprTransform);
                break;
            }
            case SELECT: {
                QueryTransformOps.mutateVarExprList(q2.getProject(), exprTransform);
                break;
            }
            case CONSTRUCT_JSON: {
                throw new UnsupportedOperationException("Transform of JSON template queries");
            }
            default: {
                throw new JenaException("Unknown query type");
            }
        }
    }

    public static Query transform(Query query2, ElementTransform transform) {
        ExprTransformApplyElementTransform noop = new ExprTransformApplyElementTransform(transform);
        return QueryTransformOps.transform(query2, transform, noop);
    }

    private static void mutateConstruct(Query query2, Query query22, ElementTransform transform) {
        if (query2.isConstructQuad()) {
            Template template = query2.getConstructTemplate();
            List<Quad> quads = template.getQuads();
            QuadAcc accQuads = new QuadAcc();
            quads.forEach(quad1 -> {
                Quad quad2 = transform.transform((Quad)quad1);
                accQuads.addQuad(quad2);
            });
            Template template2 = new Template(accQuads);
            query22.setConstructTemplate(template2);
            return;
        }
        if (query2.isConstructType()) {
            Template template = query2.getConstructTemplate();
            List<Triple> triples = template.getBGP().getList();
            BasicPattern accTriple = new BasicPattern();
            triples.forEach(triple1 -> {
                Triple triple2 = transform.transform((Triple)triple1);
                accTriple.add(triple2);
            });
            Template template2 = new Template(accTriple);
            query22.setConstructTemplate(template2);
            return;
        }
    }

    private static void mutateExprList(List<Expr> exprList, ExprTransform exprTransform) {
        for (int i = 0; i < exprList.size(); ++i) {
            Expr e1 = exprList.get(0);
            Expr e2 = ExprTransformer.transform(exprTransform, e1);
            if (e2 == null || e2 == e1) continue;
            exprList.set(i, e2);
        }
    }

    private static void mutateSortConditions(List<SortCondition> conditions, ExprTransform exprTransform) {
        for (int i = 0; i < conditions.size(); ++i) {
            SortCondition s1 = conditions.get(i);
            Expr e2 = ExprTransformer.transform(exprTransform, s1.expression);
            if (e2 == null || s1.expression.equals(e2)) continue;
            conditions.set(i, new SortCondition(e2, s1.direction));
        }
    }

    private static void mutateVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        VarExprList x = QueryTransformOps.transformVarExprList(varExprList, exprTransform);
        varExprList.clear();
        varExprList.addAll(x);
    }

    private static void mutateDescribeVar(List<Var> varList, List<Node> constants, ExprTransform exprTransform) {
        ArrayList<Var> varList2 = new ArrayList<Var>(varList.size());
        for (Var v : varList) {
            Node n = QueryTransformOps.transform(v, exprTransform);
            if (n != v) {
                if (constants.contains(n)) continue;
                constants.add(n);
                continue;
            }
            varList2.add(v);
        }
        if (varList2.size() != varList.size()) {
            varList.clear();
            varList.addAll(varList2);
        }
    }

    private static VarExprList transformVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        VarExprList varExprList2 = new VarExprList();
        boolean changed = false;
        for (Var v : varExprList.getVars()) {
            Expr e2 = varExprList.getExpr(v);
            ExprVar ev = new ExprVar(v);
            Expr ev2 = exprTransform.transform(ev);
            if (ev != ev2) {
                changed = true;
            }
            if (e2 == null) {
                if (ev2.isConstant()) {
                    varExprList2.remove(v);
                    varExprList2.add(v, ev2);
                    continue;
                }
                if (ev2.isVariable()) {
                    varExprList2.add(ev2.asVar());
                    continue;
                }
                throw new ARQException("Can't substitute " + v + " because it's not a simple value: " + ev2);
            }
            Expr e22 = ExprTransformer.transform(exprTransform, e2);
            if (e22 != e2) {
                changed = true;
            }
            if (!ev2.isVariable()) {
                throw new ARQException("Can't substitute (" + v + ", " + e2 + ") as (" + ev2 + ", " + e22 + ")");
            }
            varExprList2.add(ev.asVar(), e22);
        }
        return varExprList2;
    }

    private static Node transform(Node node, ExprTransform exprTransform) {
        if (!Var.isVar(node)) {
            return node;
        }
        Var v = Var.alloc(node);
        ExprVar ev = new ExprVar(v);
        Expr e2 = exprTransform.transform(ev);
        if (e2 == null || e2 == ev) {
            return node;
        }
        if (!e2.isConstant()) {
            return node;
        }
        return e2.getConstant().getNode();
    }

    public static Query shallowCopy(Query query2) {
        QueryShallowCopy copy = new QueryShallowCopy();
        query2.visit(copy);
        Query q2 = copy.newQuery;
        return q2;
    }

    static class QueryShallowCopy
    implements QueryVisitor {
        final Query newQuery = new Query();

        QueryShallowCopy() {
        }

        @Override
        public void startVisit(Query query2) {
            this.newQuery.setSyntax(query2.getSyntax());
            if (query2.explicitlySetBaseURI()) {
                this.newQuery.setBaseURI(query2.getPrologue().getBaseURI());
            }
            this.newQuery.setQueryResultStar(query2.isQueryResultStar());
            if (query2.hasDatasetDescription()) {
                DatasetDescription desc = query2.getDatasetDescription();
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addGraphURI(x);
                }
                for (String x : desc.getNamedGraphURIs()) {
                    this.newQuery.addNamedGraphURI(x);
                }
            }
        }

        @Override
        public void visitPrologue(Prologue prologue) {
            PrefixMapping pmap = new PrefixMappingImpl().setNsPrefixes(prologue.getPrefixMapping());
            this.newQuery.setPrefixMapping(pmap);
        }

        @Override
        public void visitResultForm(Query q) {
        }

        @Override
        public void visitSelectResultForm(Query query2) {
            this.newQuery.setQuerySelectType();
            this.newQuery.setDistinct(query2.isDistinct());
            this.newQuery.setReduced(query2.isReduced());
            this.copyProjection(query2);
        }

        @Override
        public void visitConstructResultForm(Query query2) {
            this.newQuery.setQueryConstructType();
            this.newQuery.setConstructTemplate(query2.getConstructTemplate());
        }

        @Override
        public void visitDescribeResultForm(Query query2) {
            this.newQuery.setQueryDescribeType();
            for (Node x : query2.getResultURIs()) {
                this.newQuery.addDescribeNode(x);
            }
            this.copyProjection(query2);
        }

        @Override
        public void visitAskResultForm(Query query2) {
            this.newQuery.setQueryAskType();
        }

        @Override
        public void visitJsonResultForm(Query query2) {
            this.newQuery.setQueryJsonType();
        }

        @Override
        public void visitDatasetDecl(Query query2) {
        }

        @Override
        public void visitQueryPattern(Query query2) {
            this.newQuery.setQueryPattern(query2.getQueryPattern());
        }

        @Override
        public void visitGroupBy(Query query2) {
            if (query2.hasGroupBy()) {
                VarExprList x = query2.getGroupBy();
                for (Var v : x.getVars()) {
                    Expr expr = x.getExpr(v);
                    if (expr == null) {
                        this.newQuery.addGroupBy(v);
                        continue;
                    }
                    this.newQuery.addGroupBy(v, expr);
                }
            }
        }

        @Override
        public void visitHaving(Query query2) {
            if (query2.hasHaving()) {
                for (Expr expr : query2.getHavingExprs()) {
                    this.newQuery.addHavingCondition(expr);
                }
            }
        }

        @Override
        public void visitOrderBy(Query query2) {
            if (query2.hasOrderBy()) {
                for (SortCondition sc : query2.getOrderBy()) {
                    this.newQuery.addOrderBy(sc);
                }
            }
        }

        @Override
        public void visitLimit(Query query2) {
            this.newQuery.setLimit(query2.getLimit());
        }

        @Override
        public void visitOffset(Query query2) {
            this.newQuery.setOffset(query2.getOffset());
        }

        @Override
        public void visitValues(Query query2) {
            if (query2.hasValues()) {
                this.newQuery.setValuesDataBlock(query2.getValuesVariables(), query2.getValuesData());
            }
        }

        @Override
        public void finishVisit(Query query2) {
        }

        public void copyProjection(Query query2) {
            VarExprList x = query2.getProject();
            for (Var v : x.getVars()) {
                Expr expr = x.getExpr(v);
                if (expr == null) {
                    this.newQuery.addResultVar(v);
                    continue;
                }
                this.newQuery.addResultVar(v, expr);
            }
        }
    }
}

