/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.xerces_regex.REUtil;
import org.apache.jena.ext.xerces_regex.RegexParseException;
import org.apache.jena.ext.xerces_regex.RegularExpression;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public abstract class RegexEngine {
    private static RegexImpl regexImpl = RegexEngine.chooseRegexImpl(ARQ.getContext());

    public abstract boolean match(String var1);

    private static RegexImpl chooseRegexImpl(Context context2) {
        Symbol v = ARQ.getContext().get(ARQ.regexImpl, ARQ.javaRegex);
        Symbol symbol = null;
        if (v instanceof Symbol) {
            Symbol sym;
            symbol = sym = v;
        }
        if (v instanceof String) {
            String str2 = (String)((Object)v);
            symbol = Symbol.create(str2);
        }
        if (ARQ.javaRegex.equals(symbol)) {
            return RegexImpl.Java;
        }
        if (ARQ.xercesRegex.equals(symbol)) {
            return RegexImpl.Xerces;
        }
        Log.warn(E_Regex.class, "Regex implementation not recognized : default to Java");
        return RegexImpl.Java;
    }

    public static void setRegexImpl(RegexImpl valRegexImpl) {
        Objects.requireNonNull(valRegexImpl);
        regexImpl = valRegexImpl;
    }

    public static Pattern makePattern(String label, String patternStr, String flags) {
        try {
            int mask = 0;
            if (flags != null) {
                mask = RegexEngine.makeMask(flags);
                if (flags.contains("q")) {
                    patternStr = Pattern.quote(patternStr);
                }
            }
            return Pattern.compile(patternStr, mask);
        }
        catch (PatternSyntaxException pEx) {
            throw new ExprEvalException(label + " pattern exception: " + pEx);
        }
    }

    public static int makeMask(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int newMask = 0;
        block7: for (int i = 0; i < modifiers.length(); ++i) {
            switch (modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 0x40;
                    newMask |= 2;
                    continue block7;
                }
                case 'm': {
                    newMask |= 8;
                    continue block7;
                }
                case 's': {
                    newMask |= 0x20;
                    continue block7;
                }
                case 'x': {
                    newMask |= 4;
                    continue block7;
                }
                case 'q': {
                    continue block7;
                }
                default: {
                    throw new ExprEvalException("Unsupported flag in regex modifiers: " + modifiers.charAt(i));
                }
            }
        }
        return newMask;
    }

    public static RegexEngine create(String pattern, String flags) {
        return switch (regexImpl) {
            case RegexImpl.Java -> new RegexJava(pattern, flags);
            case RegexImpl.Xerces -> new RegexXerces(pattern, flags);
            default -> new RegexJava(pattern, flags);
        };
    }

    public static enum RegexImpl {
        Java,
        Xerces;

    }

    public static class RegexJava
    extends RegexEngine {
        private final Pattern regexPattern;

        public RegexJava(String pattern, String flags) {
            this.regexPattern = RegexJava.makePattern("Regex", pattern, flags);
        }

        @Override
        public boolean match(String s) {
            Matcher m = this.regexPattern.matcher(s);
            return m.find();
        }
    }

    public static class RegexXerces
    extends RegexEngine {
        private final RegularExpression regexPattern;

        public RegexXerces(String pattern, String flags) {
            if (flags != null && flags.contains("q")) {
                flags = flags.replace("q", "");
                pattern = REUtil.quoteMeta(pattern);
            }
            this.regexPattern = this.makePattern(pattern, flags);
        }

        @Override
        public boolean match(String s) {
            return this.regexPattern.matches(s);
        }

        private RegularExpression makePattern(String patternStr, String flags) {
            try {
                return new RegularExpression(patternStr, flags);
            }
            catch (RegexParseException pEx) {
                throw new ExprEvalException("Regex: Pattern exception: " + pEx);
            }
        }
    }
}

