/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public interface QueryExecBuilder
extends QueryExecMod {
    public QueryExecBuilder query(Query var1);

    public QueryExecBuilder query(String var1);

    public QueryExecBuilder query(String var1, Syntax var2);

    public QueryExecBuilder parseCheck(boolean var1);

    public QueryExecBuilder set(Symbol var1, Object var2);

    public QueryExecBuilder set(Symbol var1, boolean var2);

    public QueryExecBuilder context(Context var1);

    public QueryExecBuilder substitution(Binding var1);

    public QueryExecBuilder substitution(Var var1, Node var2);

    default public QueryExecBuilder substitution(String var, Node value) {
        return this.substitution(Var.alloc(var), value);
    }

    @Override
    public QueryExecBuilder timeout(long var1, TimeUnit var3);

    @Override
    public QueryExec build();

    default public RowSet select() {
        return this.build().select();
    }

    default public Graph construct() {
        try (QueryExec qExec = this.build();){
            Graph graph = qExec.construct();
            return graph;
        }
    }

    default public Graph describe() {
        try (QueryExec qExec = this.build();){
            Graph graph = qExec.describe();
            return graph;
        }
    }

    default public boolean ask() {
        try (QueryExec qExec = this.build();){
            boolean bl = qExec.ask();
            return bl;
        }
    }
}

