/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Iterator;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException0;
import org.apache.jena.iri.Violation;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.SetupJenaIRI;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;

class CheckerJenaIRI {
    private static ErrorHandler nullErrorHandler = new ErrorHandler(){

        @Override
        public void warning(String message, long line, long col) {
        }

        @Override
        public void error(String message, long line, long col) {
        }

        @Override
        public void fatal(String message, long line, long col) {
        }
    };

    CheckerJenaIRI() {
    }

    static boolean checkIRI(String iriStr, ErrorHandler errorHandler, long line, long col) {
        IRI iri2 = SetupJenaIRI.iriCheckerFactory().create(iriStr);
        boolean b = CheckerJenaIRI.iriViolations(iri2, errorHandler, line, col);
        return b;
    }

    static boolean iriViolations(IRI iri2, ErrorHandler errorHandler, long line, long col) {
        return CheckerJenaIRI.iriViolations(iri2, errorHandler, false, true, line, col);
    }

    static boolean iriViolations(IRI iri2, ErrorHandler errorHandler, boolean allowRelativeIRIs, boolean includeIRIwarnings, long line, long col) {
        if (!allowRelativeIRIs && iri2.isRelative()) {
            CheckerJenaIRI.iriViolationMessage(iri2.toString(), true, "Relative IRI: " + iri2, line, col, errorHandler);
        }
        boolean isOK = true;
        if (iri2.hasViolation(includeIRIwarnings)) {
            Iterator<Violation> iter = iri2.violations(includeIRIwarnings);
            while (iter.hasNext()) {
                Violation v = iter.next();
                int code = v.getViolationCode();
                boolean isError = v.isError();
                if (code == 11 && v.getComponent() != 2) continue;
                isOK = false;
                String msg = v.getShortMessage();
                String iriStr = iri2.toString();
                CheckerJenaIRI.iriViolationMessage(iriStr, isError, msg, line, col, errorHandler);
            }
        }
        return isOK;
    }

    static void iriViolationMessage(String iriStr, boolean isError, String msg, long line, long col, ErrorHandler errorHandler) {
        try {
            if (!(SystemIRIx.getProvider() instanceof IRIProviderJenaIRI)) {
                msg = "<" + iriStr + "> : " + (String)msg;
            }
            if (isError) {
                CheckerJenaIRI.errorHandler(errorHandler).warning("Bad IRI: " + (String)msg, line, col);
            } else {
                CheckerJenaIRI.errorHandler(errorHandler).warning("Not advised IRI: " + (String)msg, line, col);
            }
        }
        catch (IRIException0 | IRIException runtimeException) {
            // empty catch block
        }
    }

    private static ErrorHandler errorHandler(ErrorHandler handler) {
        return handler != null ? handler : ErrorHandlerFactory.errorHandlerStd;
    }
}

