/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;

public class RDFChangesWriteUpdate
implements RDFChanges {
    private NodeFormatter formatter;
    private final AWriter out;
    private final PrefixMap pmap;
    private boolean doingHeader = true;
    private boolean adding = false;
    private boolean deleting = false;

    public RDFChangesWriteUpdate(AWriter out) {
        this.out = out;
        this.pmap = PrefixMapFactory.create();
        this.formatter = new NodeFormatterTTL(null, null){

            @Override
            public void formatBNode(AWriter w, Node n) {
                this.formatBNode(w, n.getBlankNodeLabel());
            }

            @Override
            public void formatBNode(AWriter w, String label) {
                w.print("<_:");
                String lab = NodeFmtLib.encodeBNodeLabel(label);
                w.print(lab);
                w.print(">");
            }
        };
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
    }

    @Override
    public void header(String field, Node value) {
        this.header();
        this.out.print("# ");
        this.out.print(field);
        this.out.print(" ");
        this.outputNode(this.out, value);
        this.out.println();
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.notHeader();
        this.out.print("INSERT DATA ");
        this.outputData(g, s, p, o);
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.notHeader();
        this.out.print("DELETE DATA ");
        this.outputData(g, s, p, o);
    }

    private void outputData(Node g, Node s, Node p, Node o) {
        boolean writeGraph;
        this.out.write("{ ");
        boolean bl = writeGraph = g != null;
        if (writeGraph) {
            this.out.write("GRAPH ");
            this.outputNode(this.out, g);
            this.out.write(" { ");
        }
        this.outputNode(this.out, s);
        this.out.write(" ");
        this.outputNode(this.out, p);
        this.out.write(" ");
        this.outputNode(this.out, o);
        this.out.write(" ");
        if (writeGraph) {
            this.out.print("} ");
        }
        this.out.println(" } ;");
    }

    private void notHeader() {
        if (this.doingHeader) {
            this.doingHeader = false;
        }
    }

    private void header() {
        if (!this.doingHeader) {
            this.doingHeader = true;
        }
    }

    private void outputNode(AWriter out, Node node) {
        this.formatter.format(out, node);
    }

    @Override
    public void addPrefix(Node gn, String prefix, String uriStr) {
        this.notHeader();
        this.out.print("# AddPrefix ");
        if (gn != null) {
            this.outputNode(this.out, gn);
            this.out.print(" ");
        }
        this.out.print(prefix);
        this.out.print(" <");
        this.out.print(uriStr);
        this.out.print(">");
        this.out.println();
        this.out.print("PREFIX ");
        this.out.print(prefix + ": ");
        this.out.print("<");
        this.out.print(uriStr);
        this.out.print(">");
        this.out.println();
        this.pmap.add(prefix, uriStr);
    }

    @Override
    public void deletePrefix(Node gn, String prefix) {
        this.notHeader();
        this.pmap.delete(prefix);
        this.out.print("# DelPrefix ");
        if (gn != null) {
            this.outputNode(this.out, gn);
            this.out.print(" ");
        }
        this.out.print(prefix);
        this.out.println();
    }

    @Override
    public void txnBegin() {
        this.notHeader();
        this.out.println("# Begin");
    }

    @Override
    public void txnCommit() {
        this.notHeader();
        this.out.println("# Commit");
    }

    @Override
    public void txnAbort() {
        this.notHeader();
        this.out.println("# Abort");
    }

    @Override
    public void segment() {
        this.notHeader();
        this.out.println("# Segment");
    }
}

