/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.ui;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.mgt.FusekiServerCtl;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.apache.jena.rdf.model.Model;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;

public class FMod_UI
implements FusekiModule {
    private static FusekiModule singleton = new FMod_UI();
    private static Logger LOG = Fuseki.configLog;
    private static ArgDecl argUIFiles = new ArgDecl(true, "ui");
    private static String resourceNameUI = "webapp";
    private static String directoryNameUI = "webapp";
    private String uiAppLocation = null;
    private static Pattern regex = Pattern.compile("([^/]*)!");

    public static FusekiModule create() {
        return new FMod_UI();
    }

    @Override
    public String name() {
        return "FMod UI";
    }

    @Override
    public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        fusekiCmd.add(argUIFiles);
    }

    @Override
    public void serverArgsPrepare(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        if (fusekiCmd.contains(argUIFiles)) {
            this.uiAppLocation = fusekiCmd.getValue(argUIFiles);
            IOX.checkReadableDirectory(this.uiAppLocation, CmdException::new);
        }
    }

    @Override
    public void prepare(FusekiServer.Builder builder, Set<String> datasetNames, Model configModel) {
        if (builder.staticFileBase() != null) {
            FmtLog.warn(LOG, "Static content location has already been set: %s", builder.staticFileBase());
            return;
        }
        FusekiServerCtl serverCtl = (FusekiServerCtl)builder.getServletAttribute("org.apache.jena.fuseki:ServerCtl");
        if (serverCtl == null) {
            LOG.warn("No server control");
            return;
        }
        if (this.uiAppLocation == null) {
            this.uiAppLocation = this.findFusekiApp(serverCtl);
            if (this.uiAppLocation == null) {
                LOG.warn("No static content location");
                return;
            }
        } else {
            FmtLog.info(LOG, "UI file area = %s", this.uiAppLocation);
        }
        builder.staticFileBase(this.uiAppLocation).addServlet("/$/validate/query", new QueryValidator()).addServlet("/$/validate/update", new UpdateValidator()).addServlet("/$/validate/iri", new IRIValidator()).addServlet("/$/validate/data", new DataValidator()).enableStats(true);
    }

    @Override
    public void serverReload(FusekiServer server) {
    }

    private String findFusekiApp(FusekiServerCtl serverCtl) {
        Path fusekiBase;
        String x;
        if (this.uiAppLocation != null) {
            return this.uiAppLocation;
        }
        if (serverCtl != null && (x = FMod_UI.fromPath(fusekiBase = serverCtl.getFusekiBase(), directoryNameUI)) != null) {
            LOG.info("Fuseki UI - path resource: " + x);
            return x;
        }
        String r = FMod_UI.fromClasspath(resourceNameUI);
        if (r != null) {
            String displayName = this.loggingName(r);
            FmtLog.info(LOG, "UI Base = %s", displayName);
            return r;
        }
        return null;
    }

    private static String fromClasspath(String resourceName) {
        ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();
        Resource resource = resourceFactory.newClassLoaderResource(resourceName);
        if (resource != null) {
            return resource.getURI().toString();
        }
        return null;
    }

    private static String fromPath(Path path, String resourceName) {
        Path path2;
        if (path != null && Files.exists(path2 = path.resolve(resourceName), new LinkOption[0])) {
            IOX.checkReadableDirectory(path2, FusekiConfigException::new);
            return path2.toAbsolutePath().toString();
        }
        return null;
    }

    private String loggingName(String r) {
        Matcher matcher = regex.matcher(r);
        if (!matcher.find()) {
            return r;
        }
        return matcher.group(1);
    }
}

