/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.fuseki.access.GraphFilter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.sys.SystemTDB;
import org.apache.jena.tdb2.sys.TDBInternal;

class GraphFilterTDB2
extends GraphFilter<NodeId> {
    private GraphFilterTDB2(Collection<NodeId> matches, boolean matchDefaultGraph) {
        super(matches, matchDefaultGraph);
    }

    @Override
    public Symbol getContextKey() {
        return SystemTDB.symTupleFilter;
    }

    public static GraphFilterTDB2 graphFilter(DatasetGraph dsg, Collection<Node> namedGraphs, boolean matchDefaultGraph) {
        if (!TDBInternal.isTDB2(dsg)) {
            throw new IllegalArgumentException("DatasetGraph is not TDB2-backed");
        }
        List x = Txn.calculateRead(dsg, () -> {
            NodeTable nt = TDBInternal.getDatasetGraphTDB(dsg).getQuadTable().getNodeTupleTable().getNodeTable();
            return namedGraphs.stream().map(n -> nt.getNodeIdForNode((Node)n)).filter(Objects::nonNull).toList();
        });
        return new GraphFilterTDB2(x, matchDefaultGraph);
    }
}

