/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import java.io.IOException;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.QueryCheckException;
import org.apache.jena.sparql.modify.request.UpdateWriter;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.FileUtils;

public class uparse
extends CmdARQ {
    protected static final ArgDecl fileArg = new ArgDecl(true, "file", "update");
    protected static final ArgDecl syntaxArg = new ArgDecl(true, "syntax", "syn");
    protected static final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    protected static final ArgDecl argDeclFixup = new ArgDecl(false, "fixup");
    List<String> requestFiles = null;
    protected Syntax updateSyntax = null;
    private boolean printUpdate = false;
    private boolean printNone = false;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    static boolean needDivider = false;

    public static void main(String ... argv) {
        new uparse(argv).mainRun();
    }

    protected uparse(String[] argv) {
        super(argv);
        super.add(fileArg, "--file=FILE", "Update commands to parse");
        super.add(syntaxArg, "--syntax=name", "Update syntax");
        super.add(argDeclPrint, "--print", "Print in various forms [update, none]");
        super.add(argDeclFixup, "--fixup", "Convert undeclared prefix names to URIs");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(fileArg);
        super.processModulesAndArgs();
        if (this.cmdStrictMode) {
            this.updateSyntax = Syntax.syntaxSPARQL_11;
        }
        if (this.contains(argDeclFixup)) {
            ARQ.set(ARQ.fixupUndefinedPrefixes, true);
        }
        if (super.contains(syntaxArg)) {
            String s = super.getValue(syntaxArg);
            Syntax syn = Syntax.lookup(s);
            if (syn == null) {
                super.cmdError("Unrecognized syntax: " + s + " ; Choices are: arq, sparql, sparql10, sparql11)");
            }
            this.updateSyntax = syn;
        }
        for (String arg : this.getValues(argDeclPrint)) {
            if (arg.equalsIgnoreCase("update")) {
                this.printUpdate = true;
                continue;
            }
            if (arg.equalsIgnoreCase("none")) {
                this.printNone = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: update, none");
        }
        if (!this.printUpdate && !this.printNone) {
            this.printUpdate = true;
        }
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --file=<request file> | <update string>";
    }

    @Override
    protected void exec() {
        Syntax syntax;
        for (String filename : this.requestFiles) {
            String x;
            syntax = this.updateSyntax;
            if (syntax == null) {
                syntax = Syntax.guessFileSyntax(filename);
            }
            if ((x = this.oneFile(filename)) == null) continue;
            this.execOne(x, syntax);
        }
        for (String x : this.positionals) {
            syntax = this.updateSyntax;
            if (this.matchesIndirect(x)) {
                if (syntax == null) {
                    syntax = Syntax.guessFileSyntax(x);
                }
                x = this.indirect(x);
            }
            if (syntax == null) {
                syntax = Syntax.defaultUpdateSyntax;
            }
            this.execOne(x, syntax);
        }
    }

    private String oneFile(String filename) {
        uparse.divider();
        try {
            return FileUtils.readWholeFileAsUTF8(filename);
        }
        catch (IOException ex) {
            System.err.println("No such file: " + filename);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOne(String updateString, Syntax syntax) {
        UpdateRequest req;
        try {
            req = UpdateFactory.create(updateString, syntax);
        }
        catch (QueryParseException ex) {
            System.err.print("Parse error: ");
            System.err.println(ex.getMessage());
            return;
        }
        if (this.printUpdate) {
            System.out.print(req);
        }
        if (this.printNone) {
            return;
        }
        try {
            LogCtl.disable("SPARQL");
            uparse.checkUpdate(req, syntax);
        }
        catch (UpdateCheckException ex) {
            System.err.println();
            System.err.println("**** Check failure: " + ex.getMessage());
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace(System.err);
            }
        }
        finally {
            LogCtl.setLevel("SPARQL", "INFO");
        }
    }

    public static void checkUpdate(UpdateRequest req, Syntax syntax) {
        IndentedLineBuffer w = new IndentedLineBuffer();
        UpdateWriter.output(req, w);
        String updateString2 = w.asString();
        try {
            String baseURI = null;
            if (!req.explicitlySetBaseURI()) {
                baseURI = req.getBaseURI();
            }
            UpdateRequest req2 = UpdateFactory.create(updateString2, syntax);
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.err.println(updateString2);
            throw new QueryCheckException("could not parse output update request", ex);
        }
    }

    private static void divider() {
        if (needDivider) {
            System.out.println(divider);
        }
        needDivider = true;
    }

    public static class UpdateCheckException
    extends QueryException {
        public UpdateCheckException() {
        }

        public UpdateCheckException(Throwable cause) {
            super(cause);
        }

        public UpdateCheckException(String msg) {
            super(msg);
        }

        public UpdateCheckException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

