/*
 * Decompiled with CFR 0.152.
 */
package arq;

import java.io.PrintStream;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.Violation;
import org.apache.jena.iri3986.provider.IRIProvider3986;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.IRIParseException;

public class iri {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static void main(String ... args) {
        boolean first = true;
        for (String iriStr : args) {
            IRIx irix;
            if (iriStr.startsWith("<") && iriStr.endsWith(">")) {
                iriStr = iriStr.substring(1, iriStr.length() - 1);
            }
            if (!first) {
                System.out.println();
            }
            first = false;
            String setting = Lib.getenv("jena.iriprovider", "JENA_IRIPROVIDER");
            IRIProvider provider = null;
            if (setting != null) {
                switch (setting) {
                    case "IRI3986": {
                        IRIProvider iRIProvider = new IRIProvider3986();
                        break;
                    }
                    case "IRI0": {
                        IRIProvider iRIProvider = new IRIProviderJenaIRI();
                        break;
                    }
                    default: {
                        System.err.println("Unknown IRI Provider: " + setting);
                        System.exit(1);
                        IRIProvider iRIProvider = provider = null;
                    }
                }
            }
            if (provider == null) {
                provider = SystemIRIx.getProvider();
            }
            try {
                irix = provider.create(iriStr);
            }
            catch (IRIException ex) {
                System.err.println(ex.getMessage());
                continue;
            }
            if (irix instanceof IRIProvider3986.IRIx3986) {
                IRIProvider3986.IRIx3986 iri3986 = (IRIProvider3986.IRIx3986)irix;
                iri.print(iri3986, iriStr);
                continue;
            }
            if (irix instanceof IRIProviderJenaIRI.IRIxJena) {
                IRIProviderJenaIRI.IRIxJena iriJena = (IRIProviderJenaIRI.IRIxJena)irix;
                iri.print(iriJena, iriStr);
                continue;
            }
            iri.print(irix, iriStr);
        }
    }

    private static void print(IRIProvider3986.IRIx3986 irix, String iriStr) {
        try {
            IRI3986 iri2 = irix.getImpl();
            IRI3986 iri1 = iri2.normalize();
            out.printf("Input: <%s>\n", iriStr);
            out.printf("    Parsed:       %s\n", iri2.rebuild());
            out.printf("    Absolute:     %s\n", iri2.isAbsolute());
            out.printf("    Relative:     %s\n", iri2.isRelative());
            out.printf("    Hierarchical: %s\n", iri2.isHierarchical());
            out.printf("    Rootless:     %s\n", iri2.isRootless());
            if (!iri2.equals(iri1)) {
                out.printf("    Normalized:   %s\n", iri1);
            }
            out.printf("\n", new Object[0]);
            out.printf("%s|%s|  ", "Scheme", iri2.scheme());
            out.printf("%s|%s|  ", "Authority", iri2.authority());
            out.printf("%s|%s|  ", "Host", iri2.host());
            if (iri2.hasPort()) {
                out.printf("%s|%s|  ", "Port", iri2.port());
            }
            out.printf("%s|%s|  ", "Path", iri2.path());
            out.printf("%s|%s|  ", "Query", iri2.query());
            out.printf("%s|%s|", "Fragment", iri2.fragment());
            out.println();
            if (iri2.hasViolations()) {
                out.println();
                out.println("Scheme specific warnings:");
                iri2.forEachViolation(v -> {
                    out.print("   ");
                    err.printf("%s\n", v.message());
                });
            }
        }
        catch (IRIParseException ex) {
            System.err.printf("Error: %s\n", ex.getMessage());
        }
    }

    private static void print(IRIProviderJenaIRI.IRIxJena jenaIRI, String iriStr) {
        IRI iri2 = jenaIRI.getImpl();
        System.out.println(iriStr + " ==> " + iri2);
        if (jenaIRI.isRelative()) {
            System.out.println("Relative: " + iri2.isRelative());
        }
        Iterator<Violation> vIter = iri2.violations(true);
        while (vIter.hasNext()) {
            System.out.println(vIter.next().getShortMessage());
        }
    }

    private static void print(IRIx irix, String iriStr) {
        try {
            IRIx iri1 = irix.normalize();
            out.printf("Input: <%s>\n", iriStr);
            out.printf("    Absolute:     %s\n", irix.isAbsolute());
            out.printf("    Relative:     %s\n", irix.isRelative());
            if (!irix.equals(iri1)) {
                out.printf("    Normalized:   %s\n", iri1);
            }
            out.printf("\n", new Object[0]);
            out.printf("%s|%s|  ", "Scheme", irix.scheme());
            out.println();
            if (irix.hasViolations()) {
                out.println();
                out.println("Scheme specific warnings:");
                irix.handleViolations((error, msg) -> {
                    String type = error != false ? "Error:" : "Warn:";
                    out.print("   ");
                    err.printf("%-6s\n", type, msg);
                });
            }
        }
        catch (IRIParseException ex) {
            System.err.printf("Error: %s\n", ex.getMessage());
        }
    }
}

