/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jdk;

import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.NonNull;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.jdk.HttpClientContext;
import io.micrometer.core.instrument.binder.jdk.HttpClientObservationConvention;
import io.micrometer.core.instrument.binder.jdk.HttpClientObservationDocumentation;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Function;

@Deprecated
public class DefaultHttpClientObservationConvention
implements HttpClientObservationConvention {
    public static final DefaultHttpClientObservationConvention INSTANCE = new DefaultHttpClientObservationConvention();

    @Override
    public KeyValues getLowCardinalityKeyValues(HttpClientContext context) {
        if (context.getCarrier() == null) {
            return KeyValues.empty();
        }
        HttpRequest httpRequest = ((HttpRequest.Builder)context.getCarrier()).build();
        return KeyValues.of(HttpClientObservationDocumentation.LowCardinalityKeys.METHOD.withValue(httpRequest.method()), HttpClientObservationDocumentation.LowCardinalityKeys.URI.withValue(this.getUriTag(httpRequest, (HttpResponse)context.getResponse(), context.getUriMapper())), HttpClientObservationDocumentation.LowCardinalityKeys.STATUS.withValue(this.getStatus((HttpResponse)context.getResponse())), HttpClientObservationDocumentation.LowCardinalityKeys.OUTCOME.withValue(this.getOutcome((HttpResponse)context.getResponse())));
    }

    String getUriTag(HttpRequest request, @Nullable HttpResponse<?> httpResponse, Function<HttpRequest, String> uriMapper) {
        return httpResponse != null && (httpResponse.statusCode() == 404 || httpResponse.statusCode() == 301) ? "NOT_FOUND" : uriMapper.apply(request);
    }

    String getStatus(@Nullable HttpResponse<?> response) {
        if (response == null) {
            return "UNKNOWN";
        }
        return String.valueOf(response.statusCode());
    }

    String getOutcome(@Nullable HttpResponse<?> response) {
        if (response == null) {
            return Outcome.UNKNOWN.name();
        }
        return Outcome.forStatus(response.statusCode()).name();
    }

    @Override
    @NonNull
    public String getName() {
        return "http.client.requests";
    }

    @Override
    @Nullable
    public String getContextualName(HttpClientContext context) {
        if (context.getCarrier() == null) {
            return null;
        }
        return "HTTP " + ((HttpRequest.Builder)context.getCarrier()).build().method();
    }
}

