/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.buffering;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Match;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.system.buffering.BufferingPrefixMap;
import org.apache.jena.system.buffering.DatasetGraphBuffering;

public class BufferingDatasetGraph
extends DatasetGraphTriplesQuads
implements DatasetGraphBuffering {
    private DatasetGraph baseDSG;
    private AccessState accessState = AccessState.NONE;
    private int writeTxnCount = 0;
    private final int writeTxnLimit;
    private Set<Triple> addedTriples = new HashSet<Triple>();
    private Set<Triple> deletedTriples = new HashSet<Triple>();
    private Set<Quad> addedQuads = new HashSet<Quad>();
    private Set<Quad> deletedQuads = new HashSet<Quad>();
    private BufferingPrefixMap prefixes;
    private static final boolean UNIQUE = true;
    private final Transactional txn = TransactionalLock.createMRSW();

    protected DatasetGraph get() {
        return this.baseDSG;
    }

    protected DatasetGraph getT() {
        return this.baseDSG;
    }

    public Set<Triple> getAddedTriples() {
        return this.addedTriples;
    }

    public Set<Triple> getDeletedTriples() {
        return this.deletedTriples;
    }

    public Set<Quad> getAddedQuads() {
        return this.addedQuads;
    }

    public Set<Quad> getDeletedQuads() {
        return this.deletedQuads;
    }

    public BufferingDatasetGraph(DatasetGraph dsg) {
        this(dsg, 1);
    }

    public BufferingDatasetGraph(DatasetGraph dsg, int txnBuffering) {
        this.baseDSG = dsg;
        this.prefixes = new BufferingPrefixMap(dsg.prefixes());
        this.writeTxnLimit = txnBuffering;
    }

    public DatasetGraph base() {
        return this.baseDSG;
    }

    private void readOperation() {
        switch (this.accessState) {
            case NONE: {
                if (this.txn().isInTransaction()) {
                    switch (this.txn().transactionMode()) {
                        case READ: {
                            this.accessState = AccessState.READ;
                            break;
                        }
                        case WRITE: {
                            this.accessState = AccessState.WRITE;
                        }
                    }
                    return;
                }
                this.base().begin(TxnType.READ_COMMITTED_PROMOTE);
                this.accessState = AccessState.READ;
                break;
            }
        }
    }

    private void updateOperation() {
        switch (this.accessState) {
            case NONE: {
                if (this.txn().isInTransaction()) {
                    this.accessState = AccessState.WRITE;
                    return;
                }
                this.base().begin(TxnType.WRITE);
                this.accessState = AccessState.WRITE;
                break;
            }
            case READ: {
                boolean b = this.base().promote();
                if (!b) {
                    throw new JenaTransactionException("Failed to promote transaction");
                }
                this.accessState = AccessState.WRITE;
                break;
            }
        }
    }

    public AccessState accessState() {
        return this.accessState;
    }

    @Override
    public void flush() {
        switch (this.accessState) {
            case NONE: {
                return;
            }
            case READ: {
                this.getT().end();
                break;
            }
            case WRITE: {
                this.flushToDB();
            }
        }
        this.accessState = AccessState.NONE;
    }

    public void flushToDB() {
        this.base().executeWrite(() -> {
            Graph dftGraph = this.base().getDefaultGraph();
            this.addedTriples.forEach(dftGraph::add);
            this.deletedTriples.forEach(dftGraph::delete);
            this.addedQuads.forEach(this.baseDSG::add);
            this.deletedQuads.forEach(this.baseDSG::delete);
            this.addedTriples.clear();
            this.deletedTriples.clear();
            this.addedQuads.clear();
            this.deletedQuads.clear();
            this.prefixes.flush();
            this.writeTxnCount = 0;
        });
    }

    public String state() {
        StringBuilder sb = new StringBuilder();
        sb.append("Triples").append("\n");
        sb.append("  Added:   " + this.addedTriples).append("\n");
        sb.append("  Deleted: " + this.deletedTriples).append("\n");
        sb.append("Quads").append("\n");
        sb.append("  Added:   " + this.addedQuads).append("\n");
        sb.append("  Deleted: " + this.addedQuads).append("\n");
        String x = this.prefixes.state();
        sb.append(x);
        return sb.toString();
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.updateOperation();
        Triple triple = Triple.create(s, p, o);
        DatasetGraph base = this.get();
        this.deletedTriples.remove(triple);
        if (base.getDefaultGraph().contains(triple)) {
            return;
        }
        this.addedTriples.add(triple);
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.updateOperation();
        Quad quad = Quad.create(g, s, p, o);
        DatasetGraph base = this.get();
        this.deletedQuads.remove(quad);
        if (base.contains(quad)) {
            return;
        }
        this.addedQuads.add(quad);
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.updateOperation();
        Triple triple = Triple.create(s, p, o);
        DatasetGraph base = this.get();
        this.addedTriples.remove(triple);
        if (!base.getDefaultGraph().contains(triple)) {
            return;
        }
        this.deletedTriples.add(triple);
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.updateOperation();
        Quad quad = Quad.create(g, s, p, o);
        DatasetGraph base = this.get();
        this.addedQuads.remove(quad);
        if (!base.contains(quad)) {
            return;
        }
        this.deletedQuads.add(quad);
    }

    @Override
    public boolean contains(Quad quad) {
        this.readOperation();
        return this.contains$(quad, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        this.readOperation();
        return this.contains$(null, g, s, p, o);
    }

    private boolean contains$(Quad quad, Node g, Node s, Node p, Node o) {
        if (Quad.isDefaultGraph(g)) {
            return this.containedInDftGraph(g, s, p, o);
        }
        if (!BufferingDatasetGraph.isWildcard(g)) {
            return this.containedInNG(quad, g, s, p, o);
        }
        return this.containedInAny(quad, g, s, p, o);
    }

    private boolean containedInDftGraph(Node g, Node s, Node p, Node o) {
        Triple t = Triple.create(s, p, o);
        if (this.addedTriples.contains(t)) {
            return true;
        }
        if (this.deletedTriples.contains(t)) {
            return false;
        }
        return this.get().contains(g, s, p, o);
    }

    private boolean containedInNG(Quad quad, Node g, Node s, Node p, Node o) {
        if (quad == null) {
            quad = Quad.create(g, s, p, o);
        }
        if (this.addedQuads.contains(quad)) {
            return true;
        }
        if (this.deletedQuads.contains(quad)) {
            return false;
        }
        return this.get().contains(g, s, p, o);
    }

    private boolean containedInAny(Quad quad, Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.findAny(s, p, o);
        return iter.hasNext();
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        this.readOperation();
        DatasetGraph base = this.get();
        Iterator<Quad> extra = this.findInAddedTriples(s, p, o);
        Iter<Quad> iter = Iter.iter(base.find(Quad.defaultGraphIRI, s, p, o)).filter(q -> !this.deletedQuads.contains(q)).append(extra);
        return iter;
    }

    private Iterator<Quad> findInAddedTriples(Node s, Node p, Node o) {
        return Iter.iter(this.addedTriples.iterator()).filter(t -> Match.match(t, s, p, o)).map(t -> Quad.create(Quad.defaultGraphIRI, t));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        this.readOperation();
        return this.findQuads(g, s, p, o);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        this.readOperation();
        return this.findQuads(Node.ANY, s, p, o);
    }

    private Iterator<Quad> findQuads(Node g, Node s, Node p, Node o) {
        DatasetGraph base = this.get();
        Iterator<Quad> extra = this.findInAddedQuads(g, s, p, o);
        Iter<Quad> iter = Iter.iter(base.find(g, s, p, o)).filter(q -> !this.deletedQuads.contains(q)).append(extra);
        return iter;
    }

    private Iterator<Quad> findInAddedQuads(Node g, Node s, Node p, Node o) {
        return Iter.iter(this.addedQuads.iterator()).filter(t -> Match.match(t, g, s, p, o));
    }

    @Override
    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph(this);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph(this.baseDSG, graphNode);
    }

    @Override
    public Graph getUnionGraph() {
        return GraphView.createUnionGraph(this.baseDSG);
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        Iterator<Node> iter1 = this.base().listGraphNodes();
        Set deleted = this.deletedQuads.stream().map(q -> q.getGraph()).distinct().collect(Collectors.toSet());
        return Iter.iter(this.addedQuads).map(q -> q.getGraph()).distinct();
    }

    @Override
    public PrefixMap prefixes() {
        return this.prefixes;
    }

    protected final Transactional txn() {
        return this.getT();
    }

    @Override
    public void begin() {
        this.txn().begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn().begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn().begin(mode);
    }

    @Override
    public void commit() {
        if (this.txn().isInTransaction() && this.txn().transactionMode() == ReadWrite.WRITE) {
            this.commitW();
        }
        this.txn().commit();
    }

    private void commitW() {
        ++this.writeTxnCount;
        if (this.writeTxnCount >= this.writeTxnLimit) {
            this.flush();
        }
    }

    @Override
    public boolean promote(Transactional.Promote mode) {
        return this.txn().promote(mode);
    }

    @Override
    public void abort() {
        this.txn().abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn().isInTransaction();
    }

    @Override
    public void end() {
        this.txn().end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn().transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn().transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return this.get().supportsTransactions();
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.get().supportsTransactionAbort();
    }

    private static enum AccessState {
        NONE,
        READ,
        WRITE;

    }
}

