/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.net.http.HttpClient;
import java.util.Map;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpRDF;
import org.apache.jena.http.Push;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.exec.http.StoreProtocol;

public class DSP
extends StoreProtocol<DSP> {
    private static DatasetGraph emptyDSG = DatasetGraphZero.create();

    public static DSP service(String service) {
        return (DSP)new DSP().endpoint(service);
    }

    public static DSP request() {
        return new DSP();
    }

    protected DSP() {
    }

    @Override
    protected DSP thisBuilder() {
        return this;
    }

    public DatasetGraph GET() {
        this.ensureAcceptHeader("text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.5");
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, this.serviceEndpoint);
        HttpRDF.httpGetToStream(hc, this.serviceEndpoint, this.httpHeaders, StreamRDFLib.dataset(dsg));
        return dsg;
    }

    public void POST(String file) {
        if (!FileOps.exists(file)) {
            throw new IllegalArgumentException("No such file: " + file);
        }
        String fileExtContentType = this.contentTypeFromFilename(file);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, this.serviceEndpoint);
        DSP.uploadQuads(hc, this.serviceEndpoint, file, fileExtContentType, this.httpHeaders, Push.POST);
    }

    public void POST(DatasetGraph dataset) {
        RDFFormat requestFmt = this.rdfFormat(HttpEnv.defaultQuadsFormat);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, this.serviceEndpoint);
        HttpRDF.httpPostDataset(hc, this.serviceEndpoint, dataset, requestFmt, this.httpHeaders);
    }

    public void PUT(String file) {
        if (!FileOps.exists(file)) {
            throw new IllegalArgumentException("No such file: " + file);
        }
        String fileExtContentType = this.contentTypeFromFilename(file);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, this.serviceEndpoint);
        DSP.uploadQuads(hc, this.serviceEndpoint, file, fileExtContentType, this.httpHeaders, Push.PUT);
    }

    public void PUT(DatasetGraph dataset) {
        RDFFormat requestFmt = this.rdfFormat(HttpEnv.defaultQuadsFormat);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, this.serviceEndpoint);
        HttpRDF.httpPutDataset(hc, this.serviceEndpoint, dataset, requestFmt, this.httpHeaders);
    }

    public void clear() {
        this.PUT(emptyDSG);
    }

    private static void uploadQuads(HttpClient httpClient, String endpoint, String file, String fileExtContentType, Map<String, String> headers, Push mode) {
        Lang lang = RDFLanguages.contentTypeToLang(fileExtContentType);
        if (!RDFLanguages.isQuads(lang) && !RDFLanguages.isTriples(lang)) {
            throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
        }
        DSP.pushFile(httpClient, endpoint, file, fileExtContentType, headers, mode);
    }
}

