/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.ref;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.JoinType;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterAssign;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterDistinctMem;
import org.apache.jena.sparql.engine.iterator.QueryIterGroup;
import org.apache.jena.sparql.engine.iterator.QueryIterPath;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterProject;
import org.apache.jena.sparql.engine.iterator.QueryIterReduced;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.engine.iterator.QueryIterSort;
import org.apache.jena.sparql.engine.iterator.QueryIterUnfold;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.ref.Evaluator;
import org.apache.jena.sparql.engine.ref.RefEval;
import org.apache.jena.sparql.engine.ref.TableJoin;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.procedure.ProcEval;
import org.apache.jena.sparql.procedure.Procedure;

public class EvaluatorSimple
implements Evaluator {
    private ExecutionContext execCxt;
    public static boolean debug = false;

    public EvaluatorSimple(ExecutionContext context2) {
        this.execCxt = context2;
    }

    @Override
    public ExecutionContext getExecContext() {
        return this.execCxt;
    }

    @Override
    public Table basicPattern(BasicPattern pattern) {
        QueryIterator qIter = QC.executeDirect(pattern, QueryIterRoot.create(this.execCxt), this.execCxt);
        return TableFactory.create(qIter);
    }

    @Override
    public Table pathPattern(TriplePath triplePath) {
        QueryIterPath qIter = new QueryIterPath(triplePath, QueryIterRoot.create(this.execCxt), this.execCxt);
        return TableFactory.create(qIter);
    }

    @Override
    public Table procedure(Table table, Node procId, ExprList args) {
        Procedure proc = ProcEval.build(procId, args, this.execCxt);
        QueryIterator qIter = ProcEval.eval(table.iterator(this.execCxt), proc, this.execCxt);
        return TableFactory.create(qIter);
    }

    @Override
    public Table propertyFunction(Table table, Node procId, PropFuncArg subjArgs, PropFuncArg objArgs) {
        Procedure proc = ProcEval.build(procId, subjArgs, objArgs, this.execCxt);
        QueryIterator qIter = ProcEval.eval(table.iterator(this.execCxt), proc, this.execCxt);
        return TableFactory.create(qIter);
    }

    @Override
    public Table join(Table tableLeft, Table tableRight) {
        if (debug) {
            System.out.println("Join");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        return this.joinWorker(tableLeft, tableRight, false, null);
    }

    @Override
    public Table leftJoin(Table tableLeft, Table tableRight, ExprList exprs) {
        if (debug) {
            System.out.println("Left Join");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
            if (exprs != null) {
                System.out.println(exprs);
            }
        }
        return this.joinWorker(tableLeft, tableRight, true, exprs);
    }

    @Override
    public Table diff(Table tableLeft, Table tableRight) {
        if (debug) {
            System.out.println("Diff");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        return this.diffWorker(tableLeft, tableRight);
    }

    @Override
    public Table minus(Table tableLeft, Table tableRight) {
        if (debug) {
            System.out.println("Minus");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        return this.minusWorker(tableLeft, tableRight);
    }

    @Override
    public Table filter(ExprList expressions, Table table) {
        if (debug) {
            System.out.println("Restriction");
            System.out.println(expressions);
            EvaluatorSimple.dump(table);
        }
        QueryIterator iter = table.iterator(this.execCxt);
        ArrayList<Binding> output = new ArrayList<Binding>();
        while (iter.hasNext()) {
            Binding b = iter.nextBinding();
            if (!expressions.isSatisfied(b, this.execCxt)) continue;
            output.add(b);
        }
        return new TableN(QueryIterPlainWrapper.create(output.iterator(), this.execCxt));
    }

    @Override
    public Table union(Table tableLeft, Table tableRight) {
        if (debug) {
            System.out.println("Union");
            EvaluatorSimple.dump(tableLeft);
            EvaluatorSimple.dump(tableRight);
        }
        QueryIterConcat output = new QueryIterConcat(this.execCxt);
        output.add(tableLeft.iterator(this.execCxt));
        output.add(tableRight.iterator(this.execCxt));
        return new TableN(output);
    }

    @Override
    public Table condition(Table left, Table right) {
        if (left.isEmpty()) {
            left.close();
            return right;
        }
        right.close();
        return left;
    }

    @Override
    public Table lateral(Table left, Op right) {
        if (left.isEmpty()) {
            left.close();
            return TableFactory.createEmpty();
        }
        TableN result = new TableN();
        left.iterator(this.getExecContext()).forEachRemaining(binding -> {
            Op op = Substitute.substitute(right, binding);
            Table t = RefEval.eval(this, op);
            t.iterator(this.getExecContext()).forEachRemaining(b -> {
                Binding b2 = BindingBuilder.create(binding).addAll((Binding)b).build();
                result.addBinding(b2);
            });
        });
        left.close();
        return result;
    }

    @Override
    public Table list(Table table) {
        return table;
    }

    @Override
    public Table order(Table table, List<SortCondition> conditions) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterSort(qIter, conditions, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table groupBy(Table table, VarExprList groupVars, List<ExprAggregator> aggregators) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterGroup(qIter, groupVars, aggregators, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table project(Table table, List<Var> projectVars) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = QueryIterProject.create(qIter, projectVars, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table reduced(Table table) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterReduced(qIter, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table distinct(Table table) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterDistinctMem(qIter, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table slice(Table table, long start, long length) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterSlice(qIter, start, length, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table assign(Table table, VarExprList exprs) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterAssign(qIter, exprs, this.getExecContext(), false);
        return new TableN(qIter);
    }

    @Override
    public Table extend(Table table, VarExprList exprs) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterAssign(qIter, exprs, this.getExecContext(), true);
        return new TableN(qIter);
    }

    @Override
    public Table unfold(Table table, Expr expr, Var var1, Var var2) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterUnfold(qIter, expr, var1, var2, this.getExecContext());
        return new TableN(qIter);
    }

    @Override
    public Table unit() {
        return TableFactory.createUnit();
    }

    private Table joinWorker(Table tableLeft, Table tableRight, boolean leftJoin, ExprList conditions) {
        QueryIterator left = tableLeft.iterator(this.execCxt);
        JoinType joinType = leftJoin ? JoinType.LEFT : JoinType.INNER;
        QueryIterator qIter = TableJoin.joinWorker(left, tableRight, joinType, conditions, this.execCxt);
        tableLeft.close();
        tableRight.close();
        return new TableN(qIter);
    }

    private Table diffWorker(Table tableLeft, Table tableRight) {
        QueryIterator left = tableLeft.iterator(this.execCxt);
        TableN r = new TableN();
        while (left.hasNext()) {
            Binding b = left.nextBinding();
            if (!tableRight.contains(b)) continue;
            r.addBinding(b);
        }
        tableLeft.close();
        tableRight.close();
        return r;
    }

    private Table minusWorker(Table tableLeft, Table tableRight) {
        TableN results = new TableN();
        QueryIterator iterLeft = tableLeft.iterator(this.execCxt);
        while (iterLeft.hasNext()) {
            Binding bindingLeft = iterLeft.nextBinding();
            boolean includeThisRow = true;
            QueryIterator iterRight = tableRight.iterator(this.execCxt);
            while (iterRight.hasNext()) {
                Binding bindingRight = iterRight.nextBinding();
                if (Algebra.disjoint(bindingLeft, bindingRight) || !Algebra.compatible(bindingLeft, bindingRight)) continue;
                includeThisRow = false;
                break;
            }
            iterRight.close();
            if (!includeThisRow) continue;
            results.addBinding(bindingLeft);
        }
        iterLeft.close();
        return results;
    }

    private static void dump(Table table) {
        System.out.println("Table: " + Lib.className(table));
        QueryIterator qIter = table.iterator(null);
        ResultSet rs = ResultSetStream.create(table.getVarNames(), null, table.iterator(null));
        ResultSetFormatter.out(rs);
    }
}

