/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Printable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.join.BitSetMapper;
import org.apache.jena.sparql.engine.join.JoinIndex;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiHashProbeTable
implements Printable {
    private static final Logger logger = LoggerFactory.getLogger(MultiHashProbeTable.class);
    private static boolean isDebugOutputEnabled = false;
    private final JoinKey maxJoinKey;
    private final JoinIndex initialIndex;
    private final Map<BitSet, JoinIndex> indexes = new HashMap<BitSet, JoinIndex>();
    private final Set<Var> seenVarSet = new LinkedHashSet<Var>();
    private boolean isFinalized = false;
    private JoinKey seenVarsJoinKey;

    public MultiHashProbeTable(JoinKey maxJoinKey, JoinKey initialJoinKey) {
        this.maxJoinKey = maxJoinKey;
        if (maxJoinKey != null && initialJoinKey != null && !maxJoinKey.containsAll(initialJoinKey)) {
            throw new IllegalArgumentException("Variables of the initial join key must be a sub set of the root one.");
        }
        if (initialJoinKey == null) {
            initialJoinKey = JoinKey.empty();
        }
        this.seenVarSet.addAll(initialJoinKey);
        int nbits = initialJoinKey.size();
        BitSet initialJoinKeyBitset = new BitSet(nbits);
        initialJoinKeyBitset.flip(0, nbits);
        if (logger.isTraceEnabled()) {
            logger.trace("Initial join index configured with variables " + initialJoinKey + " and bits " + initialJoinKeyBitset);
        }
        this.initialIndex = new JoinIndex(initialJoinKey, initialJoinKeyBitset, initialJoinKey);
    }

    Map<JoinKey, JoinIndex> getIndexesByJoinKeys() {
        return this.indexes.entrySet().stream().collect(Collectors.toMap(e2 -> this.toJoinKey((BitSet)e2.getKey()), Map.Entry::getValue));
    }

    Map<BitSet, JoinIndex> getIndexes() {
        return this.indexes;
    }

    JoinKey toJoinKey(BitSet bitSet) {
        JoinKey vars = JoinKey.create(BitSetMapper.toList(this.seenVarsJoinKey, bitSet));
        return vars;
    }

    public void put(Binding row) {
        if (this.isFinalized) {
            throw new IllegalStateException("Cannot add more bindings after a lookup was performed.");
        }
        this.updateSeenVars(row);
        this.initialIndex.put(row);
    }

    private void updateSeenVars(Binding row) {
        if (this.maxJoinKey == null) {
            row.vars().forEachRemaining(this.seenVarSet::add);
        } else if (this.maxJoinKey.length() < row.size()) {
            this.maxJoinKey.forEach(v -> {
                if (row.contains((Var)v)) {
                    this.seenVarSet.add((Var)v);
                }
            });
        } else {
            row.vars().forEachRemaining(v -> {
                if (this.maxJoinKey.contains(v)) {
                    this.seenVarSet.add((Var)v);
                }
            });
        }
    }

    public Iterator<Binding> getCandidates(Binding row) {
        Iterator<Binding> it;
        if (!this.isFinalized) {
            this.doFinalize();
        }
        BitSet joinKeyBitSet = BitSetMapper.toBitSet(this.seenVarsJoinKey, row);
        if (isDebugOutputEnabled && logger.isDebugEnabled()) {
            logger.debug("Lookup with " + BitSetMapper.toList(this.seenVarsJoinKey, joinKeyBitSet));
        }
        if (joinKeyBitSet.isEmpty()) {
            it = this.initialIndex.iterator();
        } else {
            JoinIndex primaryIndex = this.getOrCreateJoinIndex(joinKeyBitSet);
            it = primaryIndex.getCandidates(row);
        }
        return it;
    }

    void doFinalize() {
        this.seenVarsJoinKey = JoinKey.create(this.seenVarSet);
        this.indexes.put(this.initialIndex.getMainJoinKeyBitSet(), this.initialIndex);
        this.isFinalized = true;
    }

    private JoinIndex getOrCreateJoinIndex(BitSet joinKeyBitSet) {
        JoinIndex result = this.indexes.computeIfAbsent(joinKeyBitSet, this::createJoinIndex);
        return result;
    }

    private JoinIndex createJoinIndex(BitSet joinKeyBitSet) {
        JoinKey joinKey = JoinKey.create(BitSetMapper.toList(this.seenVarsJoinKey, joinKeyBitSet));
        JoinIndex result = new JoinIndex(this.seenVarsJoinKey, joinKeyBitSet, joinKey);
        if (logger.isTraceEnabled()) {
            logger.trace("Creating join index with variables " + joinKey + " and bits " + joinKeyBitSet);
        }
        for (Binding row : this.initialIndex) {
            result.put(row);
        }
        return result;
    }

    public String toString() {
        return Printable.toString(this);
    }

    @Override
    public void output(IndentedWriter out) {
        out.ensureStartOfLine();
        out.println("MultiHashProbeTable");
        out.incIndent();
        this.getIndexesByJoinKeys().forEach((joinKey, index) -> index.output(out));
        out.decIndent();
    }

    public Iterator<Binding> values() {
        return this.initialIndex.iterator();
    }

    public void clear() {
        this.indexes.clear();
        this.initialIndex.clear();
        this.seenVarSet.clear();
        this.seenVarsJoinKey = null;
        this.isFinalized = false;
    }
}

