/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class ImmutableUniqueList<T>
extends AbstractList<T> {
    static final int INDEX_THRESHOLD = 5;
    protected final T[] elementData;
    protected final int indexThreshold;
    private transient Map<T, Integer> elementToIndex;

    public static <T> Builder<T> newUniqueListBuilder(Class<T> itemClass) {
        return new Builder<T>(itemClass);
    }

    public static <T> ImmutableUniqueList<T> createUniqueList(Class<T> itemClass, Collection<T> items) {
        return ImmutableUniqueList.newUniqueListBuilder(itemClass).addAll(items).build();
    }

    public static <T> ImmutableUniqueList<T> createUniqueList(Class<T> itemClass, T[] items) {
        return ImmutableUniqueList.newUniqueListBuilder(itemClass).addAll(items).build();
    }

    protected ImmutableUniqueList(T[] elementData) {
        this(5, elementData);
    }

    protected ImmutableUniqueList(int indexThreshold, T[] elementData) {
        this.indexThreshold = indexThreshold;
        this.elementData = elementData;
    }

    @Override
    public int size() {
        return this.elementData.length;
    }

    public int length() {
        return this.size();
    }

    @Override
    public T get(int i) {
        return this.elementData[i];
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int indexOf(Object o) {
        int result;
        if (this.elementData.length < this.indexThreshold) {
            result = ArrayUtils.indexOf(this.elementData, o);
        } else if (this.elementToIndex != null) {
            result = this.elementToIndex.getOrDefault(o, -1);
        } else {
            HashMap<T, Integer> map = new HashMap<T, Integer>();
            for (int i = 0; i < this.elementData.length; ++i) {
                T key = this.elementData[i];
                map.put(key, i);
            }
            result = map.getOrDefault(o, -1);
            this.elementToIndex = map;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    public static final class Builder<T> {
        private Class<T> itemClass;
        private Collection<T> items;

        Builder(Class<T> itemClass) {
            this.itemClass = itemClass;
        }

        private void alloc(int n) {
            if (this.items == null) {
                this.items = n < 5 ? new ArrayList(5) : new LinkedHashSet();
            } else if (!(this.items instanceof Set) && this.items.size() + n >= 5) {
                LinkedHashSet<T> tmp = new LinkedHashSet<T>(this.items);
                this.items = tmp;
            }
        }

        public Builder<T> add(T item) {
            if (!(this.items instanceof Set)) {
                if (this.items == null || !this.items.contains(item)) {
                    this.alloc(1);
                    this.items.add(item);
                }
            } else {
                this.items.add(item);
            }
            return this;
        }

        public Builder<T> addAll(Collection<T> items) {
            this.alloc(items.size());
            for (T item : items) {
                this.add(item);
            }
            return this;
        }

        public Builder<T> addAll(T[] arr) {
            this.alloc(arr.length);
            for (T item : arr) {
                this.add(item);
            }
            return this;
        }

        public Builder<T> remove(Object o) {
            if (this.items != null) {
                this.items.remove(o);
            }
            return this;
        }

        public Builder<T> clear() {
            this.items = null;
            return this;
        }

        public boolean isEmpty() {
            return this.items == null || this.items.isEmpty();
        }

        public ImmutableUniqueList<T> build() {
            Object[] finalItems;
            if (this.items == null) {
                finalItems = (Object[])Array.newInstance(this.itemClass, 0);
            } else {
                finalItems = (Object[])Array.newInstance(this.itemClass, this.items.size());
                this.items.toArray(finalItems);
            }
            return new ImmutableUniqueList<Object>(5, finalItems);
        }
    }
}

