/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986.cmd;

import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.cmd.CmdBase;

public class CmdRelative {
    public static void main(String ... args) {
        if (args.length != 2) {
            System.err.println("Requires two arguments - base IRI and IRI to make relative.");
            System.exit(1);
        }
        String baseStr = CmdBase.fixup(args[0]);
        String relStr = CmdBase.fixup(args[1]);
        IRI3986 base = CmdBase.createOrExit(baseStr, "Bad base");
        IRI3986 target = CmdBase.createOrExit(relStr, "Bad IRI");
        if (!base.isAbsolute()) {
            System.err.println("Base must be an absolute IRI: '" + base + "'");
            System.exit(1);
        }
        IRI3986 result = base.relativize(target);
        System.out.println("Base:     " + base);
        System.out.println("IRI:      " + target);
        System.out.println();
        System.out.println("Relative: " + result);
        System.out.println();
        CmdBase.print(result);
    }
}

