/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.setup.ConfigRDFS;

public class CxtInf<X, T> {
    public final X ANY;
    public final X rdfType;
    public final X rdfsSubClassOf;
    public final X rdfsSubPropertyOf;
    public final X rdfsDomain;
    public final X rdfsRange;
    public final ConfigRDFS<X> setup;
    public final MapperX<X, T> mapper;

    protected CxtInf(ConfigRDFS<X> setup, MapperX<X, T> mapper) {
        this.setup = Objects.requireNonNull(setup);
        this.mapper = Objects.requireNonNull(mapper);
        this.ANY = mapper.fromNode(Node.ANY);
        this.rdfType = mapper.fromNode(ConstRDFS.rdfType);
        this.rdfsDomain = mapper.fromNode(ConstRDFS.rdfsDomain);
        this.rdfsRange = mapper.fromNode(ConstRDFS.rdfsRange);
        this.rdfsSubClassOf = mapper.fromNode(ConstRDFS.rdfsSubClassOf);
        this.rdfsSubPropertyOf = mapper.fromNode(ConstRDFS.rdfsSubPropertyOf);
    }

    protected X any(X x) {
        return x == null ? this.ANY : x;
    }

    protected boolean isANY(X x) {
        return x == null || x == this.ANY;
    }

    protected boolean isTerm(X x) {
        return !this.isANY(x);
    }
}

