/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets.prefixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;

public class PrefixesPlain
implements PrefixesAccess {
    private final TransactionalLock transactional;
    private Map<String, String> pairs = new ConcurrentHashMap<String, String>();

    public Map<String, String> getPairs() {
        return this.pairs;
    }

    public PrefixesPlain() {
        this.transactional = TransactionalLock.createMRSW();
    }

    @Override
    public Transactional transactional() {
        return this.transactional;
    }

    @Override
    public Optional<String> fetchURI(String prefix) {
        Objects.requireNonNull(prefix);
        return Optional.ofNullable(this.pairs.get(prefix));
    }

    @Override
    public void updatePrefix(String prefix, String uri) {
        this.pairs.put(prefix, uri);
    }

    @Override
    public void removePrefix(String prefixToRemove) {
        this.pairs.remove(prefixToRemove);
    }

    @Override
    public Map<String, String> getAll() {
        return this.pairs;
    }

    @Override
    public List<String> fetchPrefix(String uri) {
        Objects.requireNonNull(uri);
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String prefix : this.pairs.keySet()) {
            if (!this.pairs.get(prefix).equals(uri)) continue;
            prefixList.add(prefix);
        }
        return prefixList;
    }
}

