/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.server.Validators;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.GSPLib;
import org.apache.jena.fuseki.servlets.GSP_R;
import org.apache.jena.fuseki.servlets.GraphTarget;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.UploadRDF;
import org.apache.jena.fuseki.system.DataUploader;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.OperationDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphFactory;

public class GSP_RW
extends GSP_R {
    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        if (GSPLib.hasGSPParams(action)) {
            action.setResponseHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        } else {
            action.setResponseHeader("Allow", "GET,HEAD,OPTIONS,PUT,POST");
        }
        ServletOps.success(action);
    }

    @Override
    protected void doDelete(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execDeleteQuads(action);
        } else {
            this.execDeleteGSP(action);
        }
    }

    @Override
    protected void doPut(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execPutQuads(action);
        } else {
            this.execPutGSP(action);
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execPostQuads(action);
        } else {
            this.execPostGSP(action);
        }
    }

    protected void execPostGSP(HttpAction action) {
        this.doPutPostGSP(action, false);
    }

    protected void execPostQuads(HttpAction action) {
        this.doPutPostQuads(action, false);
    }

    protected void execPutGSP(HttpAction action) {
        this.doPutPostGSP(action, true);
    }

    protected void execPutQuads(HttpAction action) {
        this.doPutPostQuads(action, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execDeleteGSP(HttpAction action) {
        action.beginWrite();
        boolean haveCommited = false;
        try {
            boolean existedBefore;
            DatasetGraph dsg = this.decideDataset(action);
            GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("DELETE->" + target);
            }
            if (target.isUnion()) {
                ServletOps.errorBadRequest("Can't delete the union graph");
            }
            if (!(existedBefore = target.exists())) {
                action.commit();
                haveCommited = true;
                ServletOps.errorNotFound("No such graph: " + target.label());
            }
            GSP_RW.deleteGraph(dsg, action);
            action.commit();
            haveCommited = true;
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            action.abortSilent();
        }
        finally {
            action.endWrite();
        }
        ServletOps.successNoContent(action);
    }

    protected void execDeleteQuads(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }

    protected static void deleteGraph(DatasetGraph dsg, HttpAction action) {
        GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
        if (target.isDefault()) {
            GSP_RW.clearGraph(target);
        } else {
            target.dataset().removeGraph(target.graphName());
        }
    }

    protected static void clearGraph(GraphTarget target) {
        Graph g = target.graph();
        g.getPrefixMapping().clearNsPrefixMap();
        g.clear();
    }

    protected void doPutPostQuads(HttpAction action, boolean replaceOperation) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        UploadDetails details = action.isTransactional() ? UploadRDF.quadsPutPostTxn(action, a -> this.decideDataset((HttpAction)a), replaceOperation) : UploadRDF.quadsPutPostNonTxn(action, a -> this.decideDataset((HttpAction)a), replaceOperation);
        ServletOps.uploadResponse(action, details);
    }

    protected void doPutPostGSP(HttpAction action, boolean overwrite) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        UploadDetails details = action.isTransactional() ? this.triplesPutPostTxn(action, overwrite) : this.triplesPutPostNonTxn(action, overwrite);
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadDetails triplesPutPostTxn(HttpAction action, boolean replaceOperation) {
        UploadDetails uploadDetails;
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug(action.getRequestMethod().toUpperCase() + "->" + target);
            }
            if (target.isUnion()) {
                ServletOps.errorBadRequest("Can't load into the union graph");
            }
            if (!target.isDefault() && target.graphName() != null && !target.graphName().isBlank()) {
                String uri = target.graphName().getURI();
                try {
                    Validators.graphName(uri);
                }
                catch (FusekiConfigException ex) {
                    ServletOps.errorBadRequest("Bad URI: " + uri);
                    UploadDetails uploadDetails2 = null;
                    action.endWrite();
                    return uploadDetails2;
                }
            }
            boolean existedBefore = target.exists();
            Graph g = target.graph();
            if (replaceOperation && existedBefore) {
                GSP_RW.clearGraph(target);
            }
            StreamRDF sink = StreamRDFLib.graph(g);
            UploadDetails upload = DataUploader.incomingData(action, sink);
            upload.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails3 = upload;
            return uploadDetails3;
        }
        catch (RiotParseException ex) {
            action.abortSilent();
            ServletOps.errorParseError(ex);
            uploadDetails = null;
            return uploadDetails;
        }
        catch (RiotException ex) {
            action.abortSilent();
            ServletOps.errorBadRequest(ex.getMessage());
            uploadDetails = null;
            return uploadDetails;
        }
        catch (OperationDeniedException ex) {
            action.abortSilent();
            throw ex;
        }
        catch (ActionErrorException ex) {
            action.abortSilent();
            throw ex;
        }
        catch (Exception ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex.getMessage());
            uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadDetails triplesPutPostNonTxn(HttpAction action, boolean replaceOperation) {
        UploadDetails details;
        Graph graphTmp = GraphFactory.createGraphMem();
        StreamRDF dest = StreamRDFLib.graph(graphTmp);
        try {
            details = DataUploader.incomingData(action, dest);
        }
        catch (RiotParseException ex) {
            ServletOps.errorParseError(ex);
            return null;
        }
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("  ->" + target);
            }
            if (target.isUnion()) {
                ServletOps.errorBadRequest("Can't load into the union graph");
            }
            boolean existedBefore = target.exists();
            if (replaceOperation && existedBefore) {
                GSP_RW.clearGraph(target);
            }
            FusekiNetLib.addDataInto(graphTmp, target.dataset(), target.graphName());
            details.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = details;
            return uploadDetails;
        }
        catch (OperationDeniedException ex) {
            action.abortSilent();
            throw ex;
        }
        catch (Exception ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.endWrite();
        }
    }
}

