/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.enterprise.context.SessionScoped;
import org.omnifaces.cdi.PushContext;
import org.omnifaces.cdi.push.SocketChannelManager;
import org.omnifaces.cdi.push.SocketSessionManager;
import org.omnifaces.cdi.push.SocketUserManager;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Json;

public class SocketPushContext
implements PushContext {
    private static final long serialVersionUID = 1L;
    private String channel;
    private Map<String, String> sessionScopedChannels;
    private Map<String, String> viewScopedChannels;
    private SocketSessionManager socketSessions;
    private SocketUserManager socketUsers;

    SocketPushContext(String channel, SocketChannelManager socketChannels, SocketSessionManager socketSessions, SocketUserManager socketUsers) {
        this.channel = channel;
        boolean hasSession = Beans.isActive(SessionScoped.class);
        this.sessionScopedChannels = hasSession ? socketChannels.getSessionScopedChannels() : SocketChannelManager.EMPTY_SCOPE;
        this.viewScopedChannels = hasSession && Faces.hasContext() ? socketChannels.getViewScopedChannels(true) : SocketChannelManager.EMPTY_SCOPE;
        this.socketSessions = socketSessions;
        this.socketUsers = socketUsers;
    }

    @Override
    public Set<Future<Void>> send(Object message) {
        return this.socketSessions.send(SocketChannelManager.getChannelId(this.channel, this.sessionScopedChannels, this.viewScopedChannels), Json.encode(message));
    }

    @Override
    public <S extends Serializable> Set<Future<Void>> send(Object message, S user) {
        return this.send(message, Collections.singleton(user)).get(user);
    }

    @Override
    public <S extends Serializable> Map<S, Set<Future<Void>>> send(Object message, Collection<S> users) {
        HashMap resultsByUser = new HashMap(users.size());
        String json2 = Json.encode(message);
        for (Serializable user : users) {
            Set<String> channelIds = this.socketUsers.getChannelIds(user, this.channel);
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(channelIds.size());
            for (String channelId : channelIds) {
                results.addAll(this.socketSessions.send(channelId, json2));
            }
            resultsByUser.put(user, results);
        }
        return resultsByUser;
    }
}

