/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AbstractKnnVectorQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VectorUtil;

public class KnnFloatVectorQuery
extends AbstractKnnVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final float[] target;

    public KnnFloatVectorQuery(String field, float[] target, int k) {
        this(field, target, k, null);
    }

    public KnnFloatVectorQuery(String field, float[] target, int k, Query filter) {
        super(field, k, filter);
        this.target = VectorUtil.checkFinite(Objects.requireNonNull(target, "target"));
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context2, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, context2);
        LeafReader reader = context2.reader();
        FloatVectorValues floatVectorValues = reader.getFloatVectorValues(this.field);
        if (floatVectorValues == null) {
            FloatVectorValues.checkField(reader, this.field);
            return NO_RESULTS;
        }
        if (Math.min(knnCollector.k(), floatVectorValues.size()) == 0) {
            return NO_RESULTS;
        }
        reader.searchNearestVectors(this.field, this.target, knnCollector, acceptDocs);
        TopDocs results = knnCollector.topDocs();
        return results != null ? results : NO_RESULTS;
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context2, FieldInfo fi) throws IOException {
        LeafReader reader = context2.reader();
        FloatVectorValues vectorValues = reader.getFloatVectorValues(this.field);
        if (vectorValues == null) {
            FloatVectorValues.checkField(reader, this.field);
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + ":" + this.field + "[" + this.target[0] + ",...][" + this.k + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnnFloatVectorQuery that = (KnnFloatVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }

    public float[] getTargetCopy() {
        return ArrayUtil.copyArray(this.target);
    }
}

