/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.triple;

import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;

public class EmbeddedTripleFunctions {
    public static NodeValue fnTriple(NodeValue nv1, NodeValue nv2, NodeValue nv3) {
        Node s = nv1.asNode();
        Node p = nv2.asNode();
        if (!p.isURI()) {
            throw new ExprEvalException("triple: Predicate not a URI: " + nv2);
        }
        Node o = nv3.asNode();
        Node t = NodeFactory.createTripleNode(s, p, o);
        return NodeValue.makeNode(t);
    }

    public static NodeValue isTriple(NodeValue nv) {
        return NodeValue.booleanReturn(nv.asNode().isNodeTriple());
    }

    private static NodeValue tripleGetter(String name, NodeValue nv, Function<Triple, Node> accessor) {
        Node n = nv.asNode();
        if (!n.isNodeTriple()) {
            throw new ExprEvalException(name + ": Not a triple term: " + nv);
        }
        Triple t = n.getTriple();
        Node x = accessor.apply(t);
        return NodeValue.makeNode(x);
    }

    public static NodeValue tripleSubject(NodeValue nv) {
        return EmbeddedTripleFunctions.tripleGetter("subject", nv, Triple::getSubject);
    }

    public static NodeValue triplePredicate(NodeValue nv) {
        return EmbeddedTripleFunctions.tripleGetter("predicate", nv, Triple::getPredicate);
    }

    public static NodeValue tripleObject(NodeValue nv) {
        return EmbeddedTripleFunctions.tripleGetter("object", nv, Triple::getObject);
    }
}

