/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.function.Function;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.DataUploader;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.OperationDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class UploadRDF
extends ActionREST {
    @Override
    protected void doGet(HttpAction action) {
        this.unsupported(action);
    }

    @Override
    protected void doHead(HttpAction action) {
        this.unsupported(action);
    }

    @Override
    protected void doDelete(HttpAction action) {
        this.unsupported(action);
    }

    @Override
    protected void doPatch(HttpAction action) {
        this.unsupported(action);
    }

    private void unsupported(HttpAction action) {
        ServletOps.errorMethodNotAllowed(action.getMethod());
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    public void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "OPTIONS,PUT,POST");
        ServletOps.success(action);
    }

    @Override
    protected void doPut(HttpAction action) {
        this.execPutPost(action, true);
    }

    @Override
    protected void doPost(HttpAction action) {
        this.execPutPost(action, false);
    }

    private void execPutPost(HttpAction action, boolean replaceOperation) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        UploadDetails details = action.isTransactional() ? UploadRDF.quadsPutPostTxn(action, replaceOperation) : UploadRDF.quadsPutPostNonTxn(action, replaceOperation);
        ServletOps.uploadResponse(action, details);
    }

    public static UploadDetails quadsPutPostTxn(HttpAction action, boolean replaceOperation) {
        return UploadRDF.quadsPutPostTxn(action, a -> a.getDataset(), replaceOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadDetails quadsPutPostTxn(HttpAction action, Function<HttpAction, DatasetGraph> decideDataset, boolean replaceOperation) {
        UploadDetails details = null;
        action.beginWrite();
        try {
            DatasetGraph dsg = decideDataset.apply(action);
            if (replaceOperation) {
                dsg.clear();
            }
            StreamRDF dest = StreamRDFLib.dataset(dsg);
            details = DataUploader.incomingData(action, dest);
            action.commit();
        }
        catch (RiotException ex) {
            action.abortSilent();
            if (ex.getMessage() != null) {
                action.log.info(String.format("[%d] Data error: %s", action.id, ex.getMessage()));
            } else {
                action.log.info(String.format("[%d] Data error", action.id), ex);
            }
            ServletOps.errorBadRequest(ex.getMessage());
        }
        catch (OperationDeniedException ex) {
            action.abortSilent();
            throw ex;
        }
        catch (ActionErrorException ex) {
            action.abortSilent();
            if (ex.getMessage() != null) {
                action.log.info(String.format("[%d] Upload error: %s", action.id, ex.getMessage()));
            } else {
                action.log.info(String.format("[%d] Upload error", action.id), ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
        return details;
    }

    public static UploadDetails quadsPutPostNonTxn(HttpAction action, boolean replaceOperation) {
        return UploadRDF.quadsPutPostNonTxn(action, a -> a.getDataset(), replaceOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadDetails quadsPutPostNonTxn(HttpAction action, Function<HttpAction, DatasetGraph> decideDataset, boolean replaceOperation) {
        UploadDetails details;
        DatasetGraph dsgTmp = DatasetGraphFactory.create();
        StreamRDF dest = StreamRDFLib.dataset(dsgTmp);
        try {
            details = DataUploader.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return null;
        }
        action.beginWrite();
        try {
            DatasetGraph dsg = decideDataset.apply(action);
            if (replaceOperation) {
                dsg.clear();
            }
            FusekiNetLib.addDataInto(dsgTmp, dsg);
            action.commit();
        }
        catch (OperationDeniedException ex) {
            action.abortSilent();
            throw ex;
        }
        catch (Exception ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
        return details;
    }
}

