/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.prefixes.ActionPrefixesBase;
import org.apache.jena.fuseki.servlets.prefixes.PrefixUtils;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;
import org.apache.jena.fuseki.system.ConNeg;

public class ActionPrefixesR
extends ActionPrefixesBase {
    private static final String NO_PREFIX_NS = "";
    private static AcceptList acceptGET = AcceptList.create("text/plain", "application/json");
    private static MediaType dftMediaType = MediaType.create("application/json");

    @Override
    protected PrefixesAccess prefixes(HttpAction action) {
        return ActionPrefixesBase.prefixesFromAction(action);
    }

    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,OPTIONS");
        ServletOps.success(action);
    }

    protected ResponseTypes chooseResponseType(String prefix, String uri) {
        if (prefix == null && uri == null) {
            return ResponseTypes.GET_ALL;
        }
        if (prefix != null && uri == null) {
            if (prefix.isEmpty()) {
                ServletOps.errorBadRequest("Empty prefix!");
                return ResponseTypes.BAD_REQUEST;
            }
            if (!PrefixUtils.prefixIsValid(prefix)) {
                ServletOps.errorBadRequest("Prefix contains illegal characters!");
                return ResponseTypes.BAD_REQUEST;
            }
            return ResponseTypes.FETCH_URI;
        }
        if (prefix == null && uri != null) {
            if (uri.isEmpty()) {
                ServletOps.errorBadRequest("Empty URI!");
                return ResponseTypes.BAD_REQUEST;
            }
            if (!PrefixUtils.uriIsValid(uri)) {
                ServletOps.errorBadRequest("URI contains illegal characters!");
                return ResponseTypes.BAD_REQUEST;
            }
            return ResponseTypes.FETCH_PREFIX;
        }
        return ResponseTypes.BAD_REQUEST;
    }

    @Override
    protected void validatePrefixesGET(HttpAction action) {
        String prefix = action.getRequestParameter("prefix");
        String uri = action.getRequestParameter("uri");
        if (prefix != null && uri != null) {
            ServletOps.errorBadRequest("Provide only no paremetrs, or one of the prefix or uri!");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doGet(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        action.beginRead();
        try {
            String prefix = action.getRequestParameter("prefix");
            String uri = action.getRequestParameter("uri");
            PrefixesAccess prefixes = this.prefixes(action);
            switch (this.chooseResponseType(prefix, uri)) {
                case GET_ALL: {
                    this.execGetAll(action, prefixes);
                    return;
                }
                case FETCH_URI: {
                    this.execFetchURIByPrefix(action, prefixes, prefix);
                    return;
                }
                case FETCH_PREFIX: {
                    this.execFetchPrefixForURI(action, prefixes, uri);
                    return;
                }
                default: {
                    ServletOps.errorBadRequest("Bad request");
                    return;
                }
            }
        }
        catch (ActionErrorException prefix) {
            return;
        }
        catch (RuntimeException ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex);
            return;
        }
        finally {
            action.endRead();
        }
    }

    private void execGetAll(HttpAction action, PrefixesAccess prefixes) {
        Map<String, String> allPairs = prefixes.getAll();
        JsonArray allJsonPairs = new JsonArray();
        allPairs.entrySet().stream().forEach(entry -> {
            JsonObject jsonObject = ActionPrefixesR.jsonObject((String)entry.getKey(), (String)entry.getValue());
            allJsonPairs.add(jsonObject);
            FmtLog.debug(action.log, "[%d] Entry: %s: <%s>", action.id, entry.getKey(), entry.getValue());
        });
        FmtLog.info(action.log, "[%d] - Get all prefix mappings", action.id);
        ServletOps.success(action);
        try {
            action.setResponseContentType("application/json");
            action.getResponseOutputStream().print(String.valueOf(allJsonPairs));
            ServletOps.success(action);
        }
        catch (IOException ex) {
            FmtLog.warn(action.log, "[%d] Get all prefixes: Failed to send response: %s", action.id, ex.getMessage());
            ServletOps.errorOccurred(ex);
        }
    }

    private static JsonObject jsonObject(String prefix, String uri) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("prefix", prefix);
        jsonObject.addProperty("uri", uri);
        return jsonObject;
    }

    private void execFetchURIByPrefix(HttpAction action, PrefixesAccess prefixes, String prefix) {
        Optional<String> x = prefixes.fetchURI(prefix);
        String namespace2 = x.orElse(NO_PREFIX_NS);
        try {
            String ctString;
            MediaType mt = ConNeg.chooseContentType(action.getRequest(), acceptGET, dftMediaType);
            switch (ctString = mt.getContentTypeStr()) {
                case "text/plain": {
                    ActionPrefixesR.responseText(action, prefix, namespace2);
                    break;
                }
                case "application/json": {
                    ActionPrefixesR.responseJSON(action, prefix, namespace2);
                    break;
                }
                default: {
                    ServletOps.error(415);
                }
            }
            FmtLog.info(action.log, "[%d] %s -> %s", action.id, prefix, namespace2);
            ServletOps.success(action);
        }
        catch (IOException ex) {
            FmtLog.warn(action.log, "[%d] Fetch URI by prefix: Failed to send response: %s", action.id, ex.getMessage());
            ServletOps.errorOccurred(ex);
        }
        FmtLog.info(action.log, "[%d] %s -> %s", action.id, prefix, namespace2);
        action.commit();
        ServletOps.success(action);
    }

    private static void responseJSON(HttpAction action, String prefix, String uri) throws IOException {
        action.setResponseContentType("application/json");
        JsonObject jObj = ActionPrefixesR.jsonObject(prefix, uri);
        action.getResponseOutputStream().print(String.valueOf(jObj));
    }

    private static void responseText(HttpAction action, String prefix, String uri) throws IOException {
        action.setResponseContentType("text/plain");
        action.getResponseOutputStream().print(uri);
    }

    private void execFetchPrefixForURI(HttpAction action, PrefixesAccess prefixes, String uri) {
        List<String> prefixList = prefixes.fetchPrefix(uri);
        JsonArray prefixJsonArray = new JsonArray();
        for (String p : prefixList) {
            JsonObject jsonObject2 = ActionPrefixesR.jsonObject(p, uri);
            prefixJsonArray.add(jsonObject2);
        }
        FmtLog.info(action.log, "[%d] PrefixForURI: %s: %s", action.id, String.valueOf(prefixJsonArray));
        try {
            action.setResponseContentType("application/json");
            action.getResponseOutputStream().print(String.valueOf(prefixJsonArray));
        }
        catch (IOException ex) {
            FmtLog.warn(action.log, "[%d] Fetch prefixes for URI: Failed to send response: %s", action.id, ex.getMessage());
            ServletOps.errorOccurred(ex);
        }
        action.commit();
        ServletOps.success(action);
        action.endRead();
    }

    static enum ResponseTypes {
        GET_ALL,
        FETCH_URI,
        FETCH_PREFIX,
        BAD_REQUEST;

    }
}

