/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonValue;

public class JsonAccess {
    public static JsonValue accessPath(JsonValue obj, String ... path) {
        for (String p : path) {
            if (!obj.isObject()) {
                throw new JsonException("Path traverses non-object");
            }
            obj = obj.getAsObject().get(p);
        }
        return obj;
    }

    public static JsonValue access(JsonValue obj, Object ... path) {
        for (Object p : path) {
            if (p instanceof String) {
                if (!obj.isObject()) {
                    throw new JsonException("Path traverses non-object");
                }
                obj = obj.getAsObject().get((String)p);
            }
            if (!(p instanceof Integer)) continue;
            if (!obj.isArray()) {
                throw new JsonException("Path traverses non-array");
            }
            obj = obj.getAsArray().get((Integer)p);
        }
        return obj;
    }
}

