/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.omnifaces.component.script.OnloadScript;
import org.omnifaces.util.Components;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.component.script.Highlight")
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js", target="head"), @ResourceDependency(library="omnifaces", name="omnifaces.js", target="head")})
public class Highlight
extends OnloadScript {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.script.Highlight";
    private static final Set<VisitHint> VISIT_HINTS = EnumSet.of(VisitHint.SKIP_UNRENDERED);
    private static final String DEFAULT_STYLECLASS = "error";
    private static final Boolean DEFAULT_FOCUS = Boolean.TRUE;
    private static final String SCRIPT = "OmniFaces.Highlight.apply([%s], '%s', %s);";
    private final State state = new State(this.getStateHelper());

    public void encodeChildren(FacesContext context2) throws IOException {
        UIForm form = Components.getCurrentForm();
        if (form == null) {
            return;
        }
        StringBuilder clientIds = new StringBuilder();
        form.visitTree(VisitContext.createVisitContext((FacesContext)context2, null, VISIT_HINTS), (visitContext, component) -> {
            if (component instanceof UIInput && !((UIInput)component).isValid()) {
                if (clientIds.length() > 0) {
                    clientIds.append(',');
                }
                String clientId = component.getClientId(visitContext.getFacesContext());
                clientIds.append('\"').append(clientId).append('\"');
            }
            return VisitResult.ACCEPT;
        });
        if (clientIds.length() > 0) {
            context2.getResponseWriter().write(String.format(SCRIPT, clientIds, this.getStyleClass(), this.isFocus()));
        }
    }

    public boolean isRendered() {
        FacesContext context2 = this.getFacesContext();
        return context2.isPostback() && context2.isValidationFailed() && super.isRendered();
    }

    public String getStyleClass() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.styleClass), DEFAULT_STYLECLASS);
    }

    public void setStyleClass(String styleClass) {
        this.state.put((Serializable)((Object)PropertyKeys.styleClass), styleClass);
    }

    public boolean isFocus() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.focus), DEFAULT_FOCUS);
    }

    public void setFocus(boolean focus) {
        this.state.put((Serializable)((Object)PropertyKeys.focus), focus);
    }

    private static enum PropertyKeys {
        styleClass,
        focus;

    }
}

