/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.io.Serializable;
import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.DefaultSubjectFactory;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionContext;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityManager
extends SessionsSecurityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityManager.class);
    protected RememberMeManager rememberMeManager;
    protected SubjectDAO subjectDAO;
    protected SubjectFactory subjectFactory = new DefaultSubjectFactory();

    public DefaultSecurityManager() {
        this.subjectDAO = new DefaultSubjectDAO();
    }

    public DefaultSecurityManager(Realm singleRealm) {
        this();
        this.setRealm(singleRealm);
    }

    public DefaultSecurityManager(Collection<Realm> realms) {
        this();
        this.setRealms(realms);
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public SubjectDAO getSubjectDAO() {
        return this.subjectDAO;
    }

    public void setSubjectDAO(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    public RememberMeManager getRememberMeManager() {
        return this.rememberMeManager;
    }

    public void setRememberMeManager(RememberMeManager rememberMeManager) {
        this.rememberMeManager = rememberMeManager;
    }

    protected SubjectContext createSubjectContext() {
        return new DefaultSubjectContext();
    }

    protected Subject createSubject(AuthenticationToken token, AuthenticationInfo info, Subject existing) {
        SubjectContext context2 = this.createSubjectContext();
        context2.setAuthenticated(true);
        context2.setAuthenticationToken(token);
        context2.setAuthenticationInfo(info);
        context2.setSecurityManager(this);
        if (existing != null) {
            context2.setSubject(existing);
        }
        return this.createSubject(context2);
    }

    @Deprecated
    protected void bind(Subject subject) {
        this.save(subject);
    }

    protected void rememberMeSuccessfulLogin(AuthenticationToken token, AuthenticationInfo info, Subject subject) {
        RememberMeManager rmm = this.getRememberMeManager();
        if (rmm != null) {
            try {
                rmm.onSuccessfulLogin(subject, token, info);
            }
            catch (Exception e2) {
                if (LOGGER.isWarnEnabled()) {
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onSuccessfulLogin.  RememberMe services will not be performed for account [" + String.valueOf(info) + "].";
                    LOGGER.warn(msg, e2);
                }
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("This " + this.getClass().getName() + " instance does not have a [" + RememberMeManager.class.getName() + "] instance configured.  RememberMe services will not be performed for account [" + String.valueOf(info) + "].");
        }
    }

    protected void rememberMeFailedLogin(AuthenticationToken token, AuthenticationException ex, Subject subject) {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    rmm.onFailedLogin(subject, token, ex);
                }
                catch (Exception e2) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onFailedLogin for AuthenticationToken [" + String.valueOf(token) + "].";
                    LOGGER.warn(msg, e2);
                }
            }
        }
    }

    protected void rememberMeLogout(Subject subject) {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    rmm.onLogout(subject);
                }
                catch (Exception e2) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onLogout for subject with principals [" + String.valueOf(subject != null ? subject.getPrincipals() : null) + "]";
                    LOGGER.warn(msg, e2);
                }
            }
        }
    }

    @Override
    public Subject login(Subject subject, AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        try {
            info = this.authenticate(token);
        }
        catch (AuthenticationException ae) {
            block4: {
                try {
                    this.onFailedLogin(token, ae, subject);
                }
                catch (Exception e2) {
                    if (!LOGGER.isInfoEnabled()) break block4;
                    LOGGER.info("onFailedLogin method threw an exception.  Logging and propagating original AuthenticationException.", e2);
                }
            }
            throw ae;
        }
        Subject loggedIn = this.createSubject(token, info, subject);
        this.onSuccessfulLogin(token, info, loggedIn);
        return loggedIn;
    }

    protected void onSuccessfulLogin(AuthenticationToken token, AuthenticationInfo info, Subject subject) {
        this.rememberMeSuccessfulLogin(token, info, subject);
    }

    protected void onFailedLogin(AuthenticationToken token, AuthenticationException ae, Subject subject) {
        this.rememberMeFailedLogin(token, ae, subject);
    }

    protected void beforeLogout(Subject subject) {
        this.rememberMeLogout(subject);
    }

    protected SubjectContext copy(SubjectContext subjectContext) {
        return new DefaultSubjectContext(subjectContext);
    }

    @Override
    public Subject createSubject(SubjectContext subjectContext) {
        SubjectContext context2 = this.copy(subjectContext);
        context2 = this.ensureSecurityManager(context2);
        context2 = this.resolveSession(context2);
        context2 = this.resolvePrincipals(context2);
        Subject subject = this.doCreateSubject(context2);
        if (subjectContext.isSessionCreationEnabled()) {
            this.save(subject);
        }
        return subject;
    }

    protected Subject doCreateSubject(SubjectContext context2) {
        return this.getSubjectFactory().createSubject(context2);
    }

    protected void save(Subject subject) {
        this.subjectDAO.save(subject);
    }

    protected void delete(Subject subject) {
        this.subjectDAO.delete(subject);
    }

    protected SubjectContext ensureSecurityManager(SubjectContext context2) {
        if (context2.resolveSecurityManager() != null) {
            LOGGER.trace("Context already contains a SecurityManager instance.  Returning.");
            return context2;
        }
        LOGGER.trace("No SecurityManager found in context.  Adding self reference.");
        context2.setSecurityManager(this);
        return context2;
    }

    protected SubjectContext resolveSession(SubjectContext context2) {
        if (context2.resolveSession() != null) {
            LOGGER.debug("Context already contains a session.  Returning.");
            return context2;
        }
        try {
            Session session = this.resolveContextSession(context2);
            if (session != null) {
                context2.setSession(session);
            }
        }
        catch (InvalidSessionException e2) {
            LOGGER.debug("Resolved SubjectContext context session is invalid.  Ignoring and creating an anonymous (session-less) Subject instance.", e2);
        }
        return context2;
    }

    protected Session resolveContextSession(SubjectContext context2) throws InvalidSessionException {
        SessionKey key = this.getSessionKey(context2);
        if (key != null) {
            return this.getSession(key);
        }
        return null;
    }

    protected SessionKey getSessionKey(SubjectContext context2) {
        Serializable sessionId = context2.getSessionId();
        if (sessionId != null) {
            return new DefaultSessionKey(sessionId);
        }
        return null;
    }

    private static boolean isEmpty(PrincipalCollection pc) {
        return pc == null || pc.isEmpty();
    }

    protected SubjectContext resolvePrincipals(SubjectContext context2) {
        PrincipalCollection principals = context2.resolvePrincipals();
        if (DefaultSecurityManager.isEmpty(principals)) {
            LOGGER.trace("No identity (PrincipalCollection) found in the context.  Looking for a remembered identity.");
            principals = this.getRememberedIdentity(context2);
            if (!DefaultSecurityManager.isEmpty(principals)) {
                LOGGER.debug("Found remembered PrincipalCollection.  Adding to the context to be used for subject construction by the SubjectFactory.");
                context2.setPrincipals(principals);
            } else {
                LOGGER.trace("No remembered identity found.  Returning original context.");
            }
        }
        return context2;
    }

    protected SessionContext createSessionContext(SubjectContext subjectContext) {
        String host;
        Serializable sessionId;
        DefaultSessionContext sessionContext = new DefaultSessionContext();
        if (!CollectionUtils.isEmpty(subjectContext)) {
            sessionContext.putAll(subjectContext);
        }
        if ((sessionId = subjectContext.getSessionId()) != null) {
            sessionContext.setSessionId(sessionId);
        }
        if ((host = subjectContext.resolveHost()) != null) {
            sessionContext.setHost(host);
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(Subject subject) {
        Object msg;
        if (subject == null) {
            throw new IllegalArgumentException("Subject method argument cannot be null.");
        }
        this.beforeLogout(subject);
        PrincipalCollection principals = subject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            Authenticator authc;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Logging out subject with primary principal {}", principals.getPrimaryPrincipal());
            }
            if ((authc = this.getAuthenticator()) instanceof LogoutAware) {
                ((LogoutAware)((Object)authc)).onLogout(principals);
            }
        }
        try {
            this.delete(subject);
        }
        catch (Exception e2) {
            if (LOGGER.isDebugEnabled()) {
                msg = "Unable to cleanly unbind Subject.  Ignoring (logging out).";
                LOGGER.debug((String)msg, e2);
            }
        }
        finally {
            block17: {
                try {
                    this.stopSession(subject);
                }
                catch (Exception e3) {
                    if (!LOGGER.isDebugEnabled()) break block17;
                    msg = "Unable to cleanly stop Session for Subject [" + String.valueOf(subject.getPrincipal()) + "] Ignoring (logging out).";
                    LOGGER.debug((String)msg, e3);
                }
            }
        }
    }

    protected void stopSession(Subject subject) {
        Session s = subject.getSession(false);
        if (s != null) {
            s.stop();
        }
    }

    @Deprecated
    protected void unbind(Subject subject) {
        this.delete(subject);
    }

    protected PrincipalCollection getRememberedIdentity(SubjectContext subjectContext) {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    return rmm.getRememberedPrincipals(subjectContext);
                }
                catch (Exception e2) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during getRememberedPrincipals().";
                    LOGGER.warn(msg, e2);
                }
            }
        }
        return null;
    }
}

