/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.VectorFieldFunction;
import org.apache.lucene.search.DocIdSetIterator;

public class ByteKnnVectorFieldSource
extends ValueSource {
    private final String fieldName;

    public ByteKnnVectorFieldSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context2, LeafReaderContext readerContext) throws IOException {
        LeafReader reader = readerContext.reader();
        final ByteVectorValues vectorValues = reader.getByteVectorValues(this.fieldName);
        if (vectorValues == null) {
            VectorFieldFunction.checkField(reader, this.fieldName, VectorEncoding.BYTE);
            return new VectorFieldFunction(this){
                private final DocIdSetIterator empty;
                {
                    this.empty = DocIdSetIterator.empty();
                }

                @Override
                public byte[] byteVectorVal(int doc) throws IOException {
                    return null;
                }

                @Override
                protected DocIdSetIterator getVectorIterator() {
                    return this.empty;
                }
            };
        }
        return new VectorFieldFunction(this){

            @Override
            public byte[] byteVectorVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return vectorValues.vectorValue();
                }
                return null;
            }

            @Override
            protected DocIdSetIterator getVectorIterator() {
                return vectorValues;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteKnnVectorFieldSource other = (ByteKnnVectorFieldSource)o;
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().hashCode(), this.fieldName);
    }

    @Override
    public String description() {
        return "ByteKnnVectorFieldSource(" + this.fieldName + ")";
    }
}

