/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene95;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;

public abstract class OffHeapFloatVectorValues
extends FloatVectorValues
implements RandomAccessVectorValues.Floats {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] value;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer flatVectorsScorer;

    OffHeapFloatVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.similarityFunction = similarityFunction;
        this.flatVectorsScorer = flatVectorsScorer;
        this.value = new float[dimension];
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    @Override
    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        this.lastOrd = targetOrd;
        return this.value;
    }

    public static OffHeapFloatVectorValues load(VectorSimilarityFunction vectorSimilarityFunction, FlatVectorsScorer flatVectorsScorer, OrdToDocDISIReaderConfiguration configuration, VectorEncoding vectorEncoding, int dimension, long vectorDataOffset, long vectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.docsWithFieldOffset == -2L || vectorEncoding != VectorEncoding.FLOAT32) {
            return new EmptyOffHeapVectorValues(dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", vectorDataOffset, vectorDataLength);
        int byteSize = dimension * 4;
        if (configuration.docsWithFieldOffset == -1L) {
            return new DenseOffHeapVectorValues(dimension, configuration.size, bytesSlice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
        }
        return new SparseOffHeapVectorValues(configuration, vectorData, bytesSlice, dimension, byteSize, flatVectorsScorer, vectorSimilarityFunction);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, 0, null, 0, flatVectorsScorer, similarityFunction);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public float[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public EmptyOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] query2) {
            return null;
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, IndexInput dataIn, IndexInput slice, int dimension, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) throws IOException {
            super(dimension, configuration.size, slice, byteSize, flatVectorsScorer, similarityFunction);
            this.configuration = configuration;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(configuration.addressesOffset, configuration.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(configuration.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, configuration.docsWithFieldOffset, configuration.docsWithFieldLength, configuration.jumpTableEntryCount, configuration.denseRankPower, configuration.size);
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.vectorValue(this.disi.index());
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dataIn, this.slice.clone(), this.dimension, this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public VectorScorer scorer(float[] query2) throws IOException {
            final SparseOffHeapVectorValues copy = this.copy();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (RandomAccessVectorValues)copy, query2);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return randomVectorScorer.score(copy.disi.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return copy;
                }
            };
        }
    }

    public static class DenseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
            super(dimension, size, slice, byteSize, flatVectorsScorer, similarityFunction);
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.vectorValue(this.doc);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] query2) throws IOException {
            final DenseOffHeapVectorValues copy = this.copy();
            final RandomVectorScorer randomVectorScorer = this.flatVectorsScorer.getRandomVectorScorer(this.similarityFunction, (RandomAccessVectorValues)copy, query2);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return randomVectorScorer.score(copy.doc);
                }

                @Override
                public DocIdSetIterator iterator() {
                    return copy;
                }
            };
        }
    }
}

