/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import java.util.Map;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.core.assembler.NamedDatasetAssembler;
import org.apache.jena.vocabulary.RDF;

public class InMemDatasetAssembler
extends NamedDatasetAssembler {
    @Override
    public Map<String, DatasetGraph> pool() {
        return sharedDatasetPool;
    }

    public static Resource getType() {
        return DatasetAssemblerVocab.tMemoryDataset;
    }

    @Override
    public DatasetGraph createDataset(Assembler a, Resource root2) {
        if (!root2.hasProperty(RDF.type, DatasetAssemblerVocab.tDatasetTxnMem)) {
            this.checkType(root2, DatasetAssemblerVocab.tMemoryDataset);
        }
        DatasetGraph dataset = DatasetGraphFactory.createTxnMem();
        AssemblerUtils.loadData(dataset, root2);
        AssemblerUtils.mergeContext(root2, dataset.getContext());
        return dataset;
    }
}

